package org.cloudfoundry.client.v3.processes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.PaginatedRequest;
import org.immutables.value.Generated;

/**
 * The request payload for the List Processes operation
 */
@Generated(from = "_ListProcessesRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ListProcessesRequest extends org.cloudfoundry.client.v3.processes._ListProcessesRequest {
  private final @Nullable String orderBy;
  private final @Nullable Integer page;
  private final @Nullable Integer perPage;
  private final List<String> applicationIds;
  private final List<String> organizationIds;
  private final List<String> processIds;
  private final List<String> spaceIds;
  private final List<String> types;

  private ListProcessesRequest(ListProcessesRequest.Builder builder) {
    this.orderBy = builder.orderBy;
    this.page = builder.page;
    this.perPage = builder.perPage;
    this.applicationIds = createUnmodifiableList(true, builder.applicationIds);
    this.organizationIds = createUnmodifiableList(true, builder.organizationIds);
    this.processIds = createUnmodifiableList(true, builder.processIds);
    this.spaceIds = createUnmodifiableList(true, builder.spaceIds);
    this.types = createUnmodifiableList(true, builder.types);
  }

  /**
   * The order by
   */
  @Override
  public @Nullable String getOrderBy() {
    return orderBy;
  }

  /**
   * The page
   */
  @Override
  public @Nullable Integer getPage() {
    return page;
  }

  /**
   * The results per page
   */
  @Override
  public @Nullable Integer getPerPage() {
    return perPage;
  }

  /**
   * List of application ids to filter by
   */
  @Override
  public List<String> getApplicationIds() {
    return applicationIds;
  }

  /**
   * List of organization ids to filter by
   */
  @Override
  public List<String> getOrganizationIds() {
    return organizationIds;
  }

  /**
   * List of process ids to filter by
   */
  @Override
  public List<String> getProcessIds() {
    return processIds;
  }

  /**
   * List of space ids to filter by
   */
  @Override
  public List<String> getSpaceIds() {
    return spaceIds;
  }

  /**
   * List of process types to filter by
   */
  @Override
  public List<String> getTypes() {
    return types;
  }

  /**
   * This instance is equal to all instances of {@code ListProcessesRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ListProcessesRequest
        && equalTo(0, (ListProcessesRequest) another);
  }

  private boolean equalTo(int synthetic, ListProcessesRequest another) {
    return Objects.equals(orderBy, another.orderBy)
        && Objects.equals(page, another.page)
        && Objects.equals(perPage, another.perPage)
        && applicationIds.equals(another.applicationIds)
        && organizationIds.equals(another.organizationIds)
        && processIds.equals(another.processIds)
        && spaceIds.equals(another.spaceIds)
        && types.equals(another.types);
  }

  /**
   * Computes a hash code from attributes: {@code orderBy}, {@code page}, {@code perPage}, {@code applicationIds}, {@code organizationIds}, {@code processIds}, {@code spaceIds}, {@code types}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(orderBy);
    h += (h << 5) + Objects.hashCode(page);
    h += (h << 5) + Objects.hashCode(perPage);
    h += (h << 5) + applicationIds.hashCode();
    h += (h << 5) + organizationIds.hashCode();
    h += (h << 5) + processIds.hashCode();
    h += (h << 5) + spaceIds.hashCode();
    h += (h << 5) + types.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ListProcessesRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ListProcessesRequest{"
        + "orderBy=" + orderBy
        + ", page=" + page
        + ", perPage=" + perPage
        + ", applicationIds=" + applicationIds
        + ", organizationIds=" + organizationIds
        + ", processIds=" + processIds
        + ", spaceIds=" + spaceIds
        + ", types=" + types
        + "}";
  }

  private static ListProcessesRequest validate(ListProcessesRequest instance) {
    instance.check();
    return instance;
  }

  /**
   * Creates a builder for {@link ListProcessesRequest ListProcessesRequest}.
   * <pre>
   * ListProcessesRequest.builder()
   *    .orderBy(String | null) // nullable {@link ListProcessesRequest#getOrderBy() orderBy}
   *    .page(Integer | null) // nullable {@link ListProcessesRequest#getPage() page}
   *    .perPage(Integer | null) // nullable {@link ListProcessesRequest#getPerPage() perPage}
   *    .applicationId|addAllApplicationIds(String) // {@link ListProcessesRequest#getApplicationIds() applicationIds} elements
   *    .organizationId|addAllOrganizationIds(String) // {@link ListProcessesRequest#getOrganizationIds() organizationIds} elements
   *    .processId|addAllProcessIds(String) // {@link ListProcessesRequest#getProcessIds() processIds} elements
   *    .spaceId|addAllSpaceIds(String) // {@link ListProcessesRequest#getSpaceIds() spaceIds} elements
   *    .type|addAllTypes(String) // {@link ListProcessesRequest#getTypes() types} elements
   *    .build();
   * </pre>
   * @return A new ListProcessesRequest builder
   */
  public static ListProcessesRequest.Builder builder() {
    return new ListProcessesRequest.Builder();
  }

  /**
   * Builds instances of type {@link ListProcessesRequest ListProcessesRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_ListProcessesRequest", generator = "Immutables")
  public static final class Builder {
    private String orderBy;
    private Integer page;
    private Integer perPage;
    private List<String> applicationIds = new ArrayList<String>();
    private List<String> organizationIds = new ArrayList<String>();
    private List<String> processIds = new ArrayList<String>();
    private List<String> spaceIds = new ArrayList<String>();
    private List<String> types = new ArrayList<String>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ListProcessesRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ListProcessesRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _ListProcessesRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(_ListProcessesRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.client.v3.PaginatedRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(PaginatedRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    private void from(short _unused, Object object) {
      if (object instanceof org.cloudfoundry.client.v3.processes._ListProcessesRequest) {
        org.cloudfoundry.client.v3.processes._ListProcessesRequest instance = (org.cloudfoundry.client.v3.processes._ListProcessesRequest) object;
        addAllProcessIds(instance.getProcessIds());
        addAllTypes(instance.getTypes());
        addAllSpaceIds(instance.getSpaceIds());
        addAllOrganizationIds(instance.getOrganizationIds());
        addAllApplicationIds(instance.getApplicationIds());
      }
      if (object instanceof PaginatedRequest) {
        PaginatedRequest instance = (PaginatedRequest) object;
        String orderByValue = instance.getOrderBy();
        if (orderByValue != null) {
          orderBy(orderByValue);
        }
        Integer perPageValue = instance.getPerPage();
        if (perPageValue != null) {
          perPage(perPageValue);
        }
        Integer pageValue = instance.getPage();
        if (pageValue != null) {
          page(pageValue);
        }
      }
    }

    /**
     * Initializes the value for the {@link ListProcessesRequest#getOrderBy() orderBy} attribute.
     * @param orderBy The value for orderBy (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder orderBy(@Nullable String orderBy) {
      this.orderBy = orderBy;
      return this;
    }

    /**
     * Initializes the value for the {@link ListProcessesRequest#getPage() page} attribute.
     * @param page The value for page (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder page(@Nullable Integer page) {
      this.page = page;
      return this;
    }

    /**
     * Initializes the value for the {@link ListProcessesRequest#getPerPage() perPage} attribute.
     * @param perPage The value for perPage (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder perPage(@Nullable Integer perPage) {
      this.perPage = perPage;
      return this;
    }

    /**
     * Adds one element to {@link ListProcessesRequest#getApplicationIds() applicationIds} list.
     * @param element A applicationIds element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder applicationId(String element) {
      this.applicationIds.add(Objects.requireNonNull(element, "applicationIds element"));
      return this;
    }

    /**
     * Adds elements to {@link ListProcessesRequest#getApplicationIds() applicationIds} list.
     * @param elements An array of applicationIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder applicationIds(String... elements) {
      for (String element : elements) {
        this.applicationIds.add(Objects.requireNonNull(element, "applicationIds element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListProcessesRequest#getApplicationIds() applicationIds} list.
     * @param elements An iterable of applicationIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder applicationIds(Iterable<String> elements) {
      this.applicationIds.clear();
      return addAllApplicationIds(elements);
    }

    /**
     * Adds elements to {@link ListProcessesRequest#getApplicationIds() applicationIds} list.
     * @param elements An iterable of applicationIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllApplicationIds(Iterable<String> elements) {
      for (String element : elements) {
        this.applicationIds.add(Objects.requireNonNull(element, "applicationIds element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link ListProcessesRequest#getOrganizationIds() organizationIds} list.
     * @param element A organizationIds element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder organizationId(String element) {
      this.organizationIds.add(Objects.requireNonNull(element, "organizationIds element"));
      return this;
    }

    /**
     * Adds elements to {@link ListProcessesRequest#getOrganizationIds() organizationIds} list.
     * @param elements An array of organizationIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder organizationIds(String... elements) {
      for (String element : elements) {
        this.organizationIds.add(Objects.requireNonNull(element, "organizationIds element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListProcessesRequest#getOrganizationIds() organizationIds} list.
     * @param elements An iterable of organizationIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder organizationIds(Iterable<String> elements) {
      this.organizationIds.clear();
      return addAllOrganizationIds(elements);
    }

    /**
     * Adds elements to {@link ListProcessesRequest#getOrganizationIds() organizationIds} list.
     * @param elements An iterable of organizationIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllOrganizationIds(Iterable<String> elements) {
      for (String element : elements) {
        this.organizationIds.add(Objects.requireNonNull(element, "organizationIds element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link ListProcessesRequest#getProcessIds() processIds} list.
     * @param element A processIds element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder processId(String element) {
      this.processIds.add(Objects.requireNonNull(element, "processIds element"));
      return this;
    }

    /**
     * Adds elements to {@link ListProcessesRequest#getProcessIds() processIds} list.
     * @param elements An array of processIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder processIds(String... elements) {
      for (String element : elements) {
        this.processIds.add(Objects.requireNonNull(element, "processIds element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListProcessesRequest#getProcessIds() processIds} list.
     * @param elements An iterable of processIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder processIds(Iterable<String> elements) {
      this.processIds.clear();
      return addAllProcessIds(elements);
    }

    /**
     * Adds elements to {@link ListProcessesRequest#getProcessIds() processIds} list.
     * @param elements An iterable of processIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllProcessIds(Iterable<String> elements) {
      for (String element : elements) {
        this.processIds.add(Objects.requireNonNull(element, "processIds element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link ListProcessesRequest#getSpaceIds() spaceIds} list.
     * @param element A spaceIds element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder spaceId(String element) {
      this.spaceIds.add(Objects.requireNonNull(element, "spaceIds element"));
      return this;
    }

    /**
     * Adds elements to {@link ListProcessesRequest#getSpaceIds() spaceIds} list.
     * @param elements An array of spaceIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder spaceIds(String... elements) {
      for (String element : elements) {
        this.spaceIds.add(Objects.requireNonNull(element, "spaceIds element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListProcessesRequest#getSpaceIds() spaceIds} list.
     * @param elements An iterable of spaceIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder spaceIds(Iterable<String> elements) {
      this.spaceIds.clear();
      return addAllSpaceIds(elements);
    }

    /**
     * Adds elements to {@link ListProcessesRequest#getSpaceIds() spaceIds} list.
     * @param elements An iterable of spaceIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllSpaceIds(Iterable<String> elements) {
      for (String element : elements) {
        this.spaceIds.add(Objects.requireNonNull(element, "spaceIds element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link ListProcessesRequest#getTypes() types} list.
     * @param element A types element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder type(String element) {
      this.types.add(Objects.requireNonNull(element, "types element"));
      return this;
    }

    /**
     * Adds elements to {@link ListProcessesRequest#getTypes() types} list.
     * @param elements An array of types elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder types(String... elements) {
      for (String element : elements) {
        this.types.add(Objects.requireNonNull(element, "types element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListProcessesRequest#getTypes() types} list.
     * @param elements An iterable of types elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder types(Iterable<String> elements) {
      this.types.clear();
      return addAllTypes(elements);
    }

    /**
     * Adds elements to {@link ListProcessesRequest#getTypes() types} list.
     * @param elements An iterable of types elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllTypes(Iterable<String> elements) {
      for (String element : elements) {
        this.types.add(Objects.requireNonNull(element, "types element"));
      }
      return this;
    }

    /**
     * Builds a new {@link ListProcessesRequest ListProcessesRequest}.
     * @return An immutable instance of ListProcessesRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ListProcessesRequest build() {
      return ListProcessesRequest.validate(new ListProcessesRequest(this));
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>(size);
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
