package org.cloudfoundry.client.v3.processes;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.ToOneRelationship;
import org.immutables.value.Generated;

/**
 * The relationships for the Process entity
 */
@Generated(from = "_ProcessRelationships", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ProcessRelationships extends org.cloudfoundry.client.v3.processes._ProcessRelationships {
  private final @Nullable ToOneRelationship app;
  private final @Nullable ToOneRelationship revision;

  private ProcessRelationships(ProcessRelationships.Builder builder) {
    this.app = builder.app;
    this.revision = builder.revision;
  }

  /**
   * The app relationship
   */
  @JsonProperty("app")
  @Override
  public @Nullable ToOneRelationship getApp() {
    return app;
  }

  /**
   * The revision relationship
   */
  @JsonProperty("revision")
  @Override
  public @Nullable ToOneRelationship getRevision() {
    return revision;
  }

  /**
   * This instance is equal to all instances of {@code ProcessRelationships} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ProcessRelationships
        && equalTo(0, (ProcessRelationships) another);
  }

  private boolean equalTo(int synthetic, ProcessRelationships another) {
    return Objects.equals(app, another.app)
        && Objects.equals(revision, another.revision);
  }

  /**
   * Computes a hash code from attributes: {@code app}, {@code revision}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(app);
    h += (h << 5) + Objects.hashCode(revision);
    return h;
  }

  /**
   * Prints the immutable value {@code ProcessRelationships} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ProcessRelationships{"
        + "app=" + app
        + ", revision=" + revision
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_ProcessRelationships", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v3.processes._ProcessRelationships {
    ToOneRelationship app;
    ToOneRelationship revision;
    @JsonProperty("app")
    public void setApp(@Nullable ToOneRelationship app) {
      this.app = app;
    }
    @JsonProperty("revision")
    public void setRevision(@Nullable ToOneRelationship revision) {
      this.revision = revision;
    }
    @Override
    public ToOneRelationship getApp() { throw new UnsupportedOperationException(); }
    @Override
    public ToOneRelationship getRevision() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ProcessRelationships fromJson(Json json) {
    ProcessRelationships.Builder builder = ProcessRelationships.builder();
    if (json.app != null) {
      builder.app(json.app);
    }
    if (json.revision != null) {
      builder.revision(json.revision);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link ProcessRelationships ProcessRelationships}.
   * <pre>
   * ProcessRelationships.builder()
   *    .app(org.cloudfoundry.client.v3.ToOneRelationship | null) // nullable {@link ProcessRelationships#getApp() app}
   *    .revision(org.cloudfoundry.client.v3.ToOneRelationship | null) // nullable {@link ProcessRelationships#getRevision() revision}
   *    .build();
   * </pre>
   * @return A new ProcessRelationships builder
   */
  public static ProcessRelationships.Builder builder() {
    return new ProcessRelationships.Builder();
  }

  /**
   * Builds instances of type {@link ProcessRelationships ProcessRelationships}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_ProcessRelationships", generator = "Immutables")
  public static final class Builder {
    private ToOneRelationship app;
    private ToOneRelationship revision;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ProcessRelationships} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ProcessRelationships instance) {
      return from((_ProcessRelationships) instance);
    }

    /**
     * Copy abstract value type {@code _ProcessRelationships} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_ProcessRelationships instance) {
      Objects.requireNonNull(instance, "instance");
      ToOneRelationship appValue = instance.getApp();
      if (appValue != null) {
        app(appValue);
      }
      ToOneRelationship revisionValue = instance.getRevision();
      if (revisionValue != null) {
        revision(revisionValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link ProcessRelationships#getApp() app} attribute.
     * @param app The value for app (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("app")
    public final Builder app(@Nullable ToOneRelationship app) {
      this.app = app;
      return this;
    }

    /**
     * Initializes the value for the {@link ProcessRelationships#getRevision() revision} attribute.
     * @param revision The value for revision (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("revision")
    public final Builder revision(@Nullable ToOneRelationship revision) {
      this.revision = revision;
      return this;
    }

    /**
     * Builds a new {@link ProcessRelationships ProcessRelationships}.
     * @return An immutable instance of ProcessRelationships
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ProcessRelationships build() {
      return new ProcessRelationships(this);
    }
  }
}
