package org.cloudfoundry.client.v3.processes;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.immutables.value.Generated;

/**
 * Process usage information
 */
@Generated(from = "_ProcessUsage", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ProcessUsage extends org.cloudfoundry.client.v3.processes._ProcessUsage {
  private final @Nullable Double cpu;
  private final @Nullable Long disk;
  private final @Nullable Long memory;
  private final @Nullable String time;
  private final @Nullable Double cpuEntitlement;
  private final @Nullable Integer logRateLimit;

  private ProcessUsage(ProcessUsage.Builder builder) {
    this.cpu = builder.cpu;
    this.disk = builder.disk;
    this.memory = builder.memory;
    this.time = builder.time;
    this.cpuEntitlement = builder.cpuEntitlement;
    this.logRateLimit = builder.logRateLimit;
  }

  /**
   * The CPU
   */
  @JsonProperty("cpu")
  @Override
  public @Nullable Double getCpu() {
    return cpu;
  }

  /**
   * The disk
   */
  @JsonProperty("disk")
  @Override
  public @Nullable Long getDisk() {
    return disk;
  }

  /**
   * The memory
   */
  @JsonProperty("mem")
  @Override
  public @Nullable Long getMemory() {
    return memory;
  }

  /**
   * The time
   */
  @JsonProperty("time")
  @Override
  public @Nullable String getTime() {
    return time;
  }

  /**
   * The CPU entitlement
   */
  @JsonProperty("cpu_entitlement")
  @Override
  public @Nullable Double getCpuEntitlement() {
    return cpuEntitlement;
  }

  /**
   * The current logging usage of the instance
   */
  @JsonProperty("log_rate")
  @Override
  public @Nullable Integer getLogRateLimit() {
    return logRateLimit;
  }

  /**
   * This instance is equal to all instances of {@code ProcessUsage} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ProcessUsage
        && equalTo(0, (ProcessUsage) another);
  }

  private boolean equalTo(int synthetic, ProcessUsage another) {
    return Objects.equals(cpu, another.cpu)
        && Objects.equals(disk, another.disk)
        && Objects.equals(memory, another.memory)
        && Objects.equals(time, another.time)
        && Objects.equals(cpuEntitlement, another.cpuEntitlement)
        && Objects.equals(logRateLimit, another.logRateLimit);
  }

  /**
   * Computes a hash code from attributes: {@code cpu}, {@code disk}, {@code memory}, {@code time}, {@code cpuEntitlement}, {@code logRateLimit}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(cpu);
    h += (h << 5) + Objects.hashCode(disk);
    h += (h << 5) + Objects.hashCode(memory);
    h += (h << 5) + Objects.hashCode(time);
    h += (h << 5) + Objects.hashCode(cpuEntitlement);
    h += (h << 5) + Objects.hashCode(logRateLimit);
    return h;
  }

  /**
   * Prints the immutable value {@code ProcessUsage} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ProcessUsage{"
        + "cpu=" + cpu
        + ", disk=" + disk
        + ", memory=" + memory
        + ", time=" + time
        + ", cpuEntitlement=" + cpuEntitlement
        + ", logRateLimit=" + logRateLimit
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_ProcessUsage", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v3.processes._ProcessUsage {
    Double cpu;
    Long disk;
    Long memory;
    String time;
    Double cpuEntitlement;
    Integer logRateLimit;
    @JsonProperty("cpu")
    public void setCpu(@Nullable Double cpu) {
      this.cpu = cpu;
    }
    @JsonProperty("disk")
    public void setDisk(@Nullable Long disk) {
      this.disk = disk;
    }
    @JsonProperty("mem")
    public void setMemory(@Nullable Long memory) {
      this.memory = memory;
    }
    @JsonProperty("time")
    public void setTime(@Nullable String time) {
      this.time = time;
    }
    @JsonProperty("cpu_entitlement")
    public void setCpuEntitlement(@Nullable Double cpuEntitlement) {
      this.cpuEntitlement = cpuEntitlement;
    }
    @JsonProperty("log_rate")
    public void setLogRateLimit(@Nullable Integer logRateLimit) {
      this.logRateLimit = logRateLimit;
    }
    @Override
    public Double getCpu() { throw new UnsupportedOperationException(); }
    @Override
    public Long getDisk() { throw new UnsupportedOperationException(); }
    @Override
    public Long getMemory() { throw new UnsupportedOperationException(); }
    @Override
    public String getTime() { throw new UnsupportedOperationException(); }
    @Override
    public Double getCpuEntitlement() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getLogRateLimit() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ProcessUsage fromJson(Json json) {
    ProcessUsage.Builder builder = ProcessUsage.builder();
    if (json.cpu != null) {
      builder.cpu(json.cpu);
    }
    if (json.disk != null) {
      builder.disk(json.disk);
    }
    if (json.memory != null) {
      builder.memory(json.memory);
    }
    if (json.time != null) {
      builder.time(json.time);
    }
    if (json.cpuEntitlement != null) {
      builder.cpuEntitlement(json.cpuEntitlement);
    }
    if (json.logRateLimit != null) {
      builder.logRateLimit(json.logRateLimit);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link ProcessUsage ProcessUsage}.
   * <pre>
   * ProcessUsage.builder()
   *    .cpu(Double | null) // nullable {@link ProcessUsage#getCpu() cpu}
   *    .disk(Long | null) // nullable {@link ProcessUsage#getDisk() disk}
   *    .memory(Long | null) // nullable {@link ProcessUsage#getMemory() memory}
   *    .time(String | null) // nullable {@link ProcessUsage#getTime() time}
   *    .cpuEntitlement(Double | null) // nullable {@link ProcessUsage#getCpuEntitlement() cpuEntitlement}
   *    .logRateLimit(Integer | null) // nullable {@link ProcessUsage#getLogRateLimit() logRateLimit}
   *    .build();
   * </pre>
   * @return A new ProcessUsage builder
   */
  public static ProcessUsage.Builder builder() {
    return new ProcessUsage.Builder();
  }

  /**
   * Builds instances of type {@link ProcessUsage ProcessUsage}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_ProcessUsage", generator = "Immutables")
  public static final class Builder {
    private Double cpu;
    private Long disk;
    private Long memory;
    private String time;
    private Double cpuEntitlement;
    private Integer logRateLimit;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ProcessUsage} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ProcessUsage instance) {
      return from((_ProcessUsage) instance);
    }

    /**
     * Copy abstract value type {@code _ProcessUsage} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_ProcessUsage instance) {
      Objects.requireNonNull(instance, "instance");
      Double cpuValue = instance.getCpu();
      if (cpuValue != null) {
        cpu(cpuValue);
      }
      Long diskValue = instance.getDisk();
      if (diskValue != null) {
        disk(diskValue);
      }
      Long memoryValue = instance.getMemory();
      if (memoryValue != null) {
        memory(memoryValue);
      }
      String timeValue = instance.getTime();
      if (timeValue != null) {
        time(timeValue);
      }
      Double cpuEntitlementValue = instance.getCpuEntitlement();
      if (cpuEntitlementValue != null) {
        cpuEntitlement(cpuEntitlementValue);
      }
      Integer logRateLimitValue = instance.getLogRateLimit();
      if (logRateLimitValue != null) {
        logRateLimit(logRateLimitValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link ProcessUsage#getCpu() cpu} attribute.
     * @param cpu The value for cpu (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("cpu")
    public final Builder cpu(@Nullable Double cpu) {
      this.cpu = cpu;
      return this;
    }

    /**
     * Initializes the value for the {@link ProcessUsage#getDisk() disk} attribute.
     * @param disk The value for disk (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("disk")
    public final Builder disk(@Nullable Long disk) {
      this.disk = disk;
      return this;
    }

    /**
     * Initializes the value for the {@link ProcessUsage#getMemory() memory} attribute.
     * @param memory The value for memory (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("mem")
    public final Builder memory(@Nullable Long memory) {
      this.memory = memory;
      return this;
    }

    /**
     * Initializes the value for the {@link ProcessUsage#getTime() time} attribute.
     * @param time The value for time (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("time")
    public final Builder time(@Nullable String time) {
      this.time = time;
      return this;
    }

    /**
     * Initializes the value for the {@link ProcessUsage#getCpuEntitlement() cpuEntitlement} attribute.
     * @param cpuEntitlement The value for cpuEntitlement (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("cpu_entitlement")
    public final Builder cpuEntitlement(@Nullable Double cpuEntitlement) {
      this.cpuEntitlement = cpuEntitlement;
      return this;
    }

    /**
     * Initializes the value for the {@link ProcessUsage#getLogRateLimit() logRateLimit} attribute.
     * @param logRateLimit The value for logRateLimit (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("log_rate")
    public final Builder logRateLimit(@Nullable Integer logRateLimit) {
      this.logRateLimit = logRateLimit;
      return this;
    }

    /**
     * Builds a new {@link ProcessUsage ProcessUsage}.
     * @return An immutable instance of ProcessUsage
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ProcessUsage build() {
      return new ProcessUsage(this);
    }
  }
}
