package org.cloudfoundry.client.v3.processes;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.immutables.value.Generated;

/**
 * The health check
 */
@Generated(from = "_ReadinessHealthCheck", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ReadinessHealthCheck extends org.cloudfoundry.client.v3.processes._ReadinessHealthCheck {
  private final @Nullable Data data;
  private final ReadinessHealthCheckType type;

  private ReadinessHealthCheck(ReadinessHealthCheck.Builder builder) {
    this.data = builder.data;
    this.type = builder.type;
  }

  /**
   * The data
   */
  @JsonProperty("data")
  @Override
  public @Nullable Data getData() {
    return data;
  }

  /**
   * The type
   */
  @JsonProperty("type")
  @Override
  public ReadinessHealthCheckType getType() {
    return type;
  }

  /**
   * This instance is equal to all instances of {@code ReadinessHealthCheck} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ReadinessHealthCheck
        && equalTo(0, (ReadinessHealthCheck) another);
  }

  private boolean equalTo(int synthetic, ReadinessHealthCheck another) {
    return Objects.equals(data, another.data)
        && type.equals(another.type);
  }

  /**
   * Computes a hash code from attributes: {@code data}, {@code type}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(data);
    h += (h << 5) + type.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ReadinessHealthCheck} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ReadinessHealthCheck{"
        + "data=" + data
        + ", type=" + type
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_ReadinessHealthCheck", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v3.processes._ReadinessHealthCheck {
    Data data;
    ReadinessHealthCheckType type;
    @JsonProperty("data")
    public void setData(@Nullable Data data) {
      this.data = data;
    }
    @JsonProperty("type")
    public void setType(ReadinessHealthCheckType type) {
      this.type = type;
    }
    @Override
    public Data getData() { throw new UnsupportedOperationException(); }
    @Override
    public ReadinessHealthCheckType getType() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ReadinessHealthCheck fromJson(Json json) {
    ReadinessHealthCheck.Builder builder = ReadinessHealthCheck.builder();
    if (json.data != null) {
      builder.data(json.data);
    }
    if (json.type != null) {
      builder.type(json.type);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link ReadinessHealthCheck ReadinessHealthCheck}.
   * <pre>
   * ReadinessHealthCheck.builder()
   *    .data(org.cloudfoundry.client.v3.processes.Data | null) // nullable {@link ReadinessHealthCheck#getData() data}
   *    .type(org.cloudfoundry.client.v3.processes.ReadinessHealthCheckType) // required {@link ReadinessHealthCheck#getType() type}
   *    .build();
   * </pre>
   * @return A new ReadinessHealthCheck builder
   */
  public static ReadinessHealthCheck.Builder builder() {
    return new ReadinessHealthCheck.Builder();
  }

  /**
   * Builds instances of type {@link ReadinessHealthCheck ReadinessHealthCheck}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_ReadinessHealthCheck", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_TYPE = 0x1L;
    private long initBits = 0x1L;

    private Data data;
    private ReadinessHealthCheckType type;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ReadinessHealthCheck} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ReadinessHealthCheck instance) {
      return from((_ReadinessHealthCheck) instance);
    }

    /**
     * Copy abstract value type {@code _ReadinessHealthCheck} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_ReadinessHealthCheck instance) {
      Objects.requireNonNull(instance, "instance");
      Data dataValue = instance.getData();
      if (dataValue != null) {
        data(dataValue);
      }
      this.type(instance.getType());
      return this;
    }

    /**
     * Initializes the value for the {@link ReadinessHealthCheck#getData() data} attribute.
     * @param data The value for data (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("data")
    public final Builder data(@Nullable Data data) {
      this.data = data;
      return this;
    }

    /**
     * Initializes the value for the {@link ReadinessHealthCheck#getType() type} attribute.
     * @param type The value for type 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("type")
    public final Builder type(ReadinessHealthCheckType type) {
      this.type = Objects.requireNonNull(type, "type");
      initBits &= ~INIT_BIT_TYPE;
      return this;
    }

    /**
     * Builds a new {@link ReadinessHealthCheck ReadinessHealthCheck}.
     * @return An immutable instance of ReadinessHealthCheck
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ReadinessHealthCheck build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ReadinessHealthCheck(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_TYPE) != 0) attributes.add("type");
      return "Cannot build ReadinessHealthCheck, some of required attributes are not set " + attributes;
    }
  }
}
