package org.cloudfoundry.client.v3.roles;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * The request payload for the Create Role operation
 */
@Generated(from = "_CreateRoleRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class CreateRoleRequest extends org.cloudfoundry.client.v3.roles._CreateRoleRequest {
  private final RoleRelationships relationships;
  private final RoleType type;

  private CreateRoleRequest(CreateRoleRequest.Builder builder) {
    this.relationships = builder.relationships;
    this.type = builder.type;
  }

  /**
   * The relationships
   */
  @JsonProperty("relationships")
  @Override
  public RoleRelationships getRelationships() {
    return relationships;
  }

  /**
   * The type
   */
  @JsonProperty("type")
  @Override
  public RoleType getType() {
    return type;
  }

  /**
   * This instance is equal to all instances of {@code CreateRoleRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof CreateRoleRequest
        && equalTo(0, (CreateRoleRequest) another);
  }

  private boolean equalTo(int synthetic, CreateRoleRequest another) {
    return relationships.equals(another.relationships)
        && type.equals(another.type);
  }

  /**
   * Computes a hash code from attributes: {@code relationships}, {@code type}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + relationships.hashCode();
    h += (h << 5) + type.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code CreateRoleRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "CreateRoleRequest{"
        + "relationships=" + relationships
        + ", type=" + type
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_CreateRoleRequest", generator = "Immutables")
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v3.roles._CreateRoleRequest {
    RoleRelationships relationships;
    RoleType type;
    @JsonProperty("relationships")
    public void setRelationships(RoleRelationships relationships) {
      this.relationships = relationships;
    }
    @JsonProperty("type")
    public void setType(RoleType type) {
      this.type = type;
    }
    @Override
    public RoleRelationships getRelationships() { throw new UnsupportedOperationException(); }
    @Override
    public RoleType getType() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static CreateRoleRequest fromJson(Json json) {
    CreateRoleRequest.Builder builder = CreateRoleRequest.builder();
    if (json.relationships != null) {
      builder.relationships(json.relationships);
    }
    if (json.type != null) {
      builder.type(json.type);
    }
    return builder.build();
  }

  private static CreateRoleRequest validate(CreateRoleRequest instance) {
    instance.validateRelationships();
    return instance;
  }

  /**
   * Creates a builder for {@link CreateRoleRequest CreateRoleRequest}.
   * <pre>
   * CreateRoleRequest.builder()
   *    .relationships(org.cloudfoundry.client.v3.roles.RoleRelationships) // required {@link CreateRoleRequest#getRelationships() relationships}
   *    .type(org.cloudfoundry.client.v3.roles.RoleType) // required {@link CreateRoleRequest#getType() type}
   *    .build();
   * </pre>
   * @return A new CreateRoleRequest builder
   */
  public static CreateRoleRequest.Builder builder() {
    return new CreateRoleRequest.Builder();
  }

  /**
   * Builds instances of type {@link CreateRoleRequest CreateRoleRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_CreateRoleRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_RELATIONSHIPS = 0x1L;
    private static final long INIT_BIT_TYPE = 0x2L;
    private long initBits = 0x3L;

    private RoleRelationships relationships;
    private RoleType type;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code CreateRoleRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(CreateRoleRequest instance) {
      return from((_CreateRoleRequest) instance);
    }

    /**
     * Copy abstract value type {@code _CreateRoleRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_CreateRoleRequest instance) {
      Objects.requireNonNull(instance, "instance");
      this.relationships(instance.getRelationships());
      this.type(instance.getType());
      return this;
    }

    /**
     * Initializes the value for the {@link CreateRoleRequest#getRelationships() relationships} attribute.
     * @param relationships The value for relationships 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder relationships(RoleRelationships relationships) {
      this.relationships = Objects.requireNonNull(relationships, "relationships");
      initBits &= ~INIT_BIT_RELATIONSHIPS;
      return this;
    }

    /**
     * Initializes the value for the {@link CreateRoleRequest#getType() type} attribute.
     * @param type The value for type 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder type(RoleType type) {
      this.type = Objects.requireNonNull(type, "type");
      initBits &= ~INIT_BIT_TYPE;
      return this;
    }

    /**
     * Builds a new {@link CreateRoleRequest CreateRoleRequest}.
     * @return An immutable instance of CreateRoleRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public CreateRoleRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return CreateRoleRequest.validate(new CreateRoleRequest(this));
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_RELATIONSHIPS) != 0) attributes.add("relationships");
      if ((initBits & INIT_BIT_TYPE) != 0) attributes.add("type");
      return "Cannot build CreateRoleRequest, some of required attributes are not set " + attributes;
    }
  }
}
