package org.cloudfoundry.client.v3.roles;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * The request payload for the Delete Role operation
 */
@Generated(from = "_DeleteRoleRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class DeleteRoleRequest extends org.cloudfoundry.client.v3.roles._DeleteRoleRequest {
  private final String roleId;

  private DeleteRoleRequest(DeleteRoleRequest.Builder builder) {
    this.roleId = builder.roleId;
  }

  /**
   * The role id
   */
  @Override
  public String getRoleId() {
    return roleId;
  }

  /**
   * This instance is equal to all instances of {@code DeleteRoleRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof DeleteRoleRequest
        && equalTo(0, (DeleteRoleRequest) another);
  }

  private boolean equalTo(int synthetic, DeleteRoleRequest another) {
    return roleId.equals(another.roleId);
  }

  /**
   * Computes a hash code from attributes: {@code roleId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + roleId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code DeleteRoleRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "DeleteRoleRequest{"
        + "roleId=" + roleId
        + "}";
  }

  /**
   * Creates a builder for {@link DeleteRoleRequest DeleteRoleRequest}.
   * <pre>
   * DeleteRoleRequest.builder()
   *    .roleId(String) // required {@link DeleteRoleRequest#getRoleId() roleId}
   *    .build();
   * </pre>
   * @return A new DeleteRoleRequest builder
   */
  public static DeleteRoleRequest.Builder builder() {
    return new DeleteRoleRequest.Builder();
  }

  /**
   * Builds instances of type {@link DeleteRoleRequest DeleteRoleRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_DeleteRoleRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_ROLE_ID = 0x1L;
    private long initBits = 0x1L;

    private String roleId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code DeleteRoleRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(DeleteRoleRequest instance) {
      return from((_DeleteRoleRequest) instance);
    }

    /**
     * Copy abstract value type {@code _DeleteRoleRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_DeleteRoleRequest instance) {
      Objects.requireNonNull(instance, "instance");
      this.roleId(instance.getRoleId());
      return this;
    }

    /**
     * Initializes the value for the {@link DeleteRoleRequest#getRoleId() roleId} attribute.
     * @param roleId The value for roleId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder roleId(String roleId) {
      this.roleId = Objects.requireNonNull(roleId, "roleId");
      initBits &= ~INIT_BIT_ROLE_ID;
      return this;
    }

    /**
     * Builds a new {@link DeleteRoleRequest DeleteRoleRequest}.
     * @return An immutable instance of DeleteRoleRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public DeleteRoleRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new DeleteRoleRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ROLE_ID) != 0) attributes.add("roleId");
      return "Cannot build DeleteRoleRequest, some of required attributes are not set " + attributes;
    }
  }
}
