package org.cloudfoundry.client.v3.routes;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.immutables.value.Generated;

/**
 * Represents a Route Destination
 */
@Generated(from = "_Destination", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class Destination extends org.cloudfoundry.client.v3.routes._Destination {
  private final Application application;
  private final @Nullable String destinationId;
  private final @Nullable Integer port;
  private final @Nullable Integer weight;
  private final @Nullable String protocol;

  private Destination(Destination.Builder builder) {
    this.application = builder.application;
    this.destinationId = builder.destinationId;
    this.port = builder.port;
    this.weight = builder.weight;
    this.protocol = builder.protocol;
  }

  /**
   * The application
   */
  @JsonProperty("app")
  @Override
  public Application getApplication() {
    return application;
  }

  /**
   * The destination id
   */
  @JsonProperty("guid")
  @Override
  public @Nullable String getDestinationId() {
    return destinationId;
  }

  /**
   * The port
   */
  @JsonProperty("port")
  @Override
  public @Nullable Integer getPort() {
    return port;
  }

  /**
   * The id
   */
  @JsonProperty("weight")
  @Override
  public @Nullable Integer getWeight() {
    return weight;
  }

  /**
   * The id
   */
  @JsonProperty("protocol")
  @Override
  public @Nullable String getProtocol() {
    return protocol;
  }

  /**
   * This instance is equal to all instances of {@code Destination} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof Destination
        && equalTo(0, (Destination) another);
  }

  private boolean equalTo(int synthetic, Destination another) {
    return application.equals(another.application)
        && Objects.equals(destinationId, another.destinationId)
        && Objects.equals(port, another.port)
        && Objects.equals(weight, another.weight)
        && Objects.equals(protocol, another.protocol);
  }

  /**
   * Computes a hash code from attributes: {@code application}, {@code destinationId}, {@code port}, {@code weight}, {@code protocol}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + application.hashCode();
    h += (h << 5) + Objects.hashCode(destinationId);
    h += (h << 5) + Objects.hashCode(port);
    h += (h << 5) + Objects.hashCode(weight);
    h += (h << 5) + Objects.hashCode(protocol);
    return h;
  }

  /**
   * Prints the immutable value {@code Destination} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Destination{"
        + "application=" + application
        + ", destinationId=" + destinationId
        + ", port=" + port
        + ", weight=" + weight
        + ", protocol=" + protocol
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_Destination", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v3.routes._Destination {
    Application application;
    String destinationId;
    Integer port;
    Integer weight;
    String protocol;
    @JsonProperty("app")
    public void setApplication(Application application) {
      this.application = application;
    }
    @JsonProperty("guid")
    public void setDestinationId(@Nullable String destinationId) {
      this.destinationId = destinationId;
    }
    @JsonProperty("port")
    public void setPort(@Nullable Integer port) {
      this.port = port;
    }
    @JsonProperty("weight")
    public void setWeight(@Nullable Integer weight) {
      this.weight = weight;
    }
    @JsonProperty("protocol")
    public void setProtocol(@Nullable String protocol) {
      this.protocol = protocol;
    }
    @Override
    public Application getApplication() { throw new UnsupportedOperationException(); }
    @Override
    public String getDestinationId() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getPort() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getWeight() { throw new UnsupportedOperationException(); }
    @Override
    public String getProtocol() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static Destination fromJson(Json json) {
    Destination.Builder builder = Destination.builder();
    if (json.application != null) {
      builder.application(json.application);
    }
    if (json.destinationId != null) {
      builder.destinationId(json.destinationId);
    }
    if (json.port != null) {
      builder.port(json.port);
    }
    if (json.weight != null) {
      builder.weight(json.weight);
    }
    if (json.protocol != null) {
      builder.protocol(json.protocol);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link Destination Destination}.
   * <pre>
   * Destination.builder()
   *    .application(org.cloudfoundry.client.v3.routes.Application) // required {@link Destination#getApplication() application}
   *    .destinationId(String | null) // nullable {@link Destination#getDestinationId() destinationId}
   *    .port(Integer | null) // nullable {@link Destination#getPort() port}
   *    .weight(Integer | null) // nullable {@link Destination#getWeight() weight}
   *    .protocol(String | null) // nullable {@link Destination#getProtocol() protocol}
   *    .build();
   * </pre>
   * @return A new Destination builder
   */
  public static Destination.Builder builder() {
    return new Destination.Builder();
  }

  /**
   * Builds instances of type {@link Destination Destination}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_Destination", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_APPLICATION = 0x1L;
    private long initBits = 0x1L;

    private Application application;
    private String destinationId;
    private Integer port;
    private Integer weight;
    private String protocol;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Destination} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Destination instance) {
      return from((_Destination) instance);
    }

    /**
     * Copy abstract value type {@code _Destination} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_Destination instance) {
      Objects.requireNonNull(instance, "instance");
      this.application(instance.getApplication());
      String destinationIdValue = instance.getDestinationId();
      if (destinationIdValue != null) {
        destinationId(destinationIdValue);
      }
      Integer portValue = instance.getPort();
      if (portValue != null) {
        port(portValue);
      }
      Integer weightValue = instance.getWeight();
      if (weightValue != null) {
        weight(weightValue);
      }
      String protocolValue = instance.getProtocol();
      if (protocolValue != null) {
        protocol(protocolValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link Destination#getApplication() application} attribute.
     * @param application The value for application 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("app")
    public final Builder application(Application application) {
      this.application = Objects.requireNonNull(application, "application");
      initBits &= ~INIT_BIT_APPLICATION;
      return this;
    }

    /**
     * Initializes the value for the {@link Destination#getDestinationId() destinationId} attribute.
     * @param destinationId The value for destinationId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("guid")
    public final Builder destinationId(@Nullable String destinationId) {
      this.destinationId = destinationId;
      return this;
    }

    /**
     * Initializes the value for the {@link Destination#getPort() port} attribute.
     * @param port The value for port (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("port")
    public final Builder port(@Nullable Integer port) {
      this.port = port;
      return this;
    }

    /**
     * Initializes the value for the {@link Destination#getWeight() weight} attribute.
     * @param weight The value for weight (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("weight")
    public final Builder weight(@Nullable Integer weight) {
      this.weight = weight;
      return this;
    }

    /**
     * Initializes the value for the {@link Destination#getProtocol() protocol} attribute.
     * @param protocol The value for protocol (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("protocol")
    public final Builder protocol(@Nullable String protocol) {
      this.protocol = protocol;
      return this;
    }

    /**
     * Builds a new {@link Destination Destination}.
     * @return An immutable instance of Destination
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public Destination build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new Destination(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_APPLICATION) != 0) attributes.add("application");
      return "Cannot build Destination, some of required attributes are not set " + attributes;
    }
  }
}
