package org.cloudfoundry.client.v3.routes;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.cloudfoundry.client.v3.Link;
import org.immutables.value.Generated;

/**
 * The response payload for the List Route Destinations operation
 */
@Generated(from = "_ListRouteDestinationsResponse", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ListRouteDestinationsResponse
    extends org.cloudfoundry.client.v3.routes._ListRouteDestinationsResponse {
  private final Map<String, Link> links;
  private final List<Destination> destinations;

  private ListRouteDestinationsResponse(ListRouteDestinationsResponse.Builder builder) {
    this.links = createUnmodifiableMap(false, false, builder.links);
    this.destinations = createUnmodifiableList(true, builder.destinations);
  }

  /**
   * Links to related resources and actions for the resource
   */
  @JsonProperty("links")
  @Override
  public Map<String, Link> getLinks() {
    return links;
  }

  /**
   * The destinations
   */
  @JsonProperty("destinations")
  @Override
  public List<Destination> getDestinations() {
    return destinations;
  }

  /**
   * This instance is equal to all instances of {@code ListRouteDestinationsResponse} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ListRouteDestinationsResponse
        && equalTo(0, (ListRouteDestinationsResponse) another);
  }

  private boolean equalTo(int synthetic, ListRouteDestinationsResponse another) {
    return links.equals(another.links)
        && destinations.equals(another.destinations);
  }

  /**
   * Computes a hash code from attributes: {@code links}, {@code destinations}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + links.hashCode();
    h += (h << 5) + destinations.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ListRouteDestinationsResponse} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ListRouteDestinationsResponse{"
        + "links=" + links
        + ", destinations=" + destinations
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_ListRouteDestinationsResponse", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v3.routes._ListRouteDestinationsResponse {
    Map<String, Link> links = Collections.emptyMap();
    List<Destination> destinations = Collections.emptyList();
    @JsonProperty("links")
    public void setLinks(Map<String, Link> links) {
      this.links = links;
    }
    @JsonProperty("destinations")
    public void setDestinations(List<Destination> destinations) {
      this.destinations = destinations;
    }
    @Override
    public Map<String, Link> getLinks() { throw new UnsupportedOperationException(); }
    @Override
    public List<Destination> getDestinations() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ListRouteDestinationsResponse fromJson(Json json) {
    ListRouteDestinationsResponse.Builder builder = ListRouteDestinationsResponse.builder();
    if (json.links != null) {
      builder.putAllLinks(json.links);
    }
    if (json.destinations != null) {
      builder.addAllDestinations(json.destinations);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link ListRouteDestinationsResponse ListRouteDestinationsResponse}.
   * <pre>
   * ListRouteDestinationsResponse.builder()
   *    .link|putAllLinks(String =&gt; org.cloudfoundry.client.v3.Link) // {@link ListRouteDestinationsResponse#getLinks() links} mappings
   *    .destination|addAllDestinations(Destination) // {@link ListRouteDestinationsResponse#getDestinations() destinations} elements
   *    .build();
   * </pre>
   * @return A new ListRouteDestinationsResponse builder
   */
  public static ListRouteDestinationsResponse.Builder builder() {
    return new ListRouteDestinationsResponse.Builder();
  }

  /**
   * Builds instances of type {@link ListRouteDestinationsResponse ListRouteDestinationsResponse}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_ListRouteDestinationsResponse", generator = "Immutables")
  public static final class Builder {
    private Map<String, Link> links = new LinkedHashMap<String, Link>();
    private List<Destination> destinations = new ArrayList<Destination>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.client.v3.routes.RouteDestinations} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(RouteDestinations instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code ListRouteDestinationsResponse} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ListRouteDestinationsResponse instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _ListRouteDestinationsResponse} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(_ListRouteDestinationsResponse instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    private void from(short _unused, Object object) {
      if (object instanceof RouteDestinations) {
        RouteDestinations instance = (RouteDestinations) object;
        putAllLinks(instance.getLinks());
        addAllDestinations(instance.getDestinations());
      }
    }

    /**
     * Put one entry to the {@link ListRouteDestinationsResponse#getLinks() links} map.
     * @param key The key in the links map
     * @param value The associated value in the links map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder link(String key, Link value) {
      this.links.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link ListRouteDestinationsResponse#getLinks() links} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder link(Map.Entry<String, ? extends Link> entry) {
      String k = entry.getKey();
      Link v = entry.getValue();
      this.links.put(k, v);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link ListRouteDestinationsResponse#getLinks() links} map. Nulls are not permitted
     * @param entries The entries that will be added to the links map
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("links")
    public final Builder links(Map<String, ? extends Link> entries) {
      this.links.clear();
      return putAllLinks(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link ListRouteDestinationsResponse#getLinks() links} map. Nulls are not permitted
     * @param entries The entries that will be added to the links map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllLinks(Map<String, ? extends Link> entries) {
      for (Map.Entry<String, ? extends Link> e : entries.entrySet()) {
        String k = e.getKey();
        Link v = e.getValue();
        this.links.put(k, v);
      }
      return this;
    }

    /**
     * Adds one element to {@link ListRouteDestinationsResponse#getDestinations() destinations} list.
     * @param element A destinations element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder destination(Destination element) {
      this.destinations.add(Objects.requireNonNull(element, "destinations element"));
      return this;
    }

    /**
     * Adds elements to {@link ListRouteDestinationsResponse#getDestinations() destinations} list.
     * @param elements An array of destinations elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder destinations(Destination... elements) {
      for (Destination element : elements) {
        this.destinations.add(Objects.requireNonNull(element, "destinations element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListRouteDestinationsResponse#getDestinations() destinations} list.
     * @param elements An iterable of destinations elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("destinations")
    public final Builder destinations(Iterable<? extends Destination> elements) {
      this.destinations.clear();
      return addAllDestinations(elements);
    }

    /**
     * Adds elements to {@link ListRouteDestinationsResponse#getDestinations() destinations} list.
     * @param elements An iterable of destinations elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllDestinations(Iterable<? extends Destination> elements) {
      for (Destination element : elements) {
        this.destinations.add(Objects.requireNonNull(element, "destinations element"));
      }
      return this;
    }

    /**
     * Builds a new {@link ListRouteDestinationsResponse ListRouteDestinationsResponse}.
     * @return An immutable instance of ListRouteDestinationsResponse
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ListRouteDestinationsResponse build() {
      return new ListRouteDestinationsResponse(this);
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>(size);
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<>(map.size() * 4 / 3 + 1);
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
