package org.cloudfoundry.client.v3.routes;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Represents a route Process type.
 */
@Generated(from = "_Process", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class Process extends org.cloudfoundry.client.v3.routes._Process {
  private final String type;

  private Process(Process.Builder builder) {
    this.type = builder.type;
  }

  /**
   * The type
   */
  @JsonProperty("type")
  @Override
  public String getType() {
    return type;
  }

  /**
   * This instance is equal to all instances of {@code Process} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof Process
        && equalTo(0, (Process) another);
  }

  private boolean equalTo(int synthetic, Process another) {
    return type.equals(another.type);
  }

  /**
   * Computes a hash code from attributes: {@code type}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + type.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Process} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Process{"
        + "type=" + type
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_Process", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v3.routes._Process {
    String type;
    @JsonProperty("type")
    public void setType(String type) {
      this.type = type;
    }
    @Override
    public String getType() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static Process fromJson(Json json) {
    Process.Builder builder = Process.builder();
    if (json.type != null) {
      builder.type(json.type);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link Process Process}.
   * <pre>
   * Process.builder()
   *    .type(String) // required {@link Process#getType() type}
   *    .build();
   * </pre>
   * @return A new Process builder
   */
  public static Process.Builder builder() {
    return new Process.Builder();
  }

  /**
   * Builds instances of type {@link Process Process}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_Process", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_TYPE = 0x1L;
    private long initBits = 0x1L;

    private String type;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Process} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Process instance) {
      return from((_Process) instance);
    }

    /**
     * Copy abstract value type {@code _Process} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_Process instance) {
      Objects.requireNonNull(instance, "instance");
      this.type(instance.getType());
      return this;
    }

    /**
     * Initializes the value for the {@link Process#getType() type} attribute.
     * @param type The value for type 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("type")
    public final Builder type(String type) {
      this.type = Objects.requireNonNull(type, "type");
      initBits &= ~INIT_BIT_TYPE;
      return this;
    }

    /**
     * Builds a new {@link Process Process}.
     * @return An immutable instance of Process
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public Process build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new Process(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_TYPE) != 0) attributes.add("type");
      return "Cannot build Process, some of required attributes are not set " + attributes;
    }
  }
}
