package org.cloudfoundry.client.v3.routes;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * The request payload for the Remove Route Destination operation
 */
@Generated(from = "_RemoveRouteDestinationsRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class RemoveRouteDestinationsRequest
    extends org.cloudfoundry.client.v3.routes._RemoveRouteDestinationsRequest {
  private final String destinationId;
  private final String routeId;

  private RemoveRouteDestinationsRequest(RemoveRouteDestinationsRequest.Builder builder) {
    this.destinationId = builder.destinationId;
    this.routeId = builder.routeId;
  }

  /**
   * The destination id
   */
  @Override
  public String getDestinationId() {
    return destinationId;
  }

  /**
   * The route id
   */
  @Override
  public String getRouteId() {
    return routeId;
  }

  /**
   * This instance is equal to all instances of {@code RemoveRouteDestinationsRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof RemoveRouteDestinationsRequest
        && equalTo(0, (RemoveRouteDestinationsRequest) another);
  }

  private boolean equalTo(int synthetic, RemoveRouteDestinationsRequest another) {
    return destinationId.equals(another.destinationId)
        && routeId.equals(another.routeId);
  }

  /**
   * Computes a hash code from attributes: {@code destinationId}, {@code routeId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + destinationId.hashCode();
    h += (h << 5) + routeId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code RemoveRouteDestinationsRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "RemoveRouteDestinationsRequest{"
        + "destinationId=" + destinationId
        + ", routeId=" + routeId
        + "}";
  }

  /**
   * Creates a builder for {@link RemoveRouteDestinationsRequest RemoveRouteDestinationsRequest}.
   * <pre>
   * RemoveRouteDestinationsRequest.builder()
   *    .destinationId(String) // required {@link RemoveRouteDestinationsRequest#getDestinationId() destinationId}
   *    .routeId(String) // required {@link RemoveRouteDestinationsRequest#getRouteId() routeId}
   *    .build();
   * </pre>
   * @return A new RemoveRouteDestinationsRequest builder
   */
  public static RemoveRouteDestinationsRequest.Builder builder() {
    return new RemoveRouteDestinationsRequest.Builder();
  }

  /**
   * Builds instances of type {@link RemoveRouteDestinationsRequest RemoveRouteDestinationsRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_RemoveRouteDestinationsRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_DESTINATION_ID = 0x1L;
    private static final long INIT_BIT_ROUTE_ID = 0x2L;
    private long initBits = 0x3L;

    private String destinationId;
    private String routeId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code RemoveRouteDestinationsRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(RemoveRouteDestinationsRequest instance) {
      return from((_RemoveRouteDestinationsRequest) instance);
    }

    /**
     * Copy abstract value type {@code _RemoveRouteDestinationsRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_RemoveRouteDestinationsRequest instance) {
      Objects.requireNonNull(instance, "instance");
      this.destinationId(instance.getDestinationId());
      this.routeId(instance.getRouteId());
      return this;
    }

    /**
     * Initializes the value for the {@link RemoveRouteDestinationsRequest#getDestinationId() destinationId} attribute.
     * @param destinationId The value for destinationId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder destinationId(String destinationId) {
      this.destinationId = Objects.requireNonNull(destinationId, "destinationId");
      initBits &= ~INIT_BIT_DESTINATION_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link RemoveRouteDestinationsRequest#getRouteId() routeId} attribute.
     * @param routeId The value for routeId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder routeId(String routeId) {
      this.routeId = Objects.requireNonNull(routeId, "routeId");
      initBits &= ~INIT_BIT_ROUTE_ID;
      return this;
    }

    /**
     * Builds a new {@link RemoveRouteDestinationsRequest RemoveRouteDestinationsRequest}.
     * @return An immutable instance of RemoveRouteDestinationsRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public RemoveRouteDestinationsRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new RemoveRouteDestinationsRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_DESTINATION_ID) != 0) attributes.add("destinationId");
      if ((initBits & INIT_BIT_ROUTE_ID) != 0) attributes.add("routeId");
      return "Cannot build RemoveRouteDestinationsRequest, some of required attributes are not set " + attributes;
    }
  }
}
