package org.cloudfoundry.client.v3.routes;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.immutables.value.Generated;

/**
 * Represents a Route Options
 */
@Generated(from = "_RouteOptions", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class RouteOptions extends org.cloudfoundry.client.v3.routes._RouteOptions {
  private final @Nullable String loadbalancing;

  private RouteOptions(RouteOptions.Builder builder) {
    this.loadbalancing = builder.loadbalancing;
  }

  /**
   * The loadbalancing
   */
  @JsonProperty("loadbalancing")
  @Override
  public @Nullable String getLoadbalancing() {
    return loadbalancing;
  }

  /**
   * This instance is equal to all instances of {@code RouteOptions} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof RouteOptions
        && equalTo(0, (RouteOptions) another);
  }

  private boolean equalTo(int synthetic, RouteOptions another) {
    return Objects.equals(loadbalancing, another.loadbalancing);
  }

  /**
   * Computes a hash code from attributes: {@code loadbalancing}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(loadbalancing);
    return h;
  }

  /**
   * Prints the immutable value {@code RouteOptions} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "RouteOptions{"
        + "loadbalancing=" + loadbalancing
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_RouteOptions", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v3.routes._RouteOptions {
    String loadbalancing;
    @JsonProperty("loadbalancing")
    public void setLoadbalancing(@Nullable String loadbalancing) {
      this.loadbalancing = loadbalancing;
    }
    @Override
    public String getLoadbalancing() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static RouteOptions fromJson(Json json) {
    RouteOptions.Builder builder = RouteOptions.builder();
    if (json.loadbalancing != null) {
      builder.loadbalancing(json.loadbalancing);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link RouteOptions RouteOptions}.
   * <pre>
   * RouteOptions.builder()
   *    .loadbalancing(String | null) // nullable {@link RouteOptions#getLoadbalancing() loadbalancing}
   *    .build();
   * </pre>
   * @return A new RouteOptions builder
   */
  public static RouteOptions.Builder builder() {
    return new RouteOptions.Builder();
  }

  /**
   * Builds instances of type {@link RouteOptions RouteOptions}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_RouteOptions", generator = "Immutables")
  public static final class Builder {
    private String loadbalancing;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code RouteOptions} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(RouteOptions instance) {
      return from((_RouteOptions) instance);
    }

    /**
     * Copy abstract value type {@code _RouteOptions} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_RouteOptions instance) {
      Objects.requireNonNull(instance, "instance");
      String loadbalancingValue = instance.getLoadbalancing();
      if (loadbalancingValue != null) {
        loadbalancing(loadbalancingValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link RouteOptions#getLoadbalancing() loadbalancing} attribute.
     * @param loadbalancing The value for loadbalancing (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("loadbalancing")
    public final Builder loadbalancing(@Nullable String loadbalancing) {
      this.loadbalancing = loadbalancing;
      return this;
    }

    /**
     * Builds a new {@link RouteOptions RouteOptions}.
     * @return An immutable instance of RouteOptions
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public RouteOptions build() {
      return new RouteOptions(this);
    }
  }
}
