package org.cloudfoundry.client.v3.routes;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.client.v3.ToOneRelationship;
import org.immutables.value.Generated;

/**
 * The Route relationships
 */
@Generated(from = "_RouteRelationships", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class RouteRelationships extends org.cloudfoundry.client.v3.routes._RouteRelationships {
  private final ToOneRelationship domain;
  private final ToOneRelationship space;

  private RouteRelationships(RouteRelationships.Builder builder) {
    this.domain = builder.domain;
    this.space = builder.space;
  }

  /**
   * The domain relationship
   */
  @JsonProperty("domain")
  @Override
  public ToOneRelationship getDomain() {
    return domain;
  }

  /**
   * The space relationship
   */
  @JsonProperty("space")
  @Override
  public ToOneRelationship getSpace() {
    return space;
  }

  /**
   * This instance is equal to all instances of {@code RouteRelationships} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof RouteRelationships
        && equalTo(0, (RouteRelationships) another);
  }

  private boolean equalTo(int synthetic, RouteRelationships another) {
    return domain.equals(another.domain)
        && space.equals(another.space);
  }

  /**
   * Computes a hash code from attributes: {@code domain}, {@code space}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + domain.hashCode();
    h += (h << 5) + space.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code RouteRelationships} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "RouteRelationships{"
        + "domain=" + domain
        + ", space=" + space
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_RouteRelationships", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v3.routes._RouteRelationships {
    ToOneRelationship domain;
    ToOneRelationship space;
    @JsonProperty("domain")
    public void setDomain(ToOneRelationship domain) {
      this.domain = domain;
    }
    @JsonProperty("space")
    public void setSpace(ToOneRelationship space) {
      this.space = space;
    }
    @Override
    public ToOneRelationship getDomain() { throw new UnsupportedOperationException(); }
    @Override
    public ToOneRelationship getSpace() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static RouteRelationships fromJson(Json json) {
    RouteRelationships.Builder builder = RouteRelationships.builder();
    if (json.domain != null) {
      builder.domain(json.domain);
    }
    if (json.space != null) {
      builder.space(json.space);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link RouteRelationships RouteRelationships}.
   * <pre>
   * RouteRelationships.builder()
   *    .domain(org.cloudfoundry.client.v3.ToOneRelationship) // required {@link RouteRelationships#getDomain() domain}
   *    .space(org.cloudfoundry.client.v3.ToOneRelationship) // required {@link RouteRelationships#getSpace() space}
   *    .build();
   * </pre>
   * @return A new RouteRelationships builder
   */
  public static RouteRelationships.Builder builder() {
    return new RouteRelationships.Builder();
  }

  /**
   * Builds instances of type {@link RouteRelationships RouteRelationships}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_RouteRelationships", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_DOMAIN = 0x1L;
    private static final long INIT_BIT_SPACE = 0x2L;
    private long initBits = 0x3L;

    private ToOneRelationship domain;
    private ToOneRelationship space;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code RouteRelationships} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(RouteRelationships instance) {
      return from((_RouteRelationships) instance);
    }

    /**
     * Copy abstract value type {@code _RouteRelationships} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_RouteRelationships instance) {
      Objects.requireNonNull(instance, "instance");
      this.domain(instance.getDomain());
      this.space(instance.getSpace());
      return this;
    }

    /**
     * Initializes the value for the {@link RouteRelationships#getDomain() domain} attribute.
     * @param domain The value for domain 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("domain")
    public final Builder domain(ToOneRelationship domain) {
      this.domain = Objects.requireNonNull(domain, "domain");
      initBits &= ~INIT_BIT_DOMAIN;
      return this;
    }

    /**
     * Initializes the value for the {@link RouteRelationships#getSpace() space} attribute.
     * @param space The value for space 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("space")
    public final Builder space(ToOneRelationship space) {
      this.space = Objects.requireNonNull(space, "space");
      initBits &= ~INIT_BIT_SPACE;
      return this;
    }

    /**
     * Builds a new {@link RouteRelationships RouteRelationships}.
     * @return An immutable instance of RouteRelationships
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public RouteRelationships build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new RouteRelationships(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_DOMAIN) != 0) attributes.add("domain");
      if ((initBits & INIT_BIT_SPACE) != 0) attributes.add("space");
      return "Cannot build RouteRelationships, some of required attributes are not set " + attributes;
    }
  }
}
