package org.cloudfoundry.client.v3.securitygroups;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.client.v3.Relationship;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link _BindRunningSecurityGroupRequest}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code BindRunningSecurityGroupRequest.builder()}.
 */
@Generated(from = "_BindRunningSecurityGroupRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class BindRunningSecurityGroupRequest
    extends org.cloudfoundry.client.v3.securitygroups._BindRunningSecurityGroupRequest {
  private final String securityGroupId;
  private final List<Relationship> boundSpaces;

  private BindRunningSecurityGroupRequest(BindRunningSecurityGroupRequest.Builder builder) {
    this.securityGroupId = builder.securityGroupId;
    this.boundSpaces = createUnmodifiableList(true, builder.boundSpaces);
  }

  /**
   * The Security Group id
   */
  @JsonProperty("securityGroupId")
  @JsonIgnore
  @Override
  public String getSecurityGroupId() {
    return securityGroupId;
  }

  /**
   * A relationship to the spaces where the security_group is applied to
   * applications during runtime
   */
  @JsonProperty("data")
  @Override
  public List<Relationship> getBoundSpaces() {
    return boundSpaces;
  }

  /**
   * This instance is equal to all instances of {@code BindRunningSecurityGroupRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof BindRunningSecurityGroupRequest
        && equalTo(0, (BindRunningSecurityGroupRequest) another);
  }

  private boolean equalTo(int synthetic, BindRunningSecurityGroupRequest another) {
    return securityGroupId.equals(another.securityGroupId)
        && boundSpaces.equals(another.boundSpaces);
  }

  /**
   * Computes a hash code from attributes: {@code securityGroupId}, {@code boundSpaces}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + securityGroupId.hashCode();
    h += (h << 5) + boundSpaces.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code BindRunningSecurityGroupRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "BindRunningSecurityGroupRequest{"
        + "securityGroupId=" + securityGroupId
        + ", boundSpaces=" + boundSpaces
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_BindRunningSecurityGroupRequest", generator = "Immutables")
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v3.securitygroups._BindRunningSecurityGroupRequest {
    String securityGroupId;
    List<Relationship> boundSpaces = Collections.emptyList();
    @JsonProperty("securityGroupId")
    @JsonIgnore
    public void setSecurityGroupId(String securityGroupId) {
      this.securityGroupId = securityGroupId;
    }
    @JsonProperty("data")
    public void setBoundSpaces(List<Relationship> boundSpaces) {
      this.boundSpaces = boundSpaces;
    }
    @Override
    public String getSecurityGroupId() { throw new UnsupportedOperationException(); }
    @Override
    public List<Relationship> getBoundSpaces() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static BindRunningSecurityGroupRequest fromJson(Json json) {
    BindRunningSecurityGroupRequest.Builder builder = BindRunningSecurityGroupRequest.builder();
    if (json.securityGroupId != null) {
      builder.securityGroupId(json.securityGroupId);
    }
    if (json.boundSpaces != null) {
      builder.addAllBoundSpaces(json.boundSpaces);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link BindRunningSecurityGroupRequest BindRunningSecurityGroupRequest}.
   * <pre>
   * BindRunningSecurityGroupRequest.builder()
   *    .securityGroupId(String) // required {@link BindRunningSecurityGroupRequest#getSecurityGroupId() securityGroupId}
   *    .boundSpace|addAllBoundSpaces(org.cloudfoundry.client.v3.Relationship) // {@link BindRunningSecurityGroupRequest#getBoundSpaces() boundSpaces} elements
   *    .build();
   * </pre>
   * @return A new BindRunningSecurityGroupRequest builder
   */
  public static BindRunningSecurityGroupRequest.Builder builder() {
    return new BindRunningSecurityGroupRequest.Builder();
  }

  /**
   * Builds instances of type {@link BindRunningSecurityGroupRequest BindRunningSecurityGroupRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_BindRunningSecurityGroupRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_SECURITY_GROUP_ID = 0x1L;
    private long initBits = 0x1L;

    private String securityGroupId;
    private List<Relationship> boundSpaces = new ArrayList<Relationship>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.client.v3.securitygroups.AbstractBindSecurityGroupRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(AbstractBindSecurityGroupRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code BindRunningSecurityGroupRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(BindRunningSecurityGroupRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _BindRunningSecurityGroupRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(_BindRunningSecurityGroupRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    private void from(short _unused, Object object) {
      if (object instanceof AbstractBindSecurityGroupRequest) {
        AbstractBindSecurityGroupRequest instance = (AbstractBindSecurityGroupRequest) object;
        this.securityGroupId(instance.getSecurityGroupId());
        addAllBoundSpaces(instance.getBoundSpaces());
      }
    }

    /**
     * Initializes the value for the {@link BindRunningSecurityGroupRequest#getSecurityGroupId() securityGroupId} attribute.
     * @param securityGroupId The value for securityGroupId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder securityGroupId(String securityGroupId) {
      this.securityGroupId = Objects.requireNonNull(securityGroupId, "securityGroupId");
      initBits &= ~INIT_BIT_SECURITY_GROUP_ID;
      return this;
    }

    /**
     * Adds one element to {@link BindRunningSecurityGroupRequest#getBoundSpaces() boundSpaces} list.
     * @param element A boundSpaces element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder boundSpace(Relationship element) {
      this.boundSpaces.add(Objects.requireNonNull(element, "boundSpaces element"));
      return this;
    }

    /**
     * Adds elements to {@link BindRunningSecurityGroupRequest#getBoundSpaces() boundSpaces} list.
     * @param elements An array of boundSpaces elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder boundSpaces(Relationship... elements) {
      for (Relationship element : elements) {
        this.boundSpaces.add(Objects.requireNonNull(element, "boundSpaces element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link BindRunningSecurityGroupRequest#getBoundSpaces() boundSpaces} list.
     * @param elements An iterable of boundSpaces elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder boundSpaces(Iterable<? extends Relationship> elements) {
      this.boundSpaces.clear();
      return addAllBoundSpaces(elements);
    }

    /**
     * Adds elements to {@link BindRunningSecurityGroupRequest#getBoundSpaces() boundSpaces} list.
     * @param elements An iterable of boundSpaces elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllBoundSpaces(Iterable<? extends Relationship> elements) {
      for (Relationship element : elements) {
        this.boundSpaces.add(Objects.requireNonNull(element, "boundSpaces element"));
      }
      return this;
    }

    /**
     * Builds a new {@link BindRunningSecurityGroupRequest BindRunningSecurityGroupRequest}.
     * @return An immutable instance of BindRunningSecurityGroupRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public BindRunningSecurityGroupRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new BindRunningSecurityGroupRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_SECURITY_GROUP_ID) != 0) attributes.add("securityGroupId");
      return "Cannot build BindRunningSecurityGroupRequest, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>(size);
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
