package org.cloudfoundry.client.v3.securitygroups;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.immutables.value.Generated;

/**
 * The request payload for the Create a Security Group operation
 */
@Generated(from = "_CreateSecurityGroupRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class CreateSecurityGroupRequest
    extends org.cloudfoundry.client.v3.securitygroups._CreateSecurityGroupRequest {
  private final String name;
  private final @Nullable GloballyEnabled globallyEnabled;
  private final @Nullable List<Rule> rules;
  private final @Nullable Relationships relationships;

  private CreateSecurityGroupRequest(CreateSecurityGroupRequest.Builder builder) {
    this.name = builder.name;
    this.globallyEnabled = builder.globallyEnabled;
    this.rules = builder.rules == null ? null : createUnmodifiableList(true, builder.rules);
    this.relationships = builder.relationships;
  }

  /**
   * The security group name
   */
  @JsonProperty("name")
  @Override
  public String getName() {
    return name;
  }

  /**
   * the security group glbally enabled field
   */
  @JsonProperty("globally_enabled")
  @Override
  public @Nullable GloballyEnabled getGloballyEnabled() {
    return globallyEnabled;
  }

  /**
   * The security group rules
   */
  @JsonProperty("rules")
  @Override
  public @Nullable List<Rule> getRules() {
    return rules;
  }

  /**
   * The security group relationships
   */
  @JsonProperty("relationships")
  @Override
  public @Nullable Relationships getRelationships() {
    return relationships;
  }

  /**
   * This instance is equal to all instances of {@code CreateSecurityGroupRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof CreateSecurityGroupRequest
        && equalTo(0, (CreateSecurityGroupRequest) another);
  }

  private boolean equalTo(int synthetic, CreateSecurityGroupRequest another) {
    return name.equals(another.name)
        && Objects.equals(globallyEnabled, another.globallyEnabled)
        && Objects.equals(rules, another.rules)
        && Objects.equals(relationships, another.relationships);
  }

  /**
   * Computes a hash code from attributes: {@code name}, {@code globallyEnabled}, {@code rules}, {@code relationships}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + name.hashCode();
    h += (h << 5) + Objects.hashCode(globallyEnabled);
    h += (h << 5) + Objects.hashCode(rules);
    h += (h << 5) + Objects.hashCode(relationships);
    return h;
  }

  /**
   * Prints the immutable value {@code CreateSecurityGroupRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "CreateSecurityGroupRequest{"
        + "name=" + name
        + ", globallyEnabled=" + globallyEnabled
        + ", rules=" + rules
        + ", relationships=" + relationships
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_CreateSecurityGroupRequest", generator = "Immutables")
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v3.securitygroups._CreateSecurityGroupRequest {
    String name;
    GloballyEnabled globallyEnabled;
    List<Rule> rules = null;
    Relationships relationships;
    @JsonProperty("name")
    public void setName(String name) {
      this.name = name;
    }
    @JsonProperty("globally_enabled")
    public void setGloballyEnabled(@Nullable GloballyEnabled globallyEnabled) {
      this.globallyEnabled = globallyEnabled;
    }
    @JsonProperty("rules")
    public void setRules(@Nullable List<Rule> rules) {
      this.rules = rules;
    }
    @JsonProperty("relationships")
    public void setRelationships(@Nullable Relationships relationships) {
      this.relationships = relationships;
    }
    @Override
    public String getName() { throw new UnsupportedOperationException(); }
    @Override
    public GloballyEnabled getGloballyEnabled() { throw new UnsupportedOperationException(); }
    @Override
    public List<Rule> getRules() { throw new UnsupportedOperationException(); }
    @Override
    public Relationships getRelationships() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static CreateSecurityGroupRequest fromJson(Json json) {
    CreateSecurityGroupRequest.Builder builder = CreateSecurityGroupRequest.builder();
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.globallyEnabled != null) {
      builder.globallyEnabled(json.globallyEnabled);
    }
    if (json.rules != null) {
      builder.addAllRules(json.rules);
    }
    if (json.relationships != null) {
      builder.relationships(json.relationships);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link CreateSecurityGroupRequest CreateSecurityGroupRequest}.
   * <pre>
   * CreateSecurityGroupRequest.builder()
   *    .name(String) // required {@link CreateSecurityGroupRequest#getName() name}
   *    .globallyEnabled(org.cloudfoundry.client.v3.securitygroups.GloballyEnabled | null) // nullable {@link CreateSecurityGroupRequest#getGloballyEnabled() globallyEnabled}
   *    .rules(List&amp;lt;Rule&amp;gt; | null) // nullable {@link CreateSecurityGroupRequest#getRules() rules}
   *    .relationships(org.cloudfoundry.client.v3.securitygroups.Relationships | null) // nullable {@link CreateSecurityGroupRequest#getRelationships() relationships}
   *    .build();
   * </pre>
   * @return A new CreateSecurityGroupRequest builder
   */
  public static CreateSecurityGroupRequest.Builder builder() {
    return new CreateSecurityGroupRequest.Builder();
  }

  /**
   * Builds instances of type {@link CreateSecurityGroupRequest CreateSecurityGroupRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_CreateSecurityGroupRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_NAME = 0x1L;
    private long initBits = 0x1L;

    private String name;
    private GloballyEnabled globallyEnabled;
    private List<Rule> rules = null;
    private Relationships relationships;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code CreateSecurityGroupRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(CreateSecurityGroupRequest instance) {
      return from((_CreateSecurityGroupRequest) instance);
    }

    /**
     * Copy abstract value type {@code _CreateSecurityGroupRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_CreateSecurityGroupRequest instance) {
      Objects.requireNonNull(instance, "instance");
      this.name(instance.getName());
      GloballyEnabled globallyEnabledValue = instance.getGloballyEnabled();
      if (globallyEnabledValue != null) {
        globallyEnabled(globallyEnabledValue);
      }
      List<Rule> rulesValue = instance.getRules();
      if (rulesValue != null) {
        addAllRules(rulesValue);
      }
      Relationships relationshipsValue = instance.getRelationships();
      if (relationshipsValue != null) {
        relationships(relationshipsValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link CreateSecurityGroupRequest#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link CreateSecurityGroupRequest#getGloballyEnabled() globallyEnabled} attribute.
     * @param globallyEnabled The value for globallyEnabled (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder globallyEnabled(@Nullable GloballyEnabled globallyEnabled) {
      this.globallyEnabled = globallyEnabled;
      return this;
    }

    /**
     * Adds one element to {@link CreateSecurityGroupRequest#getRules() rules} list.
     * @param element A rules element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder rule(Rule element) {
      if (this.rules == null) {
        this.rules = new ArrayList<Rule>();
      }
      this.rules.add(Objects.requireNonNull(element, "rules element"));
      return this;
    }

    /**
     * Adds elements to {@link CreateSecurityGroupRequest#getRules() rules} list.
     * @param elements An array of rules elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder rules(Rule... elements) {
      if (this.rules == null) {
        this.rules = new ArrayList<Rule>();
      }
      for (Rule element : elements) {
        this.rules.add(Objects.requireNonNull(element, "rules element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link CreateSecurityGroupRequest#getRules() rules} list.
     * @param elements An iterable of rules elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder rules(@Nullable Iterable<? extends Rule> elements) {
      if (elements == null) {
        this.rules = null;
        return this;
      }
      this.rules = new ArrayList<Rule>();
      return addAllRules(elements);
    }

    /**
     * Adds elements to {@link CreateSecurityGroupRequest#getRules() rules} list.
     * @param elements An iterable of rules elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllRules(Iterable<? extends Rule> elements) {
      Objects.requireNonNull(elements, "rules element");
      if (this.rules == null) {
        this.rules = new ArrayList<Rule>();
      }
      for (Rule element : elements) {
        this.rules.add(Objects.requireNonNull(element, "rules element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link CreateSecurityGroupRequest#getRelationships() relationships} attribute.
     * @param relationships The value for relationships (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder relationships(@Nullable Relationships relationships) {
      this.relationships = relationships;
      return this;
    }

    /**
     * Builds a new {@link CreateSecurityGroupRequest CreateSecurityGroupRequest}.
     * @return An immutable instance of CreateSecurityGroupRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public CreateSecurityGroupRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new CreateSecurityGroupRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      return "Cannot build CreateSecurityGroupRequest, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>(size);
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
