package org.cloudfoundry.client.v3.securitygroups;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.immutables.value.Generated;

/**
 * Controls if the group is applied globally to the lifecycle of all applications
 */
@Generated(from = "_GloballyEnabled", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class GloballyEnabled extends org.cloudfoundry.client.v3.securitygroups._GloballyEnabled {
  private final @Nullable Boolean running;
  private final @Nullable Boolean staging;

  private GloballyEnabled(GloballyEnabled.Builder builder) {
    this.running = builder.running;
    this.staging = builder.staging;
  }

  /**
   * Specifies whether the group should be applied globally to all running applications
   */
  @JsonProperty("running")
  @Override
  public @Nullable Boolean getRunning() {
    return running;
  }

  /**
   * Specifies whether the group should be applied globally to all staging applications
   */
  @JsonProperty("staging")
  @Override
  public @Nullable Boolean getStaging() {
    return staging;
  }

  /**
   * This instance is equal to all instances of {@code GloballyEnabled} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof GloballyEnabled
        && equalTo(0, (GloballyEnabled) another);
  }

  private boolean equalTo(int synthetic, GloballyEnabled another) {
    return Objects.equals(running, another.running)
        && Objects.equals(staging, another.staging);
  }

  /**
   * Computes a hash code from attributes: {@code running}, {@code staging}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(running);
    h += (h << 5) + Objects.hashCode(staging);
    return h;
  }

  /**
   * Prints the immutable value {@code GloballyEnabled} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "GloballyEnabled{"
        + "running=" + running
        + ", staging=" + staging
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_GloballyEnabled", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v3.securitygroups._GloballyEnabled {
    Boolean running;
    Boolean staging;
    @JsonProperty("running")
    public void setRunning(@Nullable Boolean running) {
      this.running = running;
    }
    @JsonProperty("staging")
    public void setStaging(@Nullable Boolean staging) {
      this.staging = staging;
    }
    @Override
    public Boolean getRunning() { throw new UnsupportedOperationException(); }
    @Override
    public Boolean getStaging() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static GloballyEnabled fromJson(Json json) {
    GloballyEnabled.Builder builder = GloballyEnabled.builder();
    if (json.running != null) {
      builder.running(json.running);
    }
    if (json.staging != null) {
      builder.staging(json.staging);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link GloballyEnabled GloballyEnabled}.
   * <pre>
   * GloballyEnabled.builder()
   *    .running(Boolean | null) // nullable {@link GloballyEnabled#getRunning() running}
   *    .staging(Boolean | null) // nullable {@link GloballyEnabled#getStaging() staging}
   *    .build();
   * </pre>
   * @return A new GloballyEnabled builder
   */
  public static GloballyEnabled.Builder builder() {
    return new GloballyEnabled.Builder();
  }

  /**
   * Builds instances of type {@link GloballyEnabled GloballyEnabled}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_GloballyEnabled", generator = "Immutables")
  public static final class Builder {
    private Boolean running;
    private Boolean staging;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code GloballyEnabled} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(GloballyEnabled instance) {
      return from((_GloballyEnabled) instance);
    }

    /**
     * Copy abstract value type {@code _GloballyEnabled} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_GloballyEnabled instance) {
      Objects.requireNonNull(instance, "instance");
      Boolean runningValue = instance.getRunning();
      if (runningValue != null) {
        running(runningValue);
      }
      Boolean stagingValue = instance.getStaging();
      if (stagingValue != null) {
        staging(stagingValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link GloballyEnabled#getRunning() running} attribute.
     * @param running The value for running (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("running")
    public final Builder running(@Nullable Boolean running) {
      this.running = running;
      return this;
    }

    /**
     * Initializes the value for the {@link GloballyEnabled#getStaging() staging} attribute.
     * @param staging The value for staging (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("staging")
    public final Builder staging(@Nullable Boolean staging) {
      this.staging = staging;
      return this;
    }

    /**
     * Builds a new {@link GloballyEnabled GloballyEnabled}.
     * @return An immutable instance of GloballyEnabled
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public GloballyEnabled build() {
      return new GloballyEnabled(this);
    }
  }
}
