package org.cloudfoundry.client.v3.securitygroups;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v2.OrderDirection;
import org.cloudfoundry.client.v2.PaginatedRequest;
import org.immutables.value.Generated;

/**
 * The request payload for the List running Security Group operation
 */
@Generated(from = "_ListRunningSecurityGroupsRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ListRunningSecurityGroupsRequest
    extends org.cloudfoundry.client.v3.securitygroups._ListRunningSecurityGroupsRequest {
  private final @Nullable OrderDirection orderDirection;
  private final @Nullable Integer page;
  private final @Nullable Integer resultsPerPage;
  private final String spaceId;
  private final @Nullable List<String> securityGroupIds;
  private final @Nullable List<String> names;

  private ListRunningSecurityGroupsRequest(ListRunningSecurityGroupsRequest.Builder builder) {
    this.orderDirection = builder.orderDirection;
    this.page = builder.page;
    this.resultsPerPage = builder.resultsPerPage;
    this.spaceId = builder.spaceId;
    this.securityGroupIds = builder.securityGroupIds == null ? null : createUnmodifiableList(true, builder.securityGroupIds);
    this.names = builder.names == null ? null : createUnmodifiableList(true, builder.names);
  }

  /**
   * The order direction
   */
  @Override
  public @Nullable OrderDirection getOrderDirection() {
    return orderDirection;
  }

  /**
   * The page
   */
  @Override
  public @Nullable Integer getPage() {
    return page;
  }

  /**
   * The results per page
   */
  @Override
  public @Nullable Integer getResultsPerPage() {
    return resultsPerPage;
  }

  /**
   * The Space id
   */
  @Override
  public String getSpaceId() {
    return spaceId;
  }

  /**
   * The security group ids filter
   */
  @Override
  public @Nullable List<String> getSecurityGroupIds() {
    return securityGroupIds;
  }

  /**
   * The security group names filter
   */
  @Override
  public @Nullable List<String> getNames() {
    return names;
  }

  /**
   * This instance is equal to all instances of {@code ListRunningSecurityGroupsRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ListRunningSecurityGroupsRequest
        && equalTo(0, (ListRunningSecurityGroupsRequest) another);
  }

  private boolean equalTo(int synthetic, ListRunningSecurityGroupsRequest another) {
    return Objects.equals(orderDirection, another.orderDirection)
        && Objects.equals(page, another.page)
        && Objects.equals(resultsPerPage, another.resultsPerPage)
        && spaceId.equals(another.spaceId)
        && Objects.equals(securityGroupIds, another.securityGroupIds)
        && Objects.equals(names, another.names);
  }

  /**
   * Computes a hash code from attributes: {@code orderDirection}, {@code page}, {@code resultsPerPage}, {@code spaceId}, {@code securityGroupIds}, {@code names}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(orderDirection);
    h += (h << 5) + Objects.hashCode(page);
    h += (h << 5) + Objects.hashCode(resultsPerPage);
    h += (h << 5) + spaceId.hashCode();
    h += (h << 5) + Objects.hashCode(securityGroupIds);
    h += (h << 5) + Objects.hashCode(names);
    return h;
  }

  /**
   * Prints the immutable value {@code ListRunningSecurityGroupsRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ListRunningSecurityGroupsRequest{"
        + "orderDirection=" + orderDirection
        + ", page=" + page
        + ", resultsPerPage=" + resultsPerPage
        + ", spaceId=" + spaceId
        + ", securityGroupIds=" + securityGroupIds
        + ", names=" + names
        + "}";
  }

  /**
   * Creates a builder for {@link ListRunningSecurityGroupsRequest ListRunningSecurityGroupsRequest}.
   * <pre>
   * ListRunningSecurityGroupsRequest.builder()
   *    .orderDirection(org.cloudfoundry.client.v2.OrderDirection | null) // nullable {@link ListRunningSecurityGroupsRequest#getOrderDirection() orderDirection}
   *    .page(Integer | null) // nullable {@link ListRunningSecurityGroupsRequest#getPage() page}
   *    .resultsPerPage(Integer | null) // nullable {@link ListRunningSecurityGroupsRequest#getResultsPerPage() resultsPerPage}
   *    .spaceId(String) // required {@link ListRunningSecurityGroupsRequest#getSpaceId() spaceId}
   *    .securityGroupIds(List&amp;lt;String&amp;gt; | null) // nullable {@link ListRunningSecurityGroupsRequest#getSecurityGroupIds() securityGroupIds}
   *    .names(List&amp;lt;String&amp;gt; | null) // nullable {@link ListRunningSecurityGroupsRequest#getNames() names}
   *    .build();
   * </pre>
   * @return A new ListRunningSecurityGroupsRequest builder
   */
  public static ListRunningSecurityGroupsRequest.Builder builder() {
    return new ListRunningSecurityGroupsRequest.Builder();
  }

  /**
   * Builds instances of type {@link ListRunningSecurityGroupsRequest ListRunningSecurityGroupsRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_ListRunningSecurityGroupsRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_SPACE_ID = 0x1L;
    private long initBits = 0x1L;

    private OrderDirection orderDirection;
    private Integer page;
    private Integer resultsPerPage;
    private String spaceId;
    private List<String> securityGroupIds = null;
    private List<String> names = null;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.client.v3.securitygroups.AbstractListSecurityGroupRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(AbstractListSecurityGroupRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code ListRunningSecurityGroupsRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ListRunningSecurityGroupsRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _ListRunningSecurityGroupsRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(_ListRunningSecurityGroupsRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.client.v2.PaginatedRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(PaginatedRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    private void from(short _unused, Object object) {
      long bits = 0;
      if (object instanceof AbstractListSecurityGroupRequest) {
        AbstractListSecurityGroupRequest instance = (AbstractListSecurityGroupRequest) object;
        if ((bits & 0x1L) == 0) {
          this.spaceId(instance.getSpaceId());
          bits |= 0x1L;
        }
        if ((bits & 0x10L) == 0) {
          OrderDirection orderDirectionValue = instance.getOrderDirection();
          if (orderDirectionValue != null) {
            orderDirection(orderDirectionValue);
          }
          bits |= 0x10L;
        }
        if ((bits & 0x2L) == 0) {
          Integer resultsPerPageValue = instance.getResultsPerPage();
          if (resultsPerPageValue != null) {
            resultsPerPage(resultsPerPageValue);
          }
          bits |= 0x2L;
        }
        if ((bits & 0x4L) == 0) {
          List<String> namesValue = instance.getNames();
          if (namesValue != null) {
            addAllNames(namesValue);
          }
          bits |= 0x4L;
        }
        if ((bits & 0x20L) == 0) {
          Integer pageValue = instance.getPage();
          if (pageValue != null) {
            page(pageValue);
          }
          bits |= 0x20L;
        }
        if ((bits & 0x8L) == 0) {
          List<String> securityGroupIdsValue = instance.getSecurityGroupIds();
          if (securityGroupIdsValue != null) {
            addAllSecurityGroupIds(securityGroupIdsValue);
          }
          bits |= 0x8L;
        }
      }
      if (object instanceof org.cloudfoundry.client.v3.securitygroups._ListRunningSecurityGroupsRequest) {
        org.cloudfoundry.client.v3.securitygroups._ListRunningSecurityGroupsRequest instance = (org.cloudfoundry.client.v3.securitygroups._ListRunningSecurityGroupsRequest) object;
        if ((bits & 0x1L) == 0) {
          this.spaceId(instance.getSpaceId());
          bits |= 0x1L;
        }
        if ((bits & 0x8L) == 0) {
          List<String> securityGroupIdsValue = instance.getSecurityGroupIds();
          if (securityGroupIdsValue != null) {
            addAllSecurityGroupIds(securityGroupIdsValue);
          }
          bits |= 0x8L;
        }
        if ((bits & 0x4L) == 0) {
          List<String> namesValue = instance.getNames();
          if (namesValue != null) {
            addAllNames(namesValue);
          }
          bits |= 0x4L;
        }
      }
      if (object instanceof PaginatedRequest) {
        PaginatedRequest instance = (PaginatedRequest) object;
        if ((bits & 0x10L) == 0) {
          OrderDirection orderDirectionValue = instance.getOrderDirection();
          if (orderDirectionValue != null) {
            orderDirection(orderDirectionValue);
          }
          bits |= 0x10L;
        }
        if ((bits & 0x2L) == 0) {
          Integer resultsPerPageValue = instance.getResultsPerPage();
          if (resultsPerPageValue != null) {
            resultsPerPage(resultsPerPageValue);
          }
          bits |= 0x2L;
        }
        if ((bits & 0x20L) == 0) {
          Integer pageValue = instance.getPage();
          if (pageValue != null) {
            page(pageValue);
          }
          bits |= 0x20L;
        }
      }
    }

    /**
     * Initializes the value for the {@link ListRunningSecurityGroupsRequest#getOrderDirection() orderDirection} attribute.
     * @param orderDirection The value for orderDirection (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder orderDirection(@Nullable OrderDirection orderDirection) {
      this.orderDirection = orderDirection;
      return this;
    }

    /**
     * Initializes the value for the {@link ListRunningSecurityGroupsRequest#getPage() page} attribute.
     * @param page The value for page (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder page(@Nullable Integer page) {
      this.page = page;
      return this;
    }

    /**
     * Initializes the value for the {@link ListRunningSecurityGroupsRequest#getResultsPerPage() resultsPerPage} attribute.
     * @param resultsPerPage The value for resultsPerPage (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder resultsPerPage(@Nullable Integer resultsPerPage) {
      this.resultsPerPage = resultsPerPage;
      return this;
    }

    /**
     * Initializes the value for the {@link ListRunningSecurityGroupsRequest#getSpaceId() spaceId} attribute.
     * @param spaceId The value for spaceId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder spaceId(String spaceId) {
      this.spaceId = Objects.requireNonNull(spaceId, "spaceId");
      initBits &= ~INIT_BIT_SPACE_ID;
      return this;
    }

    /**
     * Adds one element to {@link ListRunningSecurityGroupsRequest#getSecurityGroupIds() securityGroupIds} list.
     * @param element A securityGroupIds element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder securityGroupId(String element) {
      if (this.securityGroupIds == null) {
        this.securityGroupIds = new ArrayList<String>();
      }
      this.securityGroupIds.add(Objects.requireNonNull(element, "securityGroupIds element"));
      return this;
    }

    /**
     * Adds elements to {@link ListRunningSecurityGroupsRequest#getSecurityGroupIds() securityGroupIds} list.
     * @param elements An array of securityGroupIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder securityGroupIds(String... elements) {
      if (this.securityGroupIds == null) {
        this.securityGroupIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.securityGroupIds.add(Objects.requireNonNull(element, "securityGroupIds element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListRunningSecurityGroupsRequest#getSecurityGroupIds() securityGroupIds} list.
     * @param elements An iterable of securityGroupIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder securityGroupIds(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.securityGroupIds = null;
        return this;
      }
      this.securityGroupIds = new ArrayList<String>();
      return addAllSecurityGroupIds(elements);
    }

    /**
     * Adds elements to {@link ListRunningSecurityGroupsRequest#getSecurityGroupIds() securityGroupIds} list.
     * @param elements An iterable of securityGroupIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllSecurityGroupIds(Iterable<String> elements) {
      Objects.requireNonNull(elements, "securityGroupIds element");
      if (this.securityGroupIds == null) {
        this.securityGroupIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.securityGroupIds.add(Objects.requireNonNull(element, "securityGroupIds element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link ListRunningSecurityGroupsRequest#getNames() names} list.
     * @param element A names element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(String element) {
      if (this.names == null) {
        this.names = new ArrayList<String>();
      }
      this.names.add(Objects.requireNonNull(element, "names element"));
      return this;
    }

    /**
     * Adds elements to {@link ListRunningSecurityGroupsRequest#getNames() names} list.
     * @param elements An array of names elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder names(String... elements) {
      if (this.names == null) {
        this.names = new ArrayList<String>();
      }
      for (String element : elements) {
        this.names.add(Objects.requireNonNull(element, "names element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListRunningSecurityGroupsRequest#getNames() names} list.
     * @param elements An iterable of names elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder names(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.names = null;
        return this;
      }
      this.names = new ArrayList<String>();
      return addAllNames(elements);
    }

    /**
     * Adds elements to {@link ListRunningSecurityGroupsRequest#getNames() names} list.
     * @param elements An iterable of names elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllNames(Iterable<String> elements) {
      Objects.requireNonNull(elements, "names element");
      if (this.names == null) {
        this.names = new ArrayList<String>();
      }
      for (String element : elements) {
        this.names.add(Objects.requireNonNull(element, "names element"));
      }
      return this;
    }

    /**
     * Builds a new {@link ListRunningSecurityGroupsRequest ListRunningSecurityGroupsRequest}.
     * @return An immutable instance of ListRunningSecurityGroupsRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ListRunningSecurityGroupsRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ListRunningSecurityGroupsRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_SPACE_ID) != 0) attributes.add("spaceId");
      return "Cannot build ListRunningSecurityGroupsRequest, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>(size);
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
