package org.cloudfoundry.client.v3.securitygroups;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.PaginatedRequest;
import org.immutables.value.Generated;

/**
 * The request payload for the List Security Group operation
 */
@Generated(from = "_ListSecurityGroupsRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ListSecurityGroupsRequest
    extends org.cloudfoundry.client.v3.securitygroups._ListSecurityGroupsRequest {
  private final @Nullable String orderBy;
  private final @Nullable Integer page;
  private final @Nullable Integer perPage;
  private final List<String> securityGroupIds;
  private final List<String> names;
  private final @Nullable Boolean globallyEnabledRunning;
  private final @Nullable Boolean globallyEnabledStagingBoolean;
  private final @Nullable List<String> runningSpaceIds;
  private final @Nullable List<String> stagingSpaceIds;

  private ListSecurityGroupsRequest(ListSecurityGroupsRequest.Builder builder) {
    this.orderBy = builder.orderBy;
    this.page = builder.page;
    this.perPage = builder.perPage;
    this.securityGroupIds = createUnmodifiableList(true, builder.securityGroupIds);
    this.names = createUnmodifiableList(true, builder.names);
    this.globallyEnabledRunning = builder.globallyEnabledRunning;
    this.globallyEnabledStagingBoolean = builder.globallyEnabledStagingBoolean;
    this.runningSpaceIds = builder.runningSpaceIds == null ? null : createUnmodifiableList(true, builder.runningSpaceIds);
    this.stagingSpaceIds = builder.stagingSpaceIds == null ? null : createUnmodifiableList(true, builder.stagingSpaceIds);
  }

  /**
   * The order by
   */
  @JsonIgnore
  @Override
  public @Nullable String getOrderBy() {
    return orderBy;
  }

  /**
   * The page
   */
  @JsonIgnore
  @Override
  public @Nullable Integer getPage() {
    return page;
  }

  /**
   * The results per page
   */
  @JsonIgnore
  @Override
  public @Nullable Integer getPerPage() {
    return perPage;
  }

  /**
   * The security group ids filter
   */
  @JsonIgnore
  @Override
  public List<String> getSecurityGroupIds() {
    return securityGroupIds;
  }

  /**
   * The security group names filter
   */
  @JsonIgnore
  @Override
  public List<String> getNames() {
    return names;
  }

  /**
   * the security group globally enabled running filter
   */
  @JsonIgnore
  @Override
  public @Nullable Boolean getGloballyEnabledRunning() {
    return globallyEnabledRunning;
  }

  /**
   * the security group globally enabled staging filter
   */
  @JsonIgnore
  @Override
  public @Nullable Boolean getGloballyEnabledStagingBoolean() {
    return globallyEnabledStagingBoolean;
  }

  /**
   * the security group running_space_guids filter
   */
  @JsonIgnore
  @Override
  public @Nullable List<String> getRunningSpaceIds() {
    return runningSpaceIds;
  }

  /**
   * the security group staging_space_guids filter
   */
  @JsonIgnore
  @Override
  public @Nullable List<String> getStagingSpaceIds() {
    return stagingSpaceIds;
  }

  /**
   * This instance is equal to all instances of {@code ListSecurityGroupsRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ListSecurityGroupsRequest
        && equalTo(0, (ListSecurityGroupsRequest) another);
  }

  private boolean equalTo(int synthetic, ListSecurityGroupsRequest another) {
    return Objects.equals(orderBy, another.orderBy)
        && Objects.equals(page, another.page)
        && Objects.equals(perPage, another.perPage)
        && securityGroupIds.equals(another.securityGroupIds)
        && names.equals(another.names)
        && Objects.equals(globallyEnabledRunning, another.globallyEnabledRunning)
        && Objects.equals(globallyEnabledStagingBoolean, another.globallyEnabledStagingBoolean)
        && Objects.equals(runningSpaceIds, another.runningSpaceIds)
        && Objects.equals(stagingSpaceIds, another.stagingSpaceIds);
  }

  /**
   * Computes a hash code from attributes: {@code orderBy}, {@code page}, {@code perPage}, {@code securityGroupIds}, {@code names}, {@code globallyEnabledRunning}, {@code globallyEnabledStagingBoolean}, {@code runningSpaceIds}, {@code stagingSpaceIds}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(orderBy);
    h += (h << 5) + Objects.hashCode(page);
    h += (h << 5) + Objects.hashCode(perPage);
    h += (h << 5) + securityGroupIds.hashCode();
    h += (h << 5) + names.hashCode();
    h += (h << 5) + Objects.hashCode(globallyEnabledRunning);
    h += (h << 5) + Objects.hashCode(globallyEnabledStagingBoolean);
    h += (h << 5) + Objects.hashCode(runningSpaceIds);
    h += (h << 5) + Objects.hashCode(stagingSpaceIds);
    return h;
  }

  /**
   * Prints the immutable value {@code ListSecurityGroupsRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ListSecurityGroupsRequest{"
        + "orderBy=" + orderBy
        + ", page=" + page
        + ", perPage=" + perPage
        + ", securityGroupIds=" + securityGroupIds
        + ", names=" + names
        + ", globallyEnabledRunning=" + globallyEnabledRunning
        + ", globallyEnabledStagingBoolean=" + globallyEnabledStagingBoolean
        + ", runningSpaceIds=" + runningSpaceIds
        + ", stagingSpaceIds=" + stagingSpaceIds
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_ListSecurityGroupsRequest", generator = "Immutables")
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v3.securitygroups._ListSecurityGroupsRequest {
    String orderBy;
    Integer page;
    Integer perPage;
    List<String> securityGroupIds = Collections.emptyList();
    List<String> names = Collections.emptyList();
    Boolean globallyEnabledRunning;
    Boolean globallyEnabledStagingBoolean;
    List<String> runningSpaceIds = null;
    List<String> stagingSpaceIds = null;
    @JsonIgnore
    public void setOrderBy(@Nullable String orderBy) {
      this.orderBy = orderBy;
    }
    @JsonIgnore
    public void setPage(@Nullable Integer page) {
      this.page = page;
    }
    @JsonIgnore
    public void setPerPage(@Nullable Integer perPage) {
      this.perPage = perPage;
    }
    @JsonIgnore
    public void setSecurityGroupIds(List<String> securityGroupIds) {
      this.securityGroupIds = securityGroupIds;
    }
    @JsonIgnore
    public void setNames(List<String> names) {
      this.names = names;
    }
    @JsonIgnore
    public void setGloballyEnabledRunning(@Nullable Boolean globallyEnabledRunning) {
      this.globallyEnabledRunning = globallyEnabledRunning;
    }
    @JsonIgnore
    public void setGloballyEnabledStagingBoolean(@Nullable Boolean globallyEnabledStagingBoolean) {
      this.globallyEnabledStagingBoolean = globallyEnabledStagingBoolean;
    }
    @JsonIgnore
    public void setRunningSpaceIds(@Nullable List<String> runningSpaceIds) {
      this.runningSpaceIds = runningSpaceIds;
    }
    @JsonIgnore
    public void setStagingSpaceIds(@Nullable List<String> stagingSpaceIds) {
      this.stagingSpaceIds = stagingSpaceIds;
    }
    @Override
    public String getOrderBy() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getPage() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getPerPage() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> getSecurityGroupIds() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> getNames() { throw new UnsupportedOperationException(); }
    @Override
    public Boolean getGloballyEnabledRunning() { throw new UnsupportedOperationException(); }
    @Override
    public Boolean getGloballyEnabledStagingBoolean() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> getRunningSpaceIds() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> getStagingSpaceIds() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ListSecurityGroupsRequest fromJson(Json json) {
    ListSecurityGroupsRequest.Builder builder = ListSecurityGroupsRequest.builder();
    if (json.orderBy != null) {
      builder.orderBy(json.orderBy);
    }
    if (json.page != null) {
      builder.page(json.page);
    }
    if (json.perPage != null) {
      builder.perPage(json.perPage);
    }
    if (json.securityGroupIds != null) {
      builder.addAllSecurityGroupIds(json.securityGroupIds);
    }
    if (json.names != null) {
      builder.addAllNames(json.names);
    }
    if (json.globallyEnabledRunning != null) {
      builder.globallyEnabledRunning(json.globallyEnabledRunning);
    }
    if (json.globallyEnabledStagingBoolean != null) {
      builder.globallyEnabledStagingBoolean(json.globallyEnabledStagingBoolean);
    }
    if (json.runningSpaceIds != null) {
      builder.addAllRunningSpaceIds(json.runningSpaceIds);
    }
    if (json.stagingSpaceIds != null) {
      builder.addAllStagingSpaceIds(json.stagingSpaceIds);
    }
    return builder.build();
  }

  private static ListSecurityGroupsRequest validate(ListSecurityGroupsRequest instance) {
    instance.check();
    return instance;
  }

  /**
   * Creates a builder for {@link ListSecurityGroupsRequest ListSecurityGroupsRequest}.
   * <pre>
   * ListSecurityGroupsRequest.builder()
   *    .orderBy(String | null) // nullable {@link ListSecurityGroupsRequest#getOrderBy() orderBy}
   *    .page(Integer | null) // nullable {@link ListSecurityGroupsRequest#getPage() page}
   *    .perPage(Integer | null) // nullable {@link ListSecurityGroupsRequest#getPerPage() perPage}
   *    .securityGroupId|addAllSecurityGroupIds(String) // {@link ListSecurityGroupsRequest#getSecurityGroupIds() securityGroupIds} elements
   *    .name|addAllNames(String) // {@link ListSecurityGroupsRequest#getNames() names} elements
   *    .globallyEnabledRunning(Boolean | null) // nullable {@link ListSecurityGroupsRequest#getGloballyEnabledRunning() globallyEnabledRunning}
   *    .globallyEnabledStagingBoolean(Boolean | null) // nullable {@link ListSecurityGroupsRequest#getGloballyEnabledStagingBoolean() globallyEnabledStagingBoolean}
   *    .runningSpaceIds(List&amp;lt;String&amp;gt; | null) // nullable {@link ListSecurityGroupsRequest#getRunningSpaceIds() runningSpaceIds}
   *    .stagingSpaceIds(List&amp;lt;String&amp;gt; | null) // nullable {@link ListSecurityGroupsRequest#getStagingSpaceIds() stagingSpaceIds}
   *    .build();
   * </pre>
   * @return A new ListSecurityGroupsRequest builder
   */
  public static ListSecurityGroupsRequest.Builder builder() {
    return new ListSecurityGroupsRequest.Builder();
  }

  /**
   * Builds instances of type {@link ListSecurityGroupsRequest ListSecurityGroupsRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_ListSecurityGroupsRequest", generator = "Immutables")
  public static final class Builder {
    private String orderBy;
    private Integer page;
    private Integer perPage;
    private List<String> securityGroupIds = new ArrayList<String>();
    private List<String> names = new ArrayList<String>();
    private Boolean globallyEnabledRunning;
    private Boolean globallyEnabledStagingBoolean;
    private List<String> runningSpaceIds = null;
    private List<String> stagingSpaceIds = null;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.client.v3.PaginatedRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(PaginatedRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code ListSecurityGroupsRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ListSecurityGroupsRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _ListSecurityGroupsRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(_ListSecurityGroupsRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    private void from(short _unused, Object object) {
      if (object instanceof PaginatedRequest) {
        PaginatedRequest instance = (PaginatedRequest) object;
        String orderByValue = instance.getOrderBy();
        if (orderByValue != null) {
          orderBy(orderByValue);
        }
        Integer perPageValue = instance.getPerPage();
        if (perPageValue != null) {
          perPage(perPageValue);
        }
        Integer pageValue = instance.getPage();
        if (pageValue != null) {
          page(pageValue);
        }
      }
      if (object instanceof org.cloudfoundry.client.v3.securitygroups._ListSecurityGroupsRequest) {
        org.cloudfoundry.client.v3.securitygroups._ListSecurityGroupsRequest instance = (org.cloudfoundry.client.v3.securitygroups._ListSecurityGroupsRequest) object;
        List<String> stagingSpaceIdsValue = instance.getStagingSpaceIds();
        if (stagingSpaceIdsValue != null) {
          addAllStagingSpaceIds(stagingSpaceIdsValue);
        }
        addAllNames(instance.getNames());
        Boolean globallyEnabledStagingBooleanValue = instance.getGloballyEnabledStagingBoolean();
        if (globallyEnabledStagingBooleanValue != null) {
          globallyEnabledStagingBoolean(globallyEnabledStagingBooleanValue);
        }
        List<String> runningSpaceIdsValue = instance.getRunningSpaceIds();
        if (runningSpaceIdsValue != null) {
          addAllRunningSpaceIds(runningSpaceIdsValue);
        }
        Boolean globallyEnabledRunningValue = instance.getGloballyEnabledRunning();
        if (globallyEnabledRunningValue != null) {
          globallyEnabledRunning(globallyEnabledRunningValue);
        }
        addAllSecurityGroupIds(instance.getSecurityGroupIds());
      }
    }

    /**
     * Initializes the value for the {@link ListSecurityGroupsRequest#getOrderBy() orderBy} attribute.
     * @param orderBy The value for orderBy (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder orderBy(@Nullable String orderBy) {
      this.orderBy = orderBy;
      return this;
    }

    /**
     * Initializes the value for the {@link ListSecurityGroupsRequest#getPage() page} attribute.
     * @param page The value for page (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder page(@Nullable Integer page) {
      this.page = page;
      return this;
    }

    /**
     * Initializes the value for the {@link ListSecurityGroupsRequest#getPerPage() perPage} attribute.
     * @param perPage The value for perPage (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder perPage(@Nullable Integer perPage) {
      this.perPage = perPage;
      return this;
    }

    /**
     * Adds one element to {@link ListSecurityGroupsRequest#getSecurityGroupIds() securityGroupIds} list.
     * @param element A securityGroupIds element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder securityGroupId(String element) {
      this.securityGroupIds.add(Objects.requireNonNull(element, "securityGroupIds element"));
      return this;
    }

    /**
     * Adds elements to {@link ListSecurityGroupsRequest#getSecurityGroupIds() securityGroupIds} list.
     * @param elements An array of securityGroupIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder securityGroupIds(String... elements) {
      for (String element : elements) {
        this.securityGroupIds.add(Objects.requireNonNull(element, "securityGroupIds element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListSecurityGroupsRequest#getSecurityGroupIds() securityGroupIds} list.
     * @param elements An iterable of securityGroupIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder securityGroupIds(Iterable<String> elements) {
      this.securityGroupIds.clear();
      return addAllSecurityGroupIds(elements);
    }

    /**
     * Adds elements to {@link ListSecurityGroupsRequest#getSecurityGroupIds() securityGroupIds} list.
     * @param elements An iterable of securityGroupIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllSecurityGroupIds(Iterable<String> elements) {
      for (String element : elements) {
        this.securityGroupIds.add(Objects.requireNonNull(element, "securityGroupIds element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link ListSecurityGroupsRequest#getNames() names} list.
     * @param element A names element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(String element) {
      this.names.add(Objects.requireNonNull(element, "names element"));
      return this;
    }

    /**
     * Adds elements to {@link ListSecurityGroupsRequest#getNames() names} list.
     * @param elements An array of names elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder names(String... elements) {
      for (String element : elements) {
        this.names.add(Objects.requireNonNull(element, "names element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListSecurityGroupsRequest#getNames() names} list.
     * @param elements An iterable of names elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder names(Iterable<String> elements) {
      this.names.clear();
      return addAllNames(elements);
    }

    /**
     * Adds elements to {@link ListSecurityGroupsRequest#getNames() names} list.
     * @param elements An iterable of names elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllNames(Iterable<String> elements) {
      for (String element : elements) {
        this.names.add(Objects.requireNonNull(element, "names element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link ListSecurityGroupsRequest#getGloballyEnabledRunning() globallyEnabledRunning} attribute.
     * @param globallyEnabledRunning The value for globallyEnabledRunning (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder globallyEnabledRunning(@Nullable Boolean globallyEnabledRunning) {
      this.globallyEnabledRunning = globallyEnabledRunning;
      return this;
    }

    /**
     * Initializes the value for the {@link ListSecurityGroupsRequest#getGloballyEnabledStagingBoolean() globallyEnabledStagingBoolean} attribute.
     * @param globallyEnabledStagingBoolean The value for globallyEnabledStagingBoolean (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder globallyEnabledStagingBoolean(@Nullable Boolean globallyEnabledStagingBoolean) {
      this.globallyEnabledStagingBoolean = globallyEnabledStagingBoolean;
      return this;
    }

    /**
     * Adds one element to {@link ListSecurityGroupsRequest#getRunningSpaceIds() runningSpaceIds} list.
     * @param element A runningSpaceIds element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder runningSpaceId(String element) {
      if (this.runningSpaceIds == null) {
        this.runningSpaceIds = new ArrayList<String>();
      }
      this.runningSpaceIds.add(Objects.requireNonNull(element, "runningSpaceIds element"));
      return this;
    }

    /**
     * Adds elements to {@link ListSecurityGroupsRequest#getRunningSpaceIds() runningSpaceIds} list.
     * @param elements An array of runningSpaceIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder runningSpaceIds(String... elements) {
      if (this.runningSpaceIds == null) {
        this.runningSpaceIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.runningSpaceIds.add(Objects.requireNonNull(element, "runningSpaceIds element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListSecurityGroupsRequest#getRunningSpaceIds() runningSpaceIds} list.
     * @param elements An iterable of runningSpaceIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder runningSpaceIds(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.runningSpaceIds = null;
        return this;
      }
      this.runningSpaceIds = new ArrayList<String>();
      return addAllRunningSpaceIds(elements);
    }

    /**
     * Adds elements to {@link ListSecurityGroupsRequest#getRunningSpaceIds() runningSpaceIds} list.
     * @param elements An iterable of runningSpaceIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllRunningSpaceIds(Iterable<String> elements) {
      Objects.requireNonNull(elements, "runningSpaceIds element");
      if (this.runningSpaceIds == null) {
        this.runningSpaceIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.runningSpaceIds.add(Objects.requireNonNull(element, "runningSpaceIds element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link ListSecurityGroupsRequest#getStagingSpaceIds() stagingSpaceIds} list.
     * @param element A stagingSpaceIds element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder stagingSpaceId(String element) {
      if (this.stagingSpaceIds == null) {
        this.stagingSpaceIds = new ArrayList<String>();
      }
      this.stagingSpaceIds.add(Objects.requireNonNull(element, "stagingSpaceIds element"));
      return this;
    }

    /**
     * Adds elements to {@link ListSecurityGroupsRequest#getStagingSpaceIds() stagingSpaceIds} list.
     * @param elements An array of stagingSpaceIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder stagingSpaceIds(String... elements) {
      if (this.stagingSpaceIds == null) {
        this.stagingSpaceIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.stagingSpaceIds.add(Objects.requireNonNull(element, "stagingSpaceIds element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListSecurityGroupsRequest#getStagingSpaceIds() stagingSpaceIds} list.
     * @param elements An iterable of stagingSpaceIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder stagingSpaceIds(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.stagingSpaceIds = null;
        return this;
      }
      this.stagingSpaceIds = new ArrayList<String>();
      return addAllStagingSpaceIds(elements);
    }

    /**
     * Adds elements to {@link ListSecurityGroupsRequest#getStagingSpaceIds() stagingSpaceIds} list.
     * @param elements An iterable of stagingSpaceIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllStagingSpaceIds(Iterable<String> elements) {
      Objects.requireNonNull(elements, "stagingSpaceIds element");
      if (this.stagingSpaceIds == null) {
        this.stagingSpaceIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.stagingSpaceIds.add(Objects.requireNonNull(element, "stagingSpaceIds element"));
      }
      return this;
    }

    /**
     * Builds a new {@link ListSecurityGroupsRequest ListSecurityGroupsRequest}.
     * @return An immutable instance of ListSecurityGroupsRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ListSecurityGroupsRequest build() {
      return ListSecurityGroupsRequest.validate(new ListSecurityGroupsRequest(this));
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>(size);
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
