package org.cloudfoundry.client.v3.securitygroups;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * The request payload for the Unbind Staging Security Group operation
 */
@Generated(from = "_UnbindStagingSecurityGroupRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class UnbindStagingSecurityGroupRequest
    extends org.cloudfoundry.client.v3.securitygroups._UnbindStagingSecurityGroupRequest {
  private final String securityGroupId;
  private final String spaceId;

  private UnbindStagingSecurityGroupRequest(UnbindStagingSecurityGroupRequest.Builder builder) {
    this.securityGroupId = builder.securityGroupId;
    this.spaceId = builder.spaceId;
  }

  /**
   * The Security Group id
   */
  @Override
  public String getSecurityGroupId() {
    return securityGroupId;
  }

  /**
   * The Space id
   */
  @Override
  public String getSpaceId() {
    return spaceId;
  }

  /**
   * This instance is equal to all instances of {@code UnbindStagingSecurityGroupRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof UnbindStagingSecurityGroupRequest
        && equalTo(0, (UnbindStagingSecurityGroupRequest) another);
  }

  private boolean equalTo(int synthetic, UnbindStagingSecurityGroupRequest another) {
    return securityGroupId.equals(another.securityGroupId)
        && spaceId.equals(another.spaceId);
  }

  /**
   * Computes a hash code from attributes: {@code securityGroupId}, {@code spaceId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + securityGroupId.hashCode();
    h += (h << 5) + spaceId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code UnbindStagingSecurityGroupRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "UnbindStagingSecurityGroupRequest{"
        + "securityGroupId=" + securityGroupId
        + ", spaceId=" + spaceId
        + "}";
  }

  /**
   * Creates a builder for {@link UnbindStagingSecurityGroupRequest UnbindStagingSecurityGroupRequest}.
   * <pre>
   * UnbindStagingSecurityGroupRequest.builder()
   *    .securityGroupId(String) // required {@link UnbindStagingSecurityGroupRequest#getSecurityGroupId() securityGroupId}
   *    .spaceId(String) // required {@link UnbindStagingSecurityGroupRequest#getSpaceId() spaceId}
   *    .build();
   * </pre>
   * @return A new UnbindStagingSecurityGroupRequest builder
   */
  public static UnbindStagingSecurityGroupRequest.Builder builder() {
    return new UnbindStagingSecurityGroupRequest.Builder();
  }

  /**
   * Builds instances of type {@link UnbindStagingSecurityGroupRequest UnbindStagingSecurityGroupRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_UnbindStagingSecurityGroupRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_SECURITY_GROUP_ID = 0x1L;
    private static final long INIT_BIT_SPACE_ID = 0x2L;
    private long initBits = 0x3L;

    private String securityGroupId;
    private String spaceId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.client.v3.securitygroups.AbstractUnbindSecurityGroupRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(AbstractUnbindSecurityGroupRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code UnbindStagingSecurityGroupRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(UnbindStagingSecurityGroupRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _UnbindStagingSecurityGroupRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(_UnbindStagingSecurityGroupRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    private void from(short _unused, Object object) {
      if (object instanceof AbstractUnbindSecurityGroupRequest) {
        AbstractUnbindSecurityGroupRequest instance = (AbstractUnbindSecurityGroupRequest) object;
        this.securityGroupId(instance.getSecurityGroupId());
        this.spaceId(instance.getSpaceId());
      }
    }

    /**
     * Initializes the value for the {@link UnbindStagingSecurityGroupRequest#getSecurityGroupId() securityGroupId} attribute.
     * @param securityGroupId The value for securityGroupId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder securityGroupId(String securityGroupId) {
      this.securityGroupId = Objects.requireNonNull(securityGroupId, "securityGroupId");
      initBits &= ~INIT_BIT_SECURITY_GROUP_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link UnbindStagingSecurityGroupRequest#getSpaceId() spaceId} attribute.
     * @param spaceId The value for spaceId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder spaceId(String spaceId) {
      this.spaceId = Objects.requireNonNull(spaceId, "spaceId");
      initBits &= ~INIT_BIT_SPACE_ID;
      return this;
    }

    /**
     * Builds a new {@link UnbindStagingSecurityGroupRequest UnbindStagingSecurityGroupRequest}.
     * @return An immutable instance of UnbindStagingSecurityGroupRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public UnbindStagingSecurityGroupRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new UnbindStagingSecurityGroupRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_SECURITY_GROUP_ID) != 0) attributes.add("securityGroupId");
      if ((initBits & INIT_BIT_SPACE_ID) != 0) attributes.add("spaceId");
      return "Cannot build UnbindStagingSecurityGroupRequest, some of required attributes are not set " + attributes;
    }
  }
}
