package org.cloudfoundry.client.v3.servicebindings;

import java.util.Objects;
import java.util.Optional;
import org.immutables.value.Generated;

/**
 * The response payload for Create Service Binding
 */
@Generated(from = "_CreateServiceBindingResponse", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class CreateServiceBindingResponse
    extends org.cloudfoundry.client.v3.servicebindings._CreateServiceBindingResponse {
  private final String jobId;
  private final ServiceBindingResource serviceBinding;

  private CreateServiceBindingResponse(CreateServiceBindingResponse.Builder builder) {
    this.jobId = builder.jobId;
    this.serviceBinding = builder.serviceBinding;
  }

  /**
   * @return The value of the {@code jobId} attribute
   */
  @Override
  public Optional<String> getJobId() {
    return Optional.ofNullable(jobId);
  }

  /**
   * @return The value of the {@code serviceBinding} attribute
   */
  @Override
  public Optional<ServiceBindingResource> getServiceBinding() {
    return Optional.ofNullable(serviceBinding);
  }

  /**
   * This instance is equal to all instances of {@code CreateServiceBindingResponse} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof CreateServiceBindingResponse
        && equalTo(0, (CreateServiceBindingResponse) another);
  }

  private boolean equalTo(int synthetic, CreateServiceBindingResponse another) {
    return Objects.equals(jobId, another.jobId)
        && Objects.equals(serviceBinding, another.serviceBinding);
  }

  /**
   * Computes a hash code from attributes: {@code jobId}, {@code serviceBinding}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(jobId);
    h += (h << 5) + Objects.hashCode(serviceBinding);
    return h;
  }

  /**
   * Prints the immutable value {@code CreateServiceBindingResponse} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("CreateServiceBindingResponse{");
    if (jobId != null) {
      builder.append("jobId=").append(jobId);
    }
    if (serviceBinding != null) {
      if (builder.length() > 29) builder.append(", ");
      builder.append("serviceBinding=").append(serviceBinding);
    }
    return builder.append("}").toString();
  }

  /**
   * Creates a builder for {@link CreateServiceBindingResponse CreateServiceBindingResponse}.
   * <pre>
   * CreateServiceBindingResponse.builder()
   *    .jobId(String) // optional {@link CreateServiceBindingResponse#getJobId() jobId}
   *    .serviceBinding(ServiceBindingResource) // optional {@link CreateServiceBindingResponse#getServiceBinding() serviceBinding}
   *    .build();
   * </pre>
   * @return A new CreateServiceBindingResponse builder
   */
  public static CreateServiceBindingResponse.Builder builder() {
    return new CreateServiceBindingResponse.Builder();
  }

  /**
   * Builds instances of type {@link CreateServiceBindingResponse CreateServiceBindingResponse}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_CreateServiceBindingResponse", generator = "Immutables")
  public static final class Builder {
    private String jobId;
    private ServiceBindingResource serviceBinding;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code CreateServiceBindingResponse} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(CreateServiceBindingResponse instance) {
      return from((_CreateServiceBindingResponse) instance);
    }

    /**
     * Copy abstract value type {@code _CreateServiceBindingResponse} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_CreateServiceBindingResponse instance) {
      Objects.requireNonNull(instance, "instance");
      Optional<String> jobIdOptional = instance.getJobId();
      if (jobIdOptional.isPresent()) {
        jobId(jobIdOptional);
      }
      Optional<ServiceBindingResource> serviceBindingOptional = instance.getServiceBinding();
      if (serviceBindingOptional.isPresent()) {
        serviceBinding(serviceBindingOptional);
      }
      return this;
    }

    /**
     * Initializes the optional value {@link CreateServiceBindingResponse#getJobId() jobId} to jobId.
     * @param jobId The value for jobId
     * @return {@code this} builder for chained invocation
     */
    public final Builder jobId(String jobId) {
      this.jobId = Objects.requireNonNull(jobId, "jobId");
      return this;
    }

    /**
     * Initializes the optional value {@link CreateServiceBindingResponse#getJobId() jobId} to jobId.
     * @param jobId The value for jobId
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder jobId(Optional<String> jobId) {
      this.jobId = jobId.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link CreateServiceBindingResponse#getServiceBinding() serviceBinding} to serviceBinding.
     * @param serviceBinding The value for serviceBinding
     * @return {@code this} builder for chained invocation
     */
    public final Builder serviceBinding(ServiceBindingResource serviceBinding) {
      this.serviceBinding = Objects.requireNonNull(serviceBinding, "serviceBinding");
      return this;
    }

    /**
     * Initializes the optional value {@link CreateServiceBindingResponse#getServiceBinding() serviceBinding} to serviceBinding.
     * @param serviceBinding The value for serviceBinding
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder serviceBinding(Optional<? extends ServiceBindingResource> serviceBinding) {
      this.serviceBinding = serviceBinding.orElse(null);
      return this;
    }

    /**
     * Builds a new {@link CreateServiceBindingResponse CreateServiceBindingResponse}.
     * @return An immutable instance of CreateServiceBindingResponse
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public CreateServiceBindingResponse build() {
      return new CreateServiceBindingResponse(this);
    }
  }
}
