package org.cloudfoundry.client.v3.servicebindings;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.immutables.value.Generated;

/**
 * The response payload for the Get Service Binding Details operation
 */
@Generated(from = "_GetServiceBindingDetailsResponse", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class GetServiceBindingDetailsResponse
    extends org.cloudfoundry.client.v3.servicebindings._GetServiceBindingDetailsResponse {
  private final Map<String, Object> credentials;
  private final @Nullable String syslogDrainUrl;
  private final List<String> volumeMounts;

  private GetServiceBindingDetailsResponse(GetServiceBindingDetailsResponse.Builder builder) {
    this.credentials = createUnmodifiableMap(false, false, builder.credentials);
    this.syslogDrainUrl = builder.syslogDrainUrl;
    this.volumeMounts = createUnmodifiableList(true, builder.volumeMounts);
  }

  /**
   * The credentials
   */
  @JsonProperty("credentials")
  @Override
  public Map<String, Object> getCredentials() {
    return credentials;
  }

  /**
   * The syslog drain url
   */
  @JsonProperty("syslog_drain_url")
  @Override
  public @Nullable String getSyslogDrainUrl() {
    return syslogDrainUrl;
  }

  /**
   * The volume mounts
   */
  @JsonProperty("volume_mounts")
  @Override
  public List<String> getVolumeMounts() {
    return volumeMounts;
  }

  /**
   * This instance is equal to all instances of {@code GetServiceBindingDetailsResponse} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof GetServiceBindingDetailsResponse
        && equalTo(0, (GetServiceBindingDetailsResponse) another);
  }

  private boolean equalTo(int synthetic, GetServiceBindingDetailsResponse another) {
    return credentials.equals(another.credentials)
        && Objects.equals(syslogDrainUrl, another.syslogDrainUrl)
        && volumeMounts.equals(another.volumeMounts);
  }

  /**
   * Computes a hash code from attributes: {@code credentials}, {@code syslogDrainUrl}, {@code volumeMounts}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + credentials.hashCode();
    h += (h << 5) + Objects.hashCode(syslogDrainUrl);
    h += (h << 5) + volumeMounts.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code GetServiceBindingDetailsResponse} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "GetServiceBindingDetailsResponse{"
        + "credentials=" + credentials
        + ", syslogDrainUrl=" + syslogDrainUrl
        + ", volumeMounts=" + volumeMounts
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_GetServiceBindingDetailsResponse", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v3.servicebindings._GetServiceBindingDetailsResponse {
    Map<String, Object> credentials = Collections.emptyMap();
    String syslogDrainUrl;
    List<String> volumeMounts = Collections.emptyList();
    @JsonProperty("credentials")
    public void setCredentials(Map<String, Object> credentials) {
      this.credentials = credentials;
    }
    @JsonProperty("syslog_drain_url")
    public void setSyslogDrainUrl(@Nullable String syslogDrainUrl) {
      this.syslogDrainUrl = syslogDrainUrl;
    }
    @JsonProperty("volume_mounts")
    public void setVolumeMounts(List<String> volumeMounts) {
      this.volumeMounts = volumeMounts;
    }
    @Override
    public Map<String, Object> getCredentials() { throw new UnsupportedOperationException(); }
    @Override
    public String getSyslogDrainUrl() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> getVolumeMounts() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static GetServiceBindingDetailsResponse fromJson(Json json) {
    GetServiceBindingDetailsResponse.Builder builder = GetServiceBindingDetailsResponse.builder();
    if (json.credentials != null) {
      builder.putAllCredentials(json.credentials);
    }
    if (json.syslogDrainUrl != null) {
      builder.syslogDrainUrl(json.syslogDrainUrl);
    }
    if (json.volumeMounts != null) {
      builder.addAllVolumeMounts(json.volumeMounts);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link GetServiceBindingDetailsResponse GetServiceBindingDetailsResponse}.
   * <pre>
   * GetServiceBindingDetailsResponse.builder()
   *    .credential|putAllCredentials(String =&gt; Object) // {@link GetServiceBindingDetailsResponse#getCredentials() credentials} mappings
   *    .syslogDrainUrl(String | null) // nullable {@link GetServiceBindingDetailsResponse#getSyslogDrainUrl() syslogDrainUrl}
   *    .volumeMount|addAllVolumeMounts(String) // {@link GetServiceBindingDetailsResponse#getVolumeMounts() volumeMounts} elements
   *    .build();
   * </pre>
   * @return A new GetServiceBindingDetailsResponse builder
   */
  public static GetServiceBindingDetailsResponse.Builder builder() {
    return new GetServiceBindingDetailsResponse.Builder();
  }

  /**
   * Builds instances of type {@link GetServiceBindingDetailsResponse GetServiceBindingDetailsResponse}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_GetServiceBindingDetailsResponse", generator = "Immutables")
  public static final class Builder {
    private Map<String, Object> credentials = new LinkedHashMap<String, Object>();
    private String syslogDrainUrl;
    private List<String> volumeMounts = new ArrayList<String>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code GetServiceBindingDetailsResponse} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(GetServiceBindingDetailsResponse instance) {
      return from((_GetServiceBindingDetailsResponse) instance);
    }

    /**
     * Copy abstract value type {@code _GetServiceBindingDetailsResponse} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_GetServiceBindingDetailsResponse instance) {
      Objects.requireNonNull(instance, "instance");
      putAllCredentials(instance.getCredentials());
      String syslogDrainUrlValue = instance.getSyslogDrainUrl();
      if (syslogDrainUrlValue != null) {
        syslogDrainUrl(syslogDrainUrlValue);
      }
      addAllVolumeMounts(instance.getVolumeMounts());
      return this;
    }

    /**
     * Put one entry to the {@link GetServiceBindingDetailsResponse#getCredentials() credentials} map.
     * @param key The key in the credentials map
     * @param value The associated value in the credentials map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder credential(String key, Object value) {
      this.credentials.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link GetServiceBindingDetailsResponse#getCredentials() credentials} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder credential(Map.Entry<String, ? extends Object> entry) {
      String k = entry.getKey();
      Object v = entry.getValue();
      this.credentials.put(k, v);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link GetServiceBindingDetailsResponse#getCredentials() credentials} map. Nulls are not permitted
     * @param entries The entries that will be added to the credentials map
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("credentials")
    public final Builder credentials(Map<String, ? extends Object> entries) {
      this.credentials.clear();
      return putAllCredentials(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link GetServiceBindingDetailsResponse#getCredentials() credentials} map. Nulls are not permitted
     * @param entries The entries that will be added to the credentials map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllCredentials(Map<String, ? extends Object> entries) {
      for (Map.Entry<String, ? extends Object> e : entries.entrySet()) {
        String k = e.getKey();
        Object v = e.getValue();
        this.credentials.put(k, v);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link GetServiceBindingDetailsResponse#getSyslogDrainUrl() syslogDrainUrl} attribute.
     * @param syslogDrainUrl The value for syslogDrainUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("syslog_drain_url")
    public final Builder syslogDrainUrl(@Nullable String syslogDrainUrl) {
      this.syslogDrainUrl = syslogDrainUrl;
      return this;
    }

    /**
     * Adds one element to {@link GetServiceBindingDetailsResponse#getVolumeMounts() volumeMounts} list.
     * @param element A volumeMounts element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder volumeMount(String element) {
      this.volumeMounts.add(Objects.requireNonNull(element, "volumeMounts element"));
      return this;
    }

    /**
     * Adds elements to {@link GetServiceBindingDetailsResponse#getVolumeMounts() volumeMounts} list.
     * @param elements An array of volumeMounts elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder volumeMounts(String... elements) {
      for (String element : elements) {
        this.volumeMounts.add(Objects.requireNonNull(element, "volumeMounts element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link GetServiceBindingDetailsResponse#getVolumeMounts() volumeMounts} list.
     * @param elements An iterable of volumeMounts elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("volume_mounts")
    public final Builder volumeMounts(Iterable<String> elements) {
      this.volumeMounts.clear();
      return addAllVolumeMounts(elements);
    }

    /**
     * Adds elements to {@link GetServiceBindingDetailsResponse#getVolumeMounts() volumeMounts} list.
     * @param elements An iterable of volumeMounts elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllVolumeMounts(Iterable<String> elements) {
      for (String element : elements) {
        this.volumeMounts.add(Objects.requireNonNull(element, "volumeMounts element"));
      }
      return this;
    }

    /**
     * Builds a new {@link GetServiceBindingDetailsResponse GetServiceBindingDetailsResponse}.
     * @return An immutable instance of GetServiceBindingDetailsResponse
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public GetServiceBindingDetailsResponse build() {
      return new GetServiceBindingDetailsResponse(this);
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>(size);
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<>(map.size() * 4 / 3 + 1);
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
