package org.cloudfoundry.client.v3.servicebindings;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.*;
import org.cloudfoundry.client.v3.LastOperation;
import org.cloudfoundry.client.v3.Metadata;
import org.cloudfoundry.client.v3.Resource;
import org.immutables.value.Generated;

/**
 * The response payload for Get Service Binding
 */
@Generated(from = "_GetServiceBindingResponse", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class GetServiceBindingResponse
    extends org.cloudfoundry.client.v3.servicebindings._GetServiceBindingResponse {
  private final String createdAt;
  private final String id;
  private final Map<String, Link> links;
  private final @Nullable String updatedAt;
  private final @Nullable String name;
  private final ServiceBindingType type;
  private final @Nullable LastOperation lastOperation;
  private final ServiceBindingRelationships relationships;
  private final @Nullable Metadata metadata;

  private GetServiceBindingResponse(GetServiceBindingResponse.Builder builder) {
    this.createdAt = builder.createdAt;
    this.id = builder.id;
    this.links = createUnmodifiableMap(false, false, builder.links);
    this.updatedAt = builder.updatedAt;
    this.name = builder.name;
    this.type = builder.type;
    this.lastOperation = builder.lastOperation;
    this.relationships = builder.relationships;
    this.metadata = builder.metadata;
  }

  /**
   * When the resource was created
   */
  @JsonProperty("created_at")
  @Override
  public String getCreatedAt() {
    return createdAt;
  }

  /**
   * The resource's id
   */
  @JsonProperty("guid")
  @Override
  public String getId() {
    return id;
  }

  /**
   * Links to related resources and actions for the resource
   */
  @JsonProperty("links")
  @Override
  public Map<String, Link> getLinks() {
    return links;
  }

  /**
   * When the resource was last updated
   */
  @JsonProperty("updated_at")
  @Override
  public @Nullable String getUpdatedAt() {
    return updatedAt;
  }

  /**
   * The name
   */
  @JsonProperty("name")
  @Override
  public @Nullable String getName() {
    return name;
  }

  /**
   * The type
   */
  @JsonProperty("type")
  @Override
  public ServiceBindingType getType() {
    return type;
  }

  /**
   * The last operation
   */
  @JsonProperty("last_operation")
  @Override
  public @Nullable LastOperation getLastOperation() {
    return lastOperation;
  }

  /**
   * The relationships
   */
  @JsonProperty("relationships")
  @Override
  public ServiceBindingRelationships getRelationships() {
    return relationships;
  }

  /**
   * The metadata
   */
  @JsonProperty("metadata")
  @Override
  public @Nullable Metadata getMetadata() {
    return metadata;
  }

  /**
   * This instance is equal to all instances of {@code GetServiceBindingResponse} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof GetServiceBindingResponse
        && equalTo(0, (GetServiceBindingResponse) another);
  }

  private boolean equalTo(int synthetic, GetServiceBindingResponse another) {
    return createdAt.equals(another.createdAt)
        && id.equals(another.id)
        && links.equals(another.links)
        && Objects.equals(updatedAt, another.updatedAt)
        && Objects.equals(name, another.name)
        && type.equals(another.type)
        && Objects.equals(lastOperation, another.lastOperation)
        && relationships.equals(another.relationships)
        && Objects.equals(metadata, another.metadata);
  }

  /**
   * Computes a hash code from attributes: {@code createdAt}, {@code id}, {@code links}, {@code updatedAt}, {@code name}, {@code type}, {@code lastOperation}, {@code relationships}, {@code metadata}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + createdAt.hashCode();
    h += (h << 5) + id.hashCode();
    h += (h << 5) + links.hashCode();
    h += (h << 5) + Objects.hashCode(updatedAt);
    h += (h << 5) + Objects.hashCode(name);
    h += (h << 5) + type.hashCode();
    h += (h << 5) + Objects.hashCode(lastOperation);
    h += (h << 5) + relationships.hashCode();
    h += (h << 5) + Objects.hashCode(metadata);
    return h;
  }

  /**
   * Prints the immutable value {@code GetServiceBindingResponse} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "GetServiceBindingResponse{"
        + "createdAt=" + createdAt
        + ", id=" + id
        + ", links=" + links
        + ", updatedAt=" + updatedAt
        + ", name=" + name
        + ", type=" + type
        + ", lastOperation=" + lastOperation
        + ", relationships=" + relationships
        + ", metadata=" + metadata
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_GetServiceBindingResponse", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v3.servicebindings._GetServiceBindingResponse {
    String createdAt;
    String id;
    Map<String, Link> links = Collections.emptyMap();
    String updatedAt;
    String name;
    ServiceBindingType type;
    LastOperation lastOperation;
    ServiceBindingRelationships relationships;
    Metadata metadata;
    @JsonProperty("created_at")
    public void setCreatedAt(String createdAt) {
      this.createdAt = createdAt;
    }
    @JsonProperty("guid")
    public void setId(String id) {
      this.id = id;
    }
    @JsonProperty("links")
    public void setLinks(Map<String, Link> links) {
      this.links = links;
    }
    @JsonProperty("updated_at")
    public void setUpdatedAt(@Nullable String updatedAt) {
      this.updatedAt = updatedAt;
    }
    @JsonProperty("name")
    public void setName(@Nullable String name) {
      this.name = name;
    }
    @JsonProperty("type")
    public void setType(ServiceBindingType type) {
      this.type = type;
    }
    @JsonProperty("last_operation")
    public void setLastOperation(@Nullable LastOperation lastOperation) {
      this.lastOperation = lastOperation;
    }
    @JsonProperty("relationships")
    public void setRelationships(ServiceBindingRelationships relationships) {
      this.relationships = relationships;
    }
    @JsonProperty("metadata")
    public void setMetadata(@Nullable Metadata metadata) {
      this.metadata = metadata;
    }
    @Override
    public String getCreatedAt() { throw new UnsupportedOperationException(); }
    @Override
    public String getId() { throw new UnsupportedOperationException(); }
    @Override
    public Map<String, Link> getLinks() { throw new UnsupportedOperationException(); }
    @Override
    public String getUpdatedAt() { throw new UnsupportedOperationException(); }
    @Override
    public String getName() { throw new UnsupportedOperationException(); }
    @Override
    public ServiceBindingType getType() { throw new UnsupportedOperationException(); }
    @Override
    public LastOperation getLastOperation() { throw new UnsupportedOperationException(); }
    @Override
    public ServiceBindingRelationships getRelationships() { throw new UnsupportedOperationException(); }
    @Override
    public Metadata getMetadata() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static GetServiceBindingResponse fromJson(Json json) {
    GetServiceBindingResponse.Builder builder = GetServiceBindingResponse.builder();
    if (json.createdAt != null) {
      builder.createdAt(json.createdAt);
    }
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.links != null) {
      builder.putAllLinks(json.links);
    }
    if (json.updatedAt != null) {
      builder.updatedAt(json.updatedAt);
    }
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.type != null) {
      builder.type(json.type);
    }
    if (json.lastOperation != null) {
      builder.lastOperation(json.lastOperation);
    }
    if (json.relationships != null) {
      builder.relationships(json.relationships);
    }
    if (json.metadata != null) {
      builder.metadata(json.metadata);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link GetServiceBindingResponse GetServiceBindingResponse}.
   * <pre>
   * GetServiceBindingResponse.builder()
   *    .createdAt(String) // required {@link GetServiceBindingResponse#getCreatedAt() createdAt}
   *    .id(String) // required {@link GetServiceBindingResponse#getId() id}
   *    .link|putAllLinks(String =&gt; Link) // {@link GetServiceBindingResponse#getLinks() links} mappings
   *    .updatedAt(String | null) // nullable {@link GetServiceBindingResponse#getUpdatedAt() updatedAt}
   *    .name(String | null) // nullable {@link GetServiceBindingResponse#getName() name}
   *    .type(org.cloudfoundry.client.v3.servicebindings.ServiceBindingType) // required {@link GetServiceBindingResponse#getType() type}
   *    .lastOperation(org.cloudfoundry.client.v3.LastOperation | null) // nullable {@link GetServiceBindingResponse#getLastOperation() lastOperation}
   *    .relationships(org.cloudfoundry.client.v3.servicebindings.ServiceBindingRelationships) // required {@link GetServiceBindingResponse#getRelationships() relationships}
   *    .metadata(org.cloudfoundry.client.v3.Metadata | null) // nullable {@link GetServiceBindingResponse#getMetadata() metadata}
   *    .build();
   * </pre>
   * @return A new GetServiceBindingResponse builder
   */
  public static GetServiceBindingResponse.Builder builder() {
    return new GetServiceBindingResponse.Builder();
  }

  /**
   * Builds instances of type {@link GetServiceBindingResponse GetServiceBindingResponse}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_GetServiceBindingResponse", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_CREATED_AT = 0x1L;
    private static final long INIT_BIT_ID = 0x2L;
    private static final long INIT_BIT_TYPE = 0x4L;
    private static final long INIT_BIT_RELATIONSHIPS = 0x8L;
    private long initBits = 0xfL;

    private String createdAt;
    private String id;
    private Map<String, Link> links = new LinkedHashMap<String, Link>();
    private String updatedAt;
    private String name;
    private ServiceBindingType type;
    private LastOperation lastOperation;
    private ServiceBindingRelationships relationships;
    private Metadata metadata;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.client.v3.Resource} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Resource instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.client.v3.servicebindings.ServiceBinding} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ServiceBinding instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code GetServiceBindingResponse} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(GetServiceBindingResponse instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _GetServiceBindingResponse} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(_GetServiceBindingResponse instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    private void from(short _unused, Object object) {
      long bits = 0;
      if (object instanceof Resource) {
        Resource instance = (Resource) object;
        if ((bits & 0x4L) == 0) {
          this.createdAt(instance.getCreatedAt());
          bits |= 0x4L;
        }
        if ((bits & 0x40L) == 0) {
          putAllLinks(instance.getLinks());
          bits |= 0x40L;
        }
        if ((bits & 0x80L) == 0) {
          this.id(instance.getId());
          bits |= 0x80L;
        }
        if ((bits & 0x100L) == 0) {
          String updatedAtValue = instance.getUpdatedAt();
          if (updatedAtValue != null) {
            updatedAt(updatedAtValue);
          }
          bits |= 0x100L;
        }
      }
      if (object instanceof ServiceBinding) {
        ServiceBinding instance = (ServiceBinding) object;
        if ((bits & 0x4L) == 0) {
          this.createdAt(instance.getCreatedAt());
          bits |= 0x4L;
        }
        if ((bits & 0x8L) == 0) {
          this.relationships(instance.getRelationships());
          bits |= 0x8L;
        }
        if ((bits & 0x1L) == 0) {
          Metadata metadataValue = instance.getMetadata();
          if (metadataValue != null) {
            metadata(metadataValue);
          }
          bits |= 0x1L;
        }
        if ((bits & 0x10L) == 0) {
          LastOperation lastOperationValue = instance.getLastOperation();
          if (lastOperationValue != null) {
            lastOperation(lastOperationValue);
          }
          bits |= 0x10L;
        }
        if ((bits & 0x20L) == 0) {
          String nameValue = instance.getName();
          if (nameValue != null) {
            name(nameValue);
          }
          bits |= 0x20L;
        }
        if ((bits & 0x40L) == 0) {
          putAllLinks(instance.getLinks());
          bits |= 0x40L;
        }
        if ((bits & 0x80L) == 0) {
          this.id(instance.getId());
          bits |= 0x80L;
        }
        if ((bits & 0x2L) == 0) {
          this.type(instance.getType());
          bits |= 0x2L;
        }
        if ((bits & 0x100L) == 0) {
          String updatedAtValue = instance.getUpdatedAt();
          if (updatedAtValue != null) {
            updatedAt(updatedAtValue);
          }
          bits |= 0x100L;
        }
      }
      if (object instanceof org.cloudfoundry.client.v3.servicebindings._GetServiceBindingResponse) {
        org.cloudfoundry.client.v3.servicebindings._GetServiceBindingResponse instance = (org.cloudfoundry.client.v3.servicebindings._GetServiceBindingResponse) object;
        if ((bits & 0x20L) == 0) {
          String nameValue = instance.getName();
          if (nameValue != null) {
            name(nameValue);
          }
          bits |= 0x20L;
        }
        if ((bits & 0x8L) == 0) {
          this.relationships(instance.getRelationships());
          bits |= 0x8L;
        }
        if ((bits & 0x1L) == 0) {
          Metadata metadataValue = instance.getMetadata();
          if (metadataValue != null) {
            metadata(metadataValue);
          }
          bits |= 0x1L;
        }
        if ((bits & 0x2L) == 0) {
          this.type(instance.getType());
          bits |= 0x2L;
        }
        if ((bits & 0x10L) == 0) {
          LastOperation lastOperationValue = instance.getLastOperation();
          if (lastOperationValue != null) {
            lastOperation(lastOperationValue);
          }
          bits |= 0x10L;
        }
      }
    }

    /**
     * Initializes the value for the {@link GetServiceBindingResponse#getCreatedAt() createdAt} attribute.
     * @param createdAt The value for createdAt 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("created_at")
    public final Builder createdAt(String createdAt) {
      this.createdAt = Objects.requireNonNull(createdAt, "createdAt");
      initBits &= ~INIT_BIT_CREATED_AT;
      return this;
    }

    /**
     * Initializes the value for the {@link GetServiceBindingResponse#getId() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("guid")
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Put one entry to the {@link GetServiceBindingResponse#getLinks() links} map.
     * @param key The key in the links map
     * @param value The associated value in the links map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder link(String key, Link value) {
      this.links.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link GetServiceBindingResponse#getLinks() links} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder link(Map.Entry<String, ? extends Link> entry) {
      String k = entry.getKey();
      Link v = entry.getValue();
      this.links.put(k, v);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link GetServiceBindingResponse#getLinks() links} map. Nulls are not permitted
     * @param entries The entries that will be added to the links map
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("links")
    public final Builder links(Map<String, ? extends Link> entries) {
      this.links.clear();
      return putAllLinks(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link GetServiceBindingResponse#getLinks() links} map. Nulls are not permitted
     * @param entries The entries that will be added to the links map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllLinks(Map<String, ? extends Link> entries) {
      for (Map.Entry<String, ? extends Link> e : entries.entrySet()) {
        String k = e.getKey();
        Link v = e.getValue();
        this.links.put(k, v);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link GetServiceBindingResponse#getUpdatedAt() updatedAt} attribute.
     * @param updatedAt The value for updatedAt (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("updated_at")
    public final Builder updatedAt(@Nullable String updatedAt) {
      this.updatedAt = updatedAt;
      return this;
    }

    /**
     * Initializes the value for the {@link GetServiceBindingResponse#getName() name} attribute.
     * @param name The value for name (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("name")
    public final Builder name(@Nullable String name) {
      this.name = name;
      return this;
    }

    /**
     * Initializes the value for the {@link GetServiceBindingResponse#getType() type} attribute.
     * @param type The value for type 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("type")
    public final Builder type(ServiceBindingType type) {
      this.type = Objects.requireNonNull(type, "type");
      initBits &= ~INIT_BIT_TYPE;
      return this;
    }

    /**
     * Initializes the value for the {@link GetServiceBindingResponse#getLastOperation() lastOperation} attribute.
     * @param lastOperation The value for lastOperation (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("last_operation")
    public final Builder lastOperation(@Nullable LastOperation lastOperation) {
      this.lastOperation = lastOperation;
      return this;
    }

    /**
     * Initializes the value for the {@link GetServiceBindingResponse#getRelationships() relationships} attribute.
     * @param relationships The value for relationships 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("relationships")
    public final Builder relationships(ServiceBindingRelationships relationships) {
      this.relationships = Objects.requireNonNull(relationships, "relationships");
      initBits &= ~INIT_BIT_RELATIONSHIPS;
      return this;
    }

    /**
     * Initializes the value for the {@link GetServiceBindingResponse#getMetadata() metadata} attribute.
     * @param metadata The value for metadata (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("metadata")
    public final Builder metadata(@Nullable Metadata metadata) {
      this.metadata = metadata;
      return this;
    }

    /**
     * Builds a new {@link GetServiceBindingResponse GetServiceBindingResponse}.
     * @return An immutable instance of GetServiceBindingResponse
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public GetServiceBindingResponse build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new GetServiceBindingResponse(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_CREATED_AT) != 0) attributes.add("createdAt");
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      if ((initBits & INIT_BIT_TYPE) != 0) attributes.add("type");
      if ((initBits & INIT_BIT_RELATIONSHIPS) != 0) attributes.add("relationships");
      return "Cannot build GetServiceBindingResponse, some of required attributes are not set " + attributes;
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<>(map.size() * 4 / 3 + 1);
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
