package org.cloudfoundry.client.v3.servicebindings;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.PaginatedRequest;
import org.immutables.value.Generated;

/**
 * The request payload for the List Service Bindings operation.
 */
@Generated(from = "_ListServiceBindingsRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ListServiceBindingsRequest
    extends org.cloudfoundry.client.v3.servicebindings._ListServiceBindingsRequest {
  private final @Nullable String orderBy;
  private final @Nullable Integer page;
  private final @Nullable Integer perPage;
  private final List<String> names;
  private final List<String> serviceInstanceIds;
  private final List<String> serviceInstanceNames;
  private final List<String> applicationIds;
  private final List<String> appNames;
  private final List<String> servicePlanIds;
  private final List<String> servicePlanNames;
  private final List<String> serviceOfferingIds;
  private final List<String> serviceOfferingNames;
  private final @Nullable ServiceBindingType type;
  private final List<String> ids;

  private ListServiceBindingsRequest(ListServiceBindingsRequest.Builder builder) {
    this.orderBy = builder.orderBy;
    this.page = builder.page;
    this.perPage = builder.perPage;
    this.names = createUnmodifiableList(true, builder.names);
    this.serviceInstanceIds = createUnmodifiableList(true, builder.serviceInstanceIds);
    this.serviceInstanceNames = createUnmodifiableList(true, builder.serviceInstanceNames);
    this.applicationIds = createUnmodifiableList(true, builder.applicationIds);
    this.appNames = createUnmodifiableList(true, builder.appNames);
    this.servicePlanIds = createUnmodifiableList(true, builder.servicePlanIds);
    this.servicePlanNames = createUnmodifiableList(true, builder.servicePlanNames);
    this.serviceOfferingIds = createUnmodifiableList(true, builder.serviceOfferingIds);
    this.serviceOfferingNames = createUnmodifiableList(true, builder.serviceOfferingNames);
    this.type = builder.type;
    this.ids = createUnmodifiableList(true, builder.ids);
  }

  /**
   * The order by
   */
  @Override
  public @Nullable String getOrderBy() {
    return orderBy;
  }

  /**
   * The page
   */
  @Override
  public @Nullable Integer getPage() {
    return page;
  }

  /**
   * The results per page
   */
  @Override
  public @Nullable Integer getPerPage() {
    return perPage;
  }

  /**
   * The names
   */
  @Override
  public List<String> getNames() {
    return names;
  }

  /**
   * The service instance ids
   */
  @Override
  public List<String> getServiceInstanceIds() {
    return serviceInstanceIds;
  }

  /**
   * The service instance names
   */
  @Override
  public List<String> getServiceInstanceNames() {
    return serviceInstanceNames;
  }

  /**
   * The application ids
   */
  @Override
  public List<String> getApplicationIds() {
    return applicationIds;
  }

  /**
   * The application names
   */
  @Override
  public List<String> getAppNames() {
    return appNames;
  }

  /**
   * The service plan ids
   */
  @Override
  public List<String> getServicePlanIds() {
    return servicePlanIds;
  }

  /**
   * The service plan names
   */
  @Override
  public List<String> getServicePlanNames() {
    return servicePlanNames;
  }

  /**
   * The service offering ids
   */
  @Override
  public List<String> getServiceOfferingIds() {
    return serviceOfferingIds;
  }

  /**
   * The service offering names
   */
  @Override
  public List<String> getServiceOfferingNames() {
    return serviceOfferingNames;
  }

  /**
   * The type
   */
  @Override
  public @Nullable ServiceBindingType getType() {
    return type;
  }

  /**
   * The ids
   */
  @Override
  public List<String> getIds() {
    return ids;
  }

  /**
   * This instance is equal to all instances of {@code ListServiceBindingsRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ListServiceBindingsRequest
        && equalTo(0, (ListServiceBindingsRequest) another);
  }

  private boolean equalTo(int synthetic, ListServiceBindingsRequest another) {
    return Objects.equals(orderBy, another.orderBy)
        && Objects.equals(page, another.page)
        && Objects.equals(perPage, another.perPage)
        && names.equals(another.names)
        && serviceInstanceIds.equals(another.serviceInstanceIds)
        && serviceInstanceNames.equals(another.serviceInstanceNames)
        && applicationIds.equals(another.applicationIds)
        && appNames.equals(another.appNames)
        && servicePlanIds.equals(another.servicePlanIds)
        && servicePlanNames.equals(another.servicePlanNames)
        && serviceOfferingIds.equals(another.serviceOfferingIds)
        && serviceOfferingNames.equals(another.serviceOfferingNames)
        && Objects.equals(type, another.type)
        && ids.equals(another.ids);
  }

  /**
   * Computes a hash code from attributes: {@code orderBy}, {@code page}, {@code perPage}, {@code names}, {@code serviceInstanceIds}, {@code serviceInstanceNames}, {@code applicationIds}, {@code appNames}, {@code servicePlanIds}, {@code servicePlanNames}, {@code serviceOfferingIds}, {@code serviceOfferingNames}, {@code type}, {@code ids}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(orderBy);
    h += (h << 5) + Objects.hashCode(page);
    h += (h << 5) + Objects.hashCode(perPage);
    h += (h << 5) + names.hashCode();
    h += (h << 5) + serviceInstanceIds.hashCode();
    h += (h << 5) + serviceInstanceNames.hashCode();
    h += (h << 5) + applicationIds.hashCode();
    h += (h << 5) + appNames.hashCode();
    h += (h << 5) + servicePlanIds.hashCode();
    h += (h << 5) + servicePlanNames.hashCode();
    h += (h << 5) + serviceOfferingIds.hashCode();
    h += (h << 5) + serviceOfferingNames.hashCode();
    h += (h << 5) + Objects.hashCode(type);
    h += (h << 5) + ids.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ListServiceBindingsRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ListServiceBindingsRequest{"
        + "orderBy=" + orderBy
        + ", page=" + page
        + ", perPage=" + perPage
        + ", names=" + names
        + ", serviceInstanceIds=" + serviceInstanceIds
        + ", serviceInstanceNames=" + serviceInstanceNames
        + ", applicationIds=" + applicationIds
        + ", appNames=" + appNames
        + ", servicePlanIds=" + servicePlanIds
        + ", servicePlanNames=" + servicePlanNames
        + ", serviceOfferingIds=" + serviceOfferingIds
        + ", serviceOfferingNames=" + serviceOfferingNames
        + ", type=" + type
        + ", ids=" + ids
        + "}";
  }

  private static ListServiceBindingsRequest validate(ListServiceBindingsRequest instance) {
    instance.check();
    return instance;
  }

  /**
   * Creates a builder for {@link ListServiceBindingsRequest ListServiceBindingsRequest}.
   * <pre>
   * ListServiceBindingsRequest.builder()
   *    .orderBy(String | null) // nullable {@link ListServiceBindingsRequest#getOrderBy() orderBy}
   *    .page(Integer | null) // nullable {@link ListServiceBindingsRequest#getPage() page}
   *    .perPage(Integer | null) // nullable {@link ListServiceBindingsRequest#getPerPage() perPage}
   *    .name|addAllNames(String) // {@link ListServiceBindingsRequest#getNames() names} elements
   *    .serviceInstanceId|addAllServiceInstanceIds(String) // {@link ListServiceBindingsRequest#getServiceInstanceIds() serviceInstanceIds} elements
   *    .serviceInstanceName|addAllServiceInstanceNames(String) // {@link ListServiceBindingsRequest#getServiceInstanceNames() serviceInstanceNames} elements
   *    .applicationId|addAllApplicationIds(String) // {@link ListServiceBindingsRequest#getApplicationIds() applicationIds} elements
   *    .appName|addAllAppNames(String) // {@link ListServiceBindingsRequest#getAppNames() appNames} elements
   *    .servicePlanId|addAllServicePlanIds(String) // {@link ListServiceBindingsRequest#getServicePlanIds() servicePlanIds} elements
   *    .servicePlanName|addAllServicePlanNames(String) // {@link ListServiceBindingsRequest#getServicePlanNames() servicePlanNames} elements
   *    .serviceOfferingId|addAllServiceOfferingIds(String) // {@link ListServiceBindingsRequest#getServiceOfferingIds() serviceOfferingIds} elements
   *    .serviceOfferingName|addAllServiceOfferingNames(String) // {@link ListServiceBindingsRequest#getServiceOfferingNames() serviceOfferingNames} elements
   *    .type(org.cloudfoundry.client.v3.servicebindings.ServiceBindingType | null) // nullable {@link ListServiceBindingsRequest#getType() type}
   *    .id|addAllIds(String) // {@link ListServiceBindingsRequest#getIds() ids} elements
   *    .build();
   * </pre>
   * @return A new ListServiceBindingsRequest builder
   */
  public static ListServiceBindingsRequest.Builder builder() {
    return new ListServiceBindingsRequest.Builder();
  }

  /**
   * Builds instances of type {@link ListServiceBindingsRequest ListServiceBindingsRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_ListServiceBindingsRequest", generator = "Immutables")
  public static final class Builder {
    private String orderBy;
    private Integer page;
    private Integer perPage;
    private List<String> names = new ArrayList<String>();
    private List<String> serviceInstanceIds = new ArrayList<String>();
    private List<String> serviceInstanceNames = new ArrayList<String>();
    private List<String> applicationIds = new ArrayList<String>();
    private List<String> appNames = new ArrayList<String>();
    private List<String> servicePlanIds = new ArrayList<String>();
    private List<String> servicePlanNames = new ArrayList<String>();
    private List<String> serviceOfferingIds = new ArrayList<String>();
    private List<String> serviceOfferingNames = new ArrayList<String>();
    private ServiceBindingType type;
    private List<String> ids = new ArrayList<String>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.client.v3.PaginatedRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(PaginatedRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code ListServiceBindingsRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ListServiceBindingsRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _ListServiceBindingsRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(_ListServiceBindingsRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    private void from(short _unused, Object object) {
      if (object instanceof PaginatedRequest) {
        PaginatedRequest instance = (PaginatedRequest) object;
        String orderByValue = instance.getOrderBy();
        if (orderByValue != null) {
          orderBy(orderByValue);
        }
        Integer perPageValue = instance.getPerPage();
        if (perPageValue != null) {
          perPage(perPageValue);
        }
        Integer pageValue = instance.getPage();
        if (pageValue != null) {
          page(pageValue);
        }
      }
      if (object instanceof org.cloudfoundry.client.v3.servicebindings._ListServiceBindingsRequest) {
        org.cloudfoundry.client.v3.servicebindings._ListServiceBindingsRequest instance = (org.cloudfoundry.client.v3.servicebindings._ListServiceBindingsRequest) object;
        addAllServiceInstanceNames(instance.getServiceInstanceNames());
        addAllNames(instance.getNames());
        addAllServiceInstanceIds(instance.getServiceInstanceIds());
        addAllAppNames(instance.getAppNames());
        addAllServicePlanIds(instance.getServicePlanIds());
        addAllServiceOfferingNames(instance.getServiceOfferingNames());
        addAllIds(instance.getIds());
        ServiceBindingType typeValue = instance.getType();
        if (typeValue != null) {
          type(typeValue);
        }
        addAllServiceOfferingIds(instance.getServiceOfferingIds());
        addAllServicePlanNames(instance.getServicePlanNames());
        addAllApplicationIds(instance.getApplicationIds());
      }
    }

    /**
     * Initializes the value for the {@link ListServiceBindingsRequest#getOrderBy() orderBy} attribute.
     * @param orderBy The value for orderBy (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder orderBy(@Nullable String orderBy) {
      this.orderBy = orderBy;
      return this;
    }

    /**
     * Initializes the value for the {@link ListServiceBindingsRequest#getPage() page} attribute.
     * @param page The value for page (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder page(@Nullable Integer page) {
      this.page = page;
      return this;
    }

    /**
     * Initializes the value for the {@link ListServiceBindingsRequest#getPerPage() perPage} attribute.
     * @param perPage The value for perPage (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder perPage(@Nullable Integer perPage) {
      this.perPage = perPage;
      return this;
    }

    /**
     * Adds one element to {@link ListServiceBindingsRequest#getNames() names} list.
     * @param element A names element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(String element) {
      this.names.add(Objects.requireNonNull(element, "names element"));
      return this;
    }

    /**
     * Adds elements to {@link ListServiceBindingsRequest#getNames() names} list.
     * @param elements An array of names elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder names(String... elements) {
      for (String element : elements) {
        this.names.add(Objects.requireNonNull(element, "names element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListServiceBindingsRequest#getNames() names} list.
     * @param elements An iterable of names elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder names(Iterable<String> elements) {
      this.names.clear();
      return addAllNames(elements);
    }

    /**
     * Adds elements to {@link ListServiceBindingsRequest#getNames() names} list.
     * @param elements An iterable of names elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllNames(Iterable<String> elements) {
      for (String element : elements) {
        this.names.add(Objects.requireNonNull(element, "names element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link ListServiceBindingsRequest#getServiceInstanceIds() serviceInstanceIds} list.
     * @param element A serviceInstanceIds element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder serviceInstanceId(String element) {
      this.serviceInstanceIds.add(Objects.requireNonNull(element, "serviceInstanceIds element"));
      return this;
    }

    /**
     * Adds elements to {@link ListServiceBindingsRequest#getServiceInstanceIds() serviceInstanceIds} list.
     * @param elements An array of serviceInstanceIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder serviceInstanceIds(String... elements) {
      for (String element : elements) {
        this.serviceInstanceIds.add(Objects.requireNonNull(element, "serviceInstanceIds element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListServiceBindingsRequest#getServiceInstanceIds() serviceInstanceIds} list.
     * @param elements An iterable of serviceInstanceIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder serviceInstanceIds(Iterable<String> elements) {
      this.serviceInstanceIds.clear();
      return addAllServiceInstanceIds(elements);
    }

    /**
     * Adds elements to {@link ListServiceBindingsRequest#getServiceInstanceIds() serviceInstanceIds} list.
     * @param elements An iterable of serviceInstanceIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllServiceInstanceIds(Iterable<String> elements) {
      for (String element : elements) {
        this.serviceInstanceIds.add(Objects.requireNonNull(element, "serviceInstanceIds element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link ListServiceBindingsRequest#getServiceInstanceNames() serviceInstanceNames} list.
     * @param element A serviceInstanceNames element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder serviceInstanceName(String element) {
      this.serviceInstanceNames.add(Objects.requireNonNull(element, "serviceInstanceNames element"));
      return this;
    }

    /**
     * Adds elements to {@link ListServiceBindingsRequest#getServiceInstanceNames() serviceInstanceNames} list.
     * @param elements An array of serviceInstanceNames elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder serviceInstanceNames(String... elements) {
      for (String element : elements) {
        this.serviceInstanceNames.add(Objects.requireNonNull(element, "serviceInstanceNames element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListServiceBindingsRequest#getServiceInstanceNames() serviceInstanceNames} list.
     * @param elements An iterable of serviceInstanceNames elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder serviceInstanceNames(Iterable<String> elements) {
      this.serviceInstanceNames.clear();
      return addAllServiceInstanceNames(elements);
    }

    /**
     * Adds elements to {@link ListServiceBindingsRequest#getServiceInstanceNames() serviceInstanceNames} list.
     * @param elements An iterable of serviceInstanceNames elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllServiceInstanceNames(Iterable<String> elements) {
      for (String element : elements) {
        this.serviceInstanceNames.add(Objects.requireNonNull(element, "serviceInstanceNames element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link ListServiceBindingsRequest#getApplicationIds() applicationIds} list.
     * @param element A applicationIds element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder applicationId(String element) {
      this.applicationIds.add(Objects.requireNonNull(element, "applicationIds element"));
      return this;
    }

    /**
     * Adds elements to {@link ListServiceBindingsRequest#getApplicationIds() applicationIds} list.
     * @param elements An array of applicationIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder applicationIds(String... elements) {
      for (String element : elements) {
        this.applicationIds.add(Objects.requireNonNull(element, "applicationIds element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListServiceBindingsRequest#getApplicationIds() applicationIds} list.
     * @param elements An iterable of applicationIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder applicationIds(Iterable<String> elements) {
      this.applicationIds.clear();
      return addAllApplicationIds(elements);
    }

    /**
     * Adds elements to {@link ListServiceBindingsRequest#getApplicationIds() applicationIds} list.
     * @param elements An iterable of applicationIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllApplicationIds(Iterable<String> elements) {
      for (String element : elements) {
        this.applicationIds.add(Objects.requireNonNull(element, "applicationIds element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link ListServiceBindingsRequest#getAppNames() appNames} list.
     * @param element A appNames element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder appName(String element) {
      this.appNames.add(Objects.requireNonNull(element, "appNames element"));
      return this;
    }

    /**
     * Adds elements to {@link ListServiceBindingsRequest#getAppNames() appNames} list.
     * @param elements An array of appNames elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder appNames(String... elements) {
      for (String element : elements) {
        this.appNames.add(Objects.requireNonNull(element, "appNames element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListServiceBindingsRequest#getAppNames() appNames} list.
     * @param elements An iterable of appNames elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder appNames(Iterable<String> elements) {
      this.appNames.clear();
      return addAllAppNames(elements);
    }

    /**
     * Adds elements to {@link ListServiceBindingsRequest#getAppNames() appNames} list.
     * @param elements An iterable of appNames elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllAppNames(Iterable<String> elements) {
      for (String element : elements) {
        this.appNames.add(Objects.requireNonNull(element, "appNames element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link ListServiceBindingsRequest#getServicePlanIds() servicePlanIds} list.
     * @param element A servicePlanIds element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder servicePlanId(String element) {
      this.servicePlanIds.add(Objects.requireNonNull(element, "servicePlanIds element"));
      return this;
    }

    /**
     * Adds elements to {@link ListServiceBindingsRequest#getServicePlanIds() servicePlanIds} list.
     * @param elements An array of servicePlanIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder servicePlanIds(String... elements) {
      for (String element : elements) {
        this.servicePlanIds.add(Objects.requireNonNull(element, "servicePlanIds element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListServiceBindingsRequest#getServicePlanIds() servicePlanIds} list.
     * @param elements An iterable of servicePlanIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder servicePlanIds(Iterable<String> elements) {
      this.servicePlanIds.clear();
      return addAllServicePlanIds(elements);
    }

    /**
     * Adds elements to {@link ListServiceBindingsRequest#getServicePlanIds() servicePlanIds} list.
     * @param elements An iterable of servicePlanIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllServicePlanIds(Iterable<String> elements) {
      for (String element : elements) {
        this.servicePlanIds.add(Objects.requireNonNull(element, "servicePlanIds element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link ListServiceBindingsRequest#getServicePlanNames() servicePlanNames} list.
     * @param element A servicePlanNames element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder servicePlanName(String element) {
      this.servicePlanNames.add(Objects.requireNonNull(element, "servicePlanNames element"));
      return this;
    }

    /**
     * Adds elements to {@link ListServiceBindingsRequest#getServicePlanNames() servicePlanNames} list.
     * @param elements An array of servicePlanNames elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder servicePlanNames(String... elements) {
      for (String element : elements) {
        this.servicePlanNames.add(Objects.requireNonNull(element, "servicePlanNames element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListServiceBindingsRequest#getServicePlanNames() servicePlanNames} list.
     * @param elements An iterable of servicePlanNames elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder servicePlanNames(Iterable<String> elements) {
      this.servicePlanNames.clear();
      return addAllServicePlanNames(elements);
    }

    /**
     * Adds elements to {@link ListServiceBindingsRequest#getServicePlanNames() servicePlanNames} list.
     * @param elements An iterable of servicePlanNames elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllServicePlanNames(Iterable<String> elements) {
      for (String element : elements) {
        this.servicePlanNames.add(Objects.requireNonNull(element, "servicePlanNames element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link ListServiceBindingsRequest#getServiceOfferingIds() serviceOfferingIds} list.
     * @param element A serviceOfferingIds element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder serviceOfferingId(String element) {
      this.serviceOfferingIds.add(Objects.requireNonNull(element, "serviceOfferingIds element"));
      return this;
    }

    /**
     * Adds elements to {@link ListServiceBindingsRequest#getServiceOfferingIds() serviceOfferingIds} list.
     * @param elements An array of serviceOfferingIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder serviceOfferingIds(String... elements) {
      for (String element : elements) {
        this.serviceOfferingIds.add(Objects.requireNonNull(element, "serviceOfferingIds element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListServiceBindingsRequest#getServiceOfferingIds() serviceOfferingIds} list.
     * @param elements An iterable of serviceOfferingIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder serviceOfferingIds(Iterable<String> elements) {
      this.serviceOfferingIds.clear();
      return addAllServiceOfferingIds(elements);
    }

    /**
     * Adds elements to {@link ListServiceBindingsRequest#getServiceOfferingIds() serviceOfferingIds} list.
     * @param elements An iterable of serviceOfferingIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllServiceOfferingIds(Iterable<String> elements) {
      for (String element : elements) {
        this.serviceOfferingIds.add(Objects.requireNonNull(element, "serviceOfferingIds element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link ListServiceBindingsRequest#getServiceOfferingNames() serviceOfferingNames} list.
     * @param element A serviceOfferingNames element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder serviceOfferingName(String element) {
      this.serviceOfferingNames.add(Objects.requireNonNull(element, "serviceOfferingNames element"));
      return this;
    }

    /**
     * Adds elements to {@link ListServiceBindingsRequest#getServiceOfferingNames() serviceOfferingNames} list.
     * @param elements An array of serviceOfferingNames elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder serviceOfferingNames(String... elements) {
      for (String element : elements) {
        this.serviceOfferingNames.add(Objects.requireNonNull(element, "serviceOfferingNames element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListServiceBindingsRequest#getServiceOfferingNames() serviceOfferingNames} list.
     * @param elements An iterable of serviceOfferingNames elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder serviceOfferingNames(Iterable<String> elements) {
      this.serviceOfferingNames.clear();
      return addAllServiceOfferingNames(elements);
    }

    /**
     * Adds elements to {@link ListServiceBindingsRequest#getServiceOfferingNames() serviceOfferingNames} list.
     * @param elements An iterable of serviceOfferingNames elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllServiceOfferingNames(Iterable<String> elements) {
      for (String element : elements) {
        this.serviceOfferingNames.add(Objects.requireNonNull(element, "serviceOfferingNames element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link ListServiceBindingsRequest#getType() type} attribute.
     * @param type The value for type (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder type(@Nullable ServiceBindingType type) {
      this.type = type;
      return this;
    }

    /**
     * Adds one element to {@link ListServiceBindingsRequest#getIds() ids} list.
     * @param element A ids element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder id(String element) {
      this.ids.add(Objects.requireNonNull(element, "ids element"));
      return this;
    }

    /**
     * Adds elements to {@link ListServiceBindingsRequest#getIds() ids} list.
     * @param elements An array of ids elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder ids(String... elements) {
      for (String element : elements) {
        this.ids.add(Objects.requireNonNull(element, "ids element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListServiceBindingsRequest#getIds() ids} list.
     * @param elements An iterable of ids elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder ids(Iterable<String> elements) {
      this.ids.clear();
      return addAllIds(elements);
    }

    /**
     * Adds elements to {@link ListServiceBindingsRequest#getIds() ids} list.
     * @param elements An iterable of ids elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllIds(Iterable<String> elements) {
      for (String element : elements) {
        this.ids.add(Objects.requireNonNull(element, "ids element"));
      }
      return this;
    }

    /**
     * Builds a new {@link ListServiceBindingsRequest ListServiceBindingsRequest}.
     * @return An immutable instance of ListServiceBindingsRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ListServiceBindingsRequest build() {
      return ListServiceBindingsRequest.validate(new ListServiceBindingsRequest(this));
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>(size);
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
