package org.cloudfoundry.client.v3.servicebindings;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.ToOneRelationship;
import org.immutables.value.Generated;

/**
 * The relationships for the Create Service Binding request
 */
@Generated(from = "_ServiceBindingRelationships", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ServiceBindingRelationships
    extends org.cloudfoundry.client.v3.servicebindings._ServiceBindingRelationships {
  private final @Nullable ToOneRelationship application;
  private final ToOneRelationship serviceInstance;

  private ServiceBindingRelationships(ServiceBindingRelationships.Builder builder) {
    this.application = builder.application;
    this.serviceInstance = builder.serviceInstance;
  }

  /**
   * The application relationship
   */
  @JsonProperty("app")
  @Override
  public @Nullable ToOneRelationship getApplication() {
    return application;
  }

  /**
   * The service instance relationship
   */
  @JsonProperty("service_instance")
  @Override
  public ToOneRelationship getServiceInstance() {
    return serviceInstance;
  }

  /**
   * This instance is equal to all instances of {@code ServiceBindingRelationships} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ServiceBindingRelationships
        && equalTo(0, (ServiceBindingRelationships) another);
  }

  private boolean equalTo(int synthetic, ServiceBindingRelationships another) {
    return Objects.equals(application, another.application)
        && serviceInstance.equals(another.serviceInstance);
  }

  /**
   * Computes a hash code from attributes: {@code application}, {@code serviceInstance}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(application);
    h += (h << 5) + serviceInstance.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ServiceBindingRelationships} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ServiceBindingRelationships{"
        + "application=" + application
        + ", serviceInstance=" + serviceInstance
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_ServiceBindingRelationships", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v3.servicebindings._ServiceBindingRelationships {
    ToOneRelationship application;
    ToOneRelationship serviceInstance;
    @JsonProperty("app")
    public void setApplication(@Nullable ToOneRelationship application) {
      this.application = application;
    }
    @JsonProperty("service_instance")
    public void setServiceInstance(ToOneRelationship serviceInstance) {
      this.serviceInstance = serviceInstance;
    }
    @Override
    public ToOneRelationship getApplication() { throw new UnsupportedOperationException(); }
    @Override
    public ToOneRelationship getServiceInstance() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ServiceBindingRelationships fromJson(Json json) {
    ServiceBindingRelationships.Builder builder = ServiceBindingRelationships.builder();
    if (json.application != null) {
      builder.application(json.application);
    }
    if (json.serviceInstance != null) {
      builder.serviceInstance(json.serviceInstance);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link ServiceBindingRelationships ServiceBindingRelationships}.
   * <pre>
   * ServiceBindingRelationships.builder()
   *    .application(org.cloudfoundry.client.v3.ToOneRelationship | null) // nullable {@link ServiceBindingRelationships#getApplication() application}
   *    .serviceInstance(org.cloudfoundry.client.v3.ToOneRelationship) // required {@link ServiceBindingRelationships#getServiceInstance() serviceInstance}
   *    .build();
   * </pre>
   * @return A new ServiceBindingRelationships builder
   */
  public static ServiceBindingRelationships.Builder builder() {
    return new ServiceBindingRelationships.Builder();
  }

  /**
   * Builds instances of type {@link ServiceBindingRelationships ServiceBindingRelationships}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_ServiceBindingRelationships", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_SERVICE_INSTANCE = 0x1L;
    private long initBits = 0x1L;

    private ToOneRelationship application;
    private ToOneRelationship serviceInstance;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ServiceBindingRelationships} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ServiceBindingRelationships instance) {
      return from((_ServiceBindingRelationships) instance);
    }

    /**
     * Copy abstract value type {@code _ServiceBindingRelationships} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_ServiceBindingRelationships instance) {
      Objects.requireNonNull(instance, "instance");
      ToOneRelationship applicationValue = instance.getApplication();
      if (applicationValue != null) {
        application(applicationValue);
      }
      this.serviceInstance(instance.getServiceInstance());
      return this;
    }

    /**
     * Initializes the value for the {@link ServiceBindingRelationships#getApplication() application} attribute.
     * @param application The value for application (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("app")
    public final Builder application(@Nullable ToOneRelationship application) {
      this.application = application;
      return this;
    }

    /**
     * Initializes the value for the {@link ServiceBindingRelationships#getServiceInstance() serviceInstance} attribute.
     * @param serviceInstance The value for serviceInstance 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("service_instance")
    public final Builder serviceInstance(ToOneRelationship serviceInstance) {
      this.serviceInstance = Objects.requireNonNull(serviceInstance, "serviceInstance");
      initBits &= ~INIT_BIT_SERVICE_INSTANCE;
      return this;
    }

    /**
     * Builds a new {@link ServiceBindingRelationships ServiceBindingRelationships}.
     * @return An immutable instance of ServiceBindingRelationships
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ServiceBindingRelationships build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ServiceBindingRelationships(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_SERVICE_INSTANCE) != 0) attributes.add("serviceInstance");
      return "Cannot build ServiceBindingRelationships, some of required attributes are not set " + attributes;
    }
  }
}
