package org.cloudfoundry.client.v3.servicebrokers;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link _BasicAuthentication}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code BasicAuthentication.builder()}.
 */
@Generated(from = "_BasicAuthentication", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class BasicAuthentication extends org.cloudfoundry.client.v3.servicebrokers._BasicAuthentication {
  private final String username;
  private final String password;
  private transient final Map<String, Object> credentials;
  private transient final String type;

  private BasicAuthentication(BasicAuthentication.Builder builder) {
    this.username = builder.username;
    this.password = builder.password;
    this.credentials = initShim.getCredentials();
    this.type = initShim.getType();
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "_BasicAuthentication", generator = "Immutables")
  private final class InitShim {
    private byte credentialsBuildStage = STAGE_UNINITIALIZED;
    private Map<String, Object> credentials;

    Map<String, Object> getCredentials() {
      if (credentialsBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (credentialsBuildStage == STAGE_UNINITIALIZED) {
        credentialsBuildStage = STAGE_INITIALIZING;
        this.credentials = Objects.requireNonNull(BasicAuthentication.super.getCredentials(), "credentials");
        credentialsBuildStage = STAGE_INITIALIZED;
      }
      return this.credentials;
    }

    private byte typeBuildStage = STAGE_UNINITIALIZED;
    private String type;

    String getType() {
      if (typeBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (typeBuildStage == STAGE_UNINITIALIZED) {
        typeBuildStage = STAGE_INITIALIZING;
        this.type = Objects.requireNonNull(BasicAuthentication.super.getType(), "type");
        typeBuildStage = STAGE_INITIALIZED;
      }
      return this.type;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      if (credentialsBuildStage == STAGE_INITIALIZING) attributes.add("credentials");
      if (typeBuildStage == STAGE_INITIALIZING) attributes.add("type");
      return "Cannot build BasicAuthentication, attribute initializers form cycle " + attributes;
    }
  }

  /**
   * @return The value of the {@code username} attribute
   */
  @Override
  public String getUsername() {
    return username;
  }

  /**
   * @return The value of the {@code password} attribute
   */
  @Override
  public String getPassword() {
    return password;
  }

  /**
   * @return The computed-at-construction value of the {@code credentials} attribute
   */
  @Override
  public Map<String, Object> getCredentials() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getCredentials()
        : this.credentials;
  }

  /**
   * @return The computed-at-construction value of the {@code type} attribute
   */
  @Override
  public String getType() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getType()
        : this.type;
  }

  /**
   * This instance is equal to all instances of {@code BasicAuthentication} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof BasicAuthentication
        && equalTo(0, (BasicAuthentication) another);
  }

  private boolean equalTo(int synthetic, BasicAuthentication another) {
    return username.equals(another.username)
        && password.equals(another.password)
        && credentials.equals(another.credentials)
        && type.equals(another.type);
  }

  /**
   * Computes a hash code from attributes: {@code username}, {@code password}, {@code credentials}, {@code type}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + username.hashCode();
    h += (h << 5) + password.hashCode();
    h += (h << 5) + credentials.hashCode();
    h += (h << 5) + type.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code BasicAuthentication} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "BasicAuthentication{"
        + "username=" + username
        + ", password=" + password
        + ", credentials=" + credentials
        + ", type=" + type
        + "}";
  }

  /**
   * Creates a builder for {@link BasicAuthentication BasicAuthentication}.
   * <pre>
   * BasicAuthentication.builder()
   *    .username(String) // required {@link BasicAuthentication#getUsername() username}
   *    .password(String) // required {@link BasicAuthentication#getPassword() password}
   *    .build();
   * </pre>
   * @return A new BasicAuthentication builder
   */
  public static BasicAuthentication.Builder builder() {
    return new BasicAuthentication.Builder();
  }

  /**
   * Builds instances of type {@link BasicAuthentication BasicAuthentication}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_BasicAuthentication", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_USERNAME = 0x1L;
    private static final long INIT_BIT_PASSWORD = 0x2L;
    private long initBits = 0x3L;

    private String username;
    private String password;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code BasicAuthentication} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(BasicAuthentication instance) {
      return from((_BasicAuthentication) instance);
    }

    /**
     * Copy abstract value type {@code _BasicAuthentication} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_BasicAuthentication instance) {
      Objects.requireNonNull(instance, "instance");
      this.username(instance.getUsername());
      this.password(instance.getPassword());
      return this;
    }

    /**
     * Initializes the value for the {@link BasicAuthentication#getUsername() username} attribute.
     * @param username The value for username 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder username(String username) {
      this.username = Objects.requireNonNull(username, "username");
      initBits &= ~INIT_BIT_USERNAME;
      return this;
    }

    /**
     * Initializes the value for the {@link BasicAuthentication#getPassword() password} attribute.
     * @param password The value for password 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder password(String password) {
      this.password = Objects.requireNonNull(password, "password");
      initBits &= ~INIT_BIT_PASSWORD;
      return this;
    }

    /**
     * Builds a new {@link BasicAuthentication BasicAuthentication}.
     * @return An immutable instance of BasicAuthentication
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public BasicAuthentication build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new BasicAuthentication(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_USERNAME) != 0) attributes.add("username");
      if ((initBits & INIT_BIT_PASSWORD) != 0) attributes.add("password");
      return "Cannot build BasicAuthentication, some of required attributes are not set " + attributes;
    }
  }
}
