package org.cloudfoundry.client.v3.servicebrokers;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.Metadata;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link _CreateServiceBrokerRequest}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code CreateServiceBrokerRequest.builder()}.
 */
@Generated(from = "_CreateServiceBrokerRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class CreateServiceBrokerRequest
    extends org.cloudfoundry.client.v3.servicebrokers._CreateServiceBrokerRequest {
  private final Authentication authentication;
  private final String name;
  private final @Nullable Metadata metadata;
  private final @Nullable ServiceBrokerRelationships relationships;
  private final String url;

  private CreateServiceBrokerRequest(CreateServiceBrokerRequest.Builder builder) {
    this.authentication = builder.authentication;
    this.name = builder.name;
    this.metadata = builder.metadata;
    this.relationships = builder.relationships;
    this.url = builder.url;
  }

  /**
   * @return The value of the {@code authentication} attribute
   */
  @JsonProperty("authentication")
  @Override
  public Authentication getAuthentication() {
    return authentication;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @JsonProperty("name")
  @Override
  public String getName() {
    return name;
  }

  /**
   * @return The value of the {@code metadata} attribute
   */
  @JsonProperty("metadata")
  @Override
  public @Nullable Metadata getMetadata() {
    return metadata;
  }

  /**
   * @return The value of the {@code relationships} attribute
   */
  @JsonProperty("relationships")
  @Override
  public @Nullable ServiceBrokerRelationships getRelationships() {
    return relationships;
  }

  /**
   * @return The value of the {@code url} attribute
   */
  @JsonProperty("url")
  @Override
  public String getUrl() {
    return url;
  }

  /**
   * This instance is equal to all instances of {@code CreateServiceBrokerRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof CreateServiceBrokerRequest
        && equalTo(0, (CreateServiceBrokerRequest) another);
  }

  private boolean equalTo(int synthetic, CreateServiceBrokerRequest another) {
    return authentication.equals(another.authentication)
        && name.equals(another.name)
        && Objects.equals(metadata, another.metadata)
        && Objects.equals(relationships, another.relationships)
        && url.equals(another.url);
  }

  /**
   * Computes a hash code from attributes: {@code authentication}, {@code name}, {@code metadata}, {@code relationships}, {@code url}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + authentication.hashCode();
    h += (h << 5) + name.hashCode();
    h += (h << 5) + Objects.hashCode(metadata);
    h += (h << 5) + Objects.hashCode(relationships);
    h += (h << 5) + url.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code CreateServiceBrokerRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "CreateServiceBrokerRequest{"
        + "authentication=" + authentication
        + ", name=" + name
        + ", metadata=" + metadata
        + ", relationships=" + relationships
        + ", url=" + url
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_CreateServiceBrokerRequest", generator = "Immutables")
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v3.servicebrokers._CreateServiceBrokerRequest {
    Authentication authentication;
    String name;
    Metadata metadata;
    ServiceBrokerRelationships relationships;
    String url;
    @JsonProperty("authentication")
    public void setAuthentication(Authentication authentication) {
      this.authentication = authentication;
    }
    @JsonProperty("name")
    public void setName(String name) {
      this.name = name;
    }
    @JsonProperty("metadata")
    public void setMetadata(@Nullable Metadata metadata) {
      this.metadata = metadata;
    }
    @JsonProperty("relationships")
    public void setRelationships(@Nullable ServiceBrokerRelationships relationships) {
      this.relationships = relationships;
    }
    @JsonProperty("url")
    public void setUrl(String url) {
      this.url = url;
    }
    @Override
    public Authentication getAuthentication() { throw new UnsupportedOperationException(); }
    @Override
    public String getName() { throw new UnsupportedOperationException(); }
    @Override
    public Metadata getMetadata() { throw new UnsupportedOperationException(); }
    @Override
    public ServiceBrokerRelationships getRelationships() { throw new UnsupportedOperationException(); }
    @Override
    public String getUrl() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static CreateServiceBrokerRequest fromJson(Json json) {
    CreateServiceBrokerRequest.Builder builder = CreateServiceBrokerRequest.builder();
    if (json.authentication != null) {
      builder.authentication(json.authentication);
    }
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.metadata != null) {
      builder.metadata(json.metadata);
    }
    if (json.relationships != null) {
      builder.relationships(json.relationships);
    }
    if (json.url != null) {
      builder.url(json.url);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link CreateServiceBrokerRequest CreateServiceBrokerRequest}.
   * <pre>
   * CreateServiceBrokerRequest.builder()
   *    .authentication(org.cloudfoundry.client.v3.servicebrokers.Authentication) // required {@link CreateServiceBrokerRequest#getAuthentication() authentication}
   *    .name(String) // required {@link CreateServiceBrokerRequest#getName() name}
   *    .metadata(org.cloudfoundry.client.v3.Metadata | null) // nullable {@link CreateServiceBrokerRequest#getMetadata() metadata}
   *    .relationships(org.cloudfoundry.client.v3.servicebrokers.ServiceBrokerRelationships | null) // nullable {@link CreateServiceBrokerRequest#getRelationships() relationships}
   *    .url(String) // required {@link CreateServiceBrokerRequest#getUrl() url}
   *    .build();
   * </pre>
   * @return A new CreateServiceBrokerRequest builder
   */
  public static CreateServiceBrokerRequest.Builder builder() {
    return new CreateServiceBrokerRequest.Builder();
  }

  /**
   * Builds instances of type {@link CreateServiceBrokerRequest CreateServiceBrokerRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_CreateServiceBrokerRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_AUTHENTICATION = 0x1L;
    private static final long INIT_BIT_NAME = 0x2L;
    private static final long INIT_BIT_URL = 0x4L;
    private long initBits = 0x7L;

    private Authentication authentication;
    private String name;
    private Metadata metadata;
    private ServiceBrokerRelationships relationships;
    private String url;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code CreateServiceBrokerRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(CreateServiceBrokerRequest instance) {
      return from((_CreateServiceBrokerRequest) instance);
    }

    /**
     * Copy abstract value type {@code _CreateServiceBrokerRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_CreateServiceBrokerRequest instance) {
      Objects.requireNonNull(instance, "instance");
      this.authentication(instance.getAuthentication());
      this.name(instance.getName());
      Metadata metadataValue = instance.getMetadata();
      if (metadataValue != null) {
        metadata(metadataValue);
      }
      ServiceBrokerRelationships relationshipsValue = instance.getRelationships();
      if (relationshipsValue != null) {
        relationships(relationshipsValue);
      }
      this.url(instance.getUrl());
      return this;
    }

    /**
     * Initializes the value for the {@link CreateServiceBrokerRequest#getAuthentication() authentication} attribute.
     * @param authentication The value for authentication 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder authentication(Authentication authentication) {
      this.authentication = Objects.requireNonNull(authentication, "authentication");
      initBits &= ~INIT_BIT_AUTHENTICATION;
      return this;
    }

    /**
     * Initializes the value for the {@link CreateServiceBrokerRequest#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link CreateServiceBrokerRequest#getMetadata() metadata} attribute.
     * @param metadata The value for metadata (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder metadata(@Nullable Metadata metadata) {
      this.metadata = metadata;
      return this;
    }

    /**
     * Initializes the value for the {@link CreateServiceBrokerRequest#getRelationships() relationships} attribute.
     * @param relationships The value for relationships (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder relationships(@Nullable ServiceBrokerRelationships relationships) {
      this.relationships = relationships;
      return this;
    }

    /**
     * Initializes the value for the {@link CreateServiceBrokerRequest#getUrl() url} attribute.
     * @param url The value for url 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder url(String url) {
      this.url = Objects.requireNonNull(url, "url");
      initBits &= ~INIT_BIT_URL;
      return this;
    }

    /**
     * Builds a new {@link CreateServiceBrokerRequest CreateServiceBrokerRequest}.
     * @return An immutable instance of CreateServiceBrokerRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public CreateServiceBrokerRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new CreateServiceBrokerRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_AUTHENTICATION) != 0) attributes.add("authentication");
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      if ((initBits & INIT_BIT_URL) != 0) attributes.add("url");
      return "Cannot build CreateServiceBrokerRequest, some of required attributes are not set " + attributes;
    }
  }
}
