package org.cloudfoundry.client.v3.servicebrokers;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.ToOneRelationship;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link _ServiceBrokerRelationships}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ServiceBrokerRelationships.builder()}.
 */
@Generated(from = "_ServiceBrokerRelationships", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ServiceBrokerRelationships
    extends org.cloudfoundry.client.v3.servicebrokers._ServiceBrokerRelationships {
  private final @Nullable ToOneRelationship space;

  private ServiceBrokerRelationships(ServiceBrokerRelationships.Builder builder) {
    this.space = builder.space;
  }

  /**
   * @return The value of the {@code space} attribute
   */
  @JsonProperty("space")
  @Override
  public @Nullable ToOneRelationship getSpace() {
    return space;
  }

  /**
   * This instance is equal to all instances of {@code ServiceBrokerRelationships} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ServiceBrokerRelationships
        && equalTo(0, (ServiceBrokerRelationships) another);
  }

  private boolean equalTo(int synthetic, ServiceBrokerRelationships another) {
    return Objects.equals(space, another.space);
  }

  /**
   * Computes a hash code from attributes: {@code space}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(space);
    return h;
  }

  /**
   * Prints the immutable value {@code ServiceBrokerRelationships} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ServiceBrokerRelationships{"
        + "space=" + space
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_ServiceBrokerRelationships", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v3.servicebrokers._ServiceBrokerRelationships {
    ToOneRelationship space;
    @JsonProperty("space")
    public void setSpace(@Nullable ToOneRelationship space) {
      this.space = space;
    }
    @Override
    public ToOneRelationship getSpace() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ServiceBrokerRelationships fromJson(Json json) {
    ServiceBrokerRelationships.Builder builder = ServiceBrokerRelationships.builder();
    if (json.space != null) {
      builder.space(json.space);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link ServiceBrokerRelationships ServiceBrokerRelationships}.
   * <pre>
   * ServiceBrokerRelationships.builder()
   *    .space(org.cloudfoundry.client.v3.ToOneRelationship | null) // nullable {@link ServiceBrokerRelationships#getSpace() space}
   *    .build();
   * </pre>
   * @return A new ServiceBrokerRelationships builder
   */
  public static ServiceBrokerRelationships.Builder builder() {
    return new ServiceBrokerRelationships.Builder();
  }

  /**
   * Builds instances of type {@link ServiceBrokerRelationships ServiceBrokerRelationships}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_ServiceBrokerRelationships", generator = "Immutables")
  public static final class Builder {
    private ToOneRelationship space;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ServiceBrokerRelationships} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ServiceBrokerRelationships instance) {
      return from((_ServiceBrokerRelationships) instance);
    }

    /**
     * Copy abstract value type {@code _ServiceBrokerRelationships} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_ServiceBrokerRelationships instance) {
      Objects.requireNonNull(instance, "instance");
      ToOneRelationship spaceValue = instance.getSpace();
      if (spaceValue != null) {
        space(spaceValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link ServiceBrokerRelationships#getSpace() space} attribute.
     * @param space The value for space (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("space")
    public final Builder space(@Nullable ToOneRelationship space) {
      this.space = space;
      return this;
    }

    /**
     * Builds a new {@link ServiceBrokerRelationships ServiceBrokerRelationships}.
     * @return An immutable instance of ServiceBrokerRelationships
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ServiceBrokerRelationships build() {
      return new ServiceBrokerRelationships(this);
    }
  }
}
