package org.cloudfoundry.client.v3.servicebrokers;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.Metadata;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link _UpdateServiceBrokerRequest}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code UpdateServiceBrokerRequest.builder()}.
 */
@Generated(from = "_UpdateServiceBrokerRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class UpdateServiceBrokerRequest
    extends org.cloudfoundry.client.v3.servicebrokers._UpdateServiceBrokerRequest {
  private final @Nullable Authentication authentication;
  private final @Nullable String name;
  private final @Nullable Metadata metadata;
  private final String serviceBrokerId;
  private final @Nullable String url;

  private UpdateServiceBrokerRequest(UpdateServiceBrokerRequest.Builder builder) {
    this.authentication = builder.authentication;
    this.name = builder.name;
    this.metadata = builder.metadata;
    this.serviceBrokerId = builder.serviceBrokerId;
    this.url = builder.url;
  }

  /**
   * @return The value of the {@code authentication} attribute
   */
  @JsonProperty("authentication")
  @Override
  public @Nullable Authentication getAuthentication() {
    return authentication;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @JsonProperty("name")
  @Override
  public @Nullable String getName() {
    return name;
  }

  /**
   * @return The value of the {@code metadata} attribute
   */
  @JsonProperty("metadata")
  @Override
  public @Nullable Metadata getMetadata() {
    return metadata;
  }

  /**
   * @return The value of the {@code serviceBrokerId} attribute
   */
  @JsonProperty("serviceBrokerId")
  @JsonIgnore
  @Override
  public String getServiceBrokerId() {
    return serviceBrokerId;
  }

  /**
   * @return The value of the {@code url} attribute
   */
  @JsonProperty("url")
  @Override
  public @Nullable String getUrl() {
    return url;
  }

  /**
   * This instance is equal to all instances of {@code UpdateServiceBrokerRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof UpdateServiceBrokerRequest
        && equalTo(0, (UpdateServiceBrokerRequest) another);
  }

  private boolean equalTo(int synthetic, UpdateServiceBrokerRequest another) {
    return Objects.equals(authentication, another.authentication)
        && Objects.equals(name, another.name)
        && Objects.equals(metadata, another.metadata)
        && serviceBrokerId.equals(another.serviceBrokerId)
        && Objects.equals(url, another.url);
  }

  /**
   * Computes a hash code from attributes: {@code authentication}, {@code name}, {@code metadata}, {@code serviceBrokerId}, {@code url}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(authentication);
    h += (h << 5) + Objects.hashCode(name);
    h += (h << 5) + Objects.hashCode(metadata);
    h += (h << 5) + serviceBrokerId.hashCode();
    h += (h << 5) + Objects.hashCode(url);
    return h;
  }

  /**
   * Prints the immutable value {@code UpdateServiceBrokerRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "UpdateServiceBrokerRequest{"
        + "authentication=" + authentication
        + ", name=" + name
        + ", metadata=" + metadata
        + ", serviceBrokerId=" + serviceBrokerId
        + ", url=" + url
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_UpdateServiceBrokerRequest", generator = "Immutables")
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v3.servicebrokers._UpdateServiceBrokerRequest {
    Authentication authentication;
    String name;
    Metadata metadata;
    String serviceBrokerId;
    String url;
    @JsonProperty("authentication")
    public void setAuthentication(@Nullable Authentication authentication) {
      this.authentication = authentication;
    }
    @JsonProperty("name")
    public void setName(@Nullable String name) {
      this.name = name;
    }
    @JsonProperty("metadata")
    public void setMetadata(@Nullable Metadata metadata) {
      this.metadata = metadata;
    }
    @JsonProperty("serviceBrokerId")
    @JsonIgnore
    public void setServiceBrokerId(String serviceBrokerId) {
      this.serviceBrokerId = serviceBrokerId;
    }
    @JsonProperty("url")
    public void setUrl(@Nullable String url) {
      this.url = url;
    }
    @Override
    public Authentication getAuthentication() { throw new UnsupportedOperationException(); }
    @Override
    public String getName() { throw new UnsupportedOperationException(); }
    @Override
    public Metadata getMetadata() { throw new UnsupportedOperationException(); }
    @Override
    public String getServiceBrokerId() { throw new UnsupportedOperationException(); }
    @Override
    public String getUrl() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static UpdateServiceBrokerRequest fromJson(Json json) {
    UpdateServiceBrokerRequest.Builder builder = UpdateServiceBrokerRequest.builder();
    if (json.authentication != null) {
      builder.authentication(json.authentication);
    }
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.metadata != null) {
      builder.metadata(json.metadata);
    }
    if (json.serviceBrokerId != null) {
      builder.serviceBrokerId(json.serviceBrokerId);
    }
    if (json.url != null) {
      builder.url(json.url);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link UpdateServiceBrokerRequest UpdateServiceBrokerRequest}.
   * <pre>
   * UpdateServiceBrokerRequest.builder()
   *    .authentication(org.cloudfoundry.client.v3.servicebrokers.Authentication | null) // nullable {@link UpdateServiceBrokerRequest#getAuthentication() authentication}
   *    .name(String | null) // nullable {@link UpdateServiceBrokerRequest#getName() name}
   *    .metadata(org.cloudfoundry.client.v3.Metadata | null) // nullable {@link UpdateServiceBrokerRequest#getMetadata() metadata}
   *    .serviceBrokerId(String) // required {@link UpdateServiceBrokerRequest#getServiceBrokerId() serviceBrokerId}
   *    .url(String | null) // nullable {@link UpdateServiceBrokerRequest#getUrl() url}
   *    .build();
   * </pre>
   * @return A new UpdateServiceBrokerRequest builder
   */
  public static UpdateServiceBrokerRequest.Builder builder() {
    return new UpdateServiceBrokerRequest.Builder();
  }

  /**
   * Builds instances of type {@link UpdateServiceBrokerRequest UpdateServiceBrokerRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_UpdateServiceBrokerRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_SERVICE_BROKER_ID = 0x1L;
    private long initBits = 0x1L;

    private Authentication authentication;
    private String name;
    private Metadata metadata;
    private String serviceBrokerId;
    private String url;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code UpdateServiceBrokerRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(UpdateServiceBrokerRequest instance) {
      return from((_UpdateServiceBrokerRequest) instance);
    }

    /**
     * Copy abstract value type {@code _UpdateServiceBrokerRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_UpdateServiceBrokerRequest instance) {
      Objects.requireNonNull(instance, "instance");
      Authentication authenticationValue = instance.getAuthentication();
      if (authenticationValue != null) {
        authentication(authenticationValue);
      }
      String nameValue = instance.getName();
      if (nameValue != null) {
        name(nameValue);
      }
      Metadata metadataValue = instance.getMetadata();
      if (metadataValue != null) {
        metadata(metadataValue);
      }
      this.serviceBrokerId(instance.getServiceBrokerId());
      String urlValue = instance.getUrl();
      if (urlValue != null) {
        url(urlValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateServiceBrokerRequest#getAuthentication() authentication} attribute.
     * @param authentication The value for authentication (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder authentication(@Nullable Authentication authentication) {
      this.authentication = authentication;
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateServiceBrokerRequest#getName() name} attribute.
     * @param name The value for name (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(@Nullable String name) {
      this.name = name;
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateServiceBrokerRequest#getMetadata() metadata} attribute.
     * @param metadata The value for metadata (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder metadata(@Nullable Metadata metadata) {
      this.metadata = metadata;
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateServiceBrokerRequest#getServiceBrokerId() serviceBrokerId} attribute.
     * @param serviceBrokerId The value for serviceBrokerId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder serviceBrokerId(String serviceBrokerId) {
      this.serviceBrokerId = Objects.requireNonNull(serviceBrokerId, "serviceBrokerId");
      initBits &= ~INIT_BIT_SERVICE_BROKER_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateServiceBrokerRequest#getUrl() url} attribute.
     * @param url The value for url (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder url(@Nullable String url) {
      this.url = url;
      return this;
    }

    /**
     * Builds a new {@link UpdateServiceBrokerRequest UpdateServiceBrokerRequest}.
     * @return An immutable instance of UpdateServiceBrokerRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public UpdateServiceBrokerRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new UpdateServiceBrokerRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_SERVICE_BROKER_ID) != 0) attributes.add("serviceBrokerId");
      return "Cannot build UpdateServiceBrokerRequest, some of required attributes are not set " + attributes;
    }
  }
}
