package org.cloudfoundry.client.v3.serviceofferings;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.client.v3.ToOneRelationship;
import org.immutables.value.Generated;

/**
 * The Service Offering relationships
 */
@Generated(from = "_ServiceOfferingRelationships", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ServiceOfferingRelationships
    extends org.cloudfoundry.client.v3.serviceofferings._ServiceOfferingRelationships {
  private final ToOneRelationship serviceBroker;

  private ServiceOfferingRelationships(ServiceOfferingRelationships.Builder builder) {
    this.serviceBroker = builder.serviceBroker;
  }

  /**
   * The service broker relationship
   */
  @JsonProperty("service_broker")
  @Override
  public ToOneRelationship getServiceBroker() {
    return serviceBroker;
  }

  /**
   * This instance is equal to all instances of {@code ServiceOfferingRelationships} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ServiceOfferingRelationships
        && equalTo(0, (ServiceOfferingRelationships) another);
  }

  private boolean equalTo(int synthetic, ServiceOfferingRelationships another) {
    return serviceBroker.equals(another.serviceBroker);
  }

  /**
   * Computes a hash code from attributes: {@code serviceBroker}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + serviceBroker.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ServiceOfferingRelationships} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ServiceOfferingRelationships{"
        + "serviceBroker=" + serviceBroker
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_ServiceOfferingRelationships", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v3.serviceofferings._ServiceOfferingRelationships {
    ToOneRelationship serviceBroker;
    @JsonProperty("service_broker")
    public void setServiceBroker(ToOneRelationship serviceBroker) {
      this.serviceBroker = serviceBroker;
    }
    @Override
    public ToOneRelationship getServiceBroker() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ServiceOfferingRelationships fromJson(Json json) {
    ServiceOfferingRelationships.Builder builder = ServiceOfferingRelationships.builder();
    if (json.serviceBroker != null) {
      builder.serviceBroker(json.serviceBroker);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link ServiceOfferingRelationships ServiceOfferingRelationships}.
   * <pre>
   * ServiceOfferingRelationships.builder()
   *    .serviceBroker(org.cloudfoundry.client.v3.ToOneRelationship) // required {@link ServiceOfferingRelationships#getServiceBroker() serviceBroker}
   *    .build();
   * </pre>
   * @return A new ServiceOfferingRelationships builder
   */
  public static ServiceOfferingRelationships.Builder builder() {
    return new ServiceOfferingRelationships.Builder();
  }

  /**
   * Builds instances of type {@link ServiceOfferingRelationships ServiceOfferingRelationships}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_ServiceOfferingRelationships", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_SERVICE_BROKER = 0x1L;
    private long initBits = 0x1L;

    private ToOneRelationship serviceBroker;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ServiceOfferingRelationships} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ServiceOfferingRelationships instance) {
      return from((_ServiceOfferingRelationships) instance);
    }

    /**
     * Copy abstract value type {@code _ServiceOfferingRelationships} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_ServiceOfferingRelationships instance) {
      Objects.requireNonNull(instance, "instance");
      this.serviceBroker(instance.getServiceBroker());
      return this;
    }

    /**
     * Initializes the value for the {@link ServiceOfferingRelationships#getServiceBroker() serviceBroker} attribute.
     * @param serviceBroker The value for serviceBroker 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("service_broker")
    public final Builder serviceBroker(ToOneRelationship serviceBroker) {
      this.serviceBroker = Objects.requireNonNull(serviceBroker, "serviceBroker");
      initBits &= ~INIT_BIT_SERVICE_BROKER;
      return this;
    }

    /**
     * Builds a new {@link ServiceOfferingRelationships ServiceOfferingRelationships}.
     * @return An immutable instance of ServiceOfferingRelationships
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ServiceOfferingRelationships build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ServiceOfferingRelationships(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_SERVICE_BROKER) != 0) attributes.add("serviceBroker");
      return "Cannot build ServiceOfferingRelationships, some of required attributes are not set " + attributes;
    }
  }
}
