package org.cloudfoundry.client.v3.serviceplans;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.immutables.value.Generated;

/**
 * Organization for a Service Plan Visibility
 */
@Generated(from = "_Organization", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class Organization extends org.cloudfoundry.client.v3.serviceplans._Organization {
  private final String guid;
  private final @Nullable String name;

  private Organization(Organization.Builder builder) {
    this.guid = builder.guid;
    this.name = builder.name;
  }

  /**
   * The GUID of the organization
   */
  @JsonProperty("guid")
  @Override
  public String getGuid() {
    return guid;
  }

  /**
   * The name of the organization
   */
  @JsonProperty("name")
  @Override
  public @Nullable String getName() {
    return name;
  }

  /**
   * This instance is equal to all instances of {@code Organization} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof Organization
        && equalTo(0, (Organization) another);
  }

  private boolean equalTo(int synthetic, Organization another) {
    return guid.equals(another.guid)
        && Objects.equals(name, another.name);
  }

  /**
   * Computes a hash code from attributes: {@code guid}, {@code name}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + guid.hashCode();
    h += (h << 5) + Objects.hashCode(name);
    return h;
  }

  /**
   * Prints the immutable value {@code Organization} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Organization{"
        + "guid=" + guid
        + ", name=" + name
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_Organization", generator = "Immutables")
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v3.serviceplans._Organization {
    String guid;
    String name;
    @JsonProperty("guid")
    public void setGuid(String guid) {
      this.guid = guid;
    }
    @JsonProperty("name")
    public void setName(@Nullable String name) {
      this.name = name;
    }
    @Override
    public String getGuid() { throw new UnsupportedOperationException(); }
    @Override
    public String getName() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static Organization fromJson(Json json) {
    Organization.Builder builder = Organization.builder();
    if (json.guid != null) {
      builder.guid(json.guid);
    }
    if (json.name != null) {
      builder.name(json.name);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link Organization Organization}.
   * <pre>
   * Organization.builder()
   *    .guid(String) // required {@link Organization#getGuid() guid}
   *    .name(String | null) // nullable {@link Organization#getName() name}
   *    .build();
   * </pre>
   * @return A new Organization builder
   */
  public static Organization.Builder builder() {
    return new Organization.Builder();
  }

  /**
   * Builds instances of type {@link Organization Organization}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_Organization", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_GUID = 0x1L;
    private long initBits = 0x1L;

    private String guid;
    private String name;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Organization} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Organization instance) {
      return from((_Organization) instance);
    }

    /**
     * Copy abstract value type {@code _Organization} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_Organization instance) {
      Objects.requireNonNull(instance, "instance");
      this.guid(instance.getGuid());
      String nameValue = instance.getName();
      if (nameValue != null) {
        name(nameValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link Organization#getGuid() guid} attribute.
     * @param guid The value for guid 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder guid(String guid) {
      this.guid = Objects.requireNonNull(guid, "guid");
      initBits &= ~INIT_BIT_GUID;
      return this;
    }

    /**
     * Initializes the value for the {@link Organization#getName() name} attribute.
     * @param name The value for name (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(@Nullable String name) {
      this.name = name;
      return this;
    }

    /**
     * Builds a new {@link Organization Organization}.
     * @return An immutable instance of Organization
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public Organization build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new Organization(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_GUID) != 0) attributes.add("guid");
      return "Cannot build Organization, some of required attributes are not set " + attributes;
    }
  }
}
