package org.cloudfoundry.client.v3.serviceplans;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.immutables.value.Generated;

/**
 * The entity representing service plan schema parameters
 */
@Generated(from = "_Parameters", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class Parameters extends org.cloudfoundry.client.v3.serviceplans._Parameters {
  private final @Nullable String jsonSchema;
  private final @Nullable Map<String, Object> properties;
  private final @Nullable String type;

  private Parameters(Parameters.Builder builder) {
    this.jsonSchema = builder.jsonSchema;
    this.properties = builder.properties == null ? null : createUnmodifiableMap(false, false, builder.properties);
    this.type = builder.type;
  }

  /**
   * The JSON schema
   */
  @JsonProperty("$schema")
  @Override
  public @Nullable String getJsonSchema() {
    return jsonSchema;
  }

  /**
   * The parameter properties
   */
  @JsonProperty("properties")
  @Override
  public @Nullable Map<String, Object> getProperties() {
    return properties;
  }

  /**
   * The parameter type
   */
  @JsonProperty("type")
  @Override
  public @Nullable String getType() {
    return type;
  }

  /**
   * This instance is equal to all instances of {@code Parameters} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof Parameters
        && equalTo(0, (Parameters) another);
  }

  private boolean equalTo(int synthetic, Parameters another) {
    return Objects.equals(jsonSchema, another.jsonSchema)
        && Objects.equals(properties, another.properties)
        && Objects.equals(type, another.type);
  }

  /**
   * Computes a hash code from attributes: {@code jsonSchema}, {@code properties}, {@code type}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(jsonSchema);
    h += (h << 5) + Objects.hashCode(properties);
    h += (h << 5) + Objects.hashCode(type);
    return h;
  }

  /**
   * Prints the immutable value {@code Parameters} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Parameters{"
        + "jsonSchema=" + jsonSchema
        + ", properties=" + properties
        + ", type=" + type
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_Parameters", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v3.serviceplans._Parameters {
    String jsonSchema;
    Map<String, Object> properties = null;
    String type;
    @JsonProperty("$schema")
    public void setJsonSchema(@Nullable String jsonSchema) {
      this.jsonSchema = jsonSchema;
    }
    @JsonProperty("properties")
    public void setProperties(@Nullable Map<String, Object> properties) {
      this.properties = properties;
    }
    @JsonProperty("type")
    public void setType(@Nullable String type) {
      this.type = type;
    }
    @Override
    public String getJsonSchema() { throw new UnsupportedOperationException(); }
    @Override
    public Map<String, Object> getProperties() { throw new UnsupportedOperationException(); }
    @Override
    public String getType() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static Parameters fromJson(Json json) {
    Parameters.Builder builder = Parameters.builder();
    if (json.jsonSchema != null) {
      builder.jsonSchema(json.jsonSchema);
    }
    if (json.properties != null) {
      builder.putAllProperties(json.properties);
    }
    if (json.type != null) {
      builder.type(json.type);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link Parameters Parameters}.
   * <pre>
   * Parameters.builder()
   *    .jsonSchema(String | null) // nullable {@link Parameters#getJsonSchema() jsonSchema}
   *    .properties(Map&amp;lt;String, Object&amp;gt; | null) // nullable {@link Parameters#getProperties() properties}
   *    .type(String | null) // nullable {@link Parameters#getType() type}
   *    .build();
   * </pre>
   * @return A new Parameters builder
   */
  public static Parameters.Builder builder() {
    return new Parameters.Builder();
  }

  /**
   * Builds instances of type {@link Parameters Parameters}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_Parameters", generator = "Immutables")
  public static final class Builder {
    private String jsonSchema;
    private Map<String, Object> properties = null;
    private String type;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Parameters} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Parameters instance) {
      return from((_Parameters) instance);
    }

    /**
     * Copy abstract value type {@code _Parameters} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_Parameters instance) {
      Objects.requireNonNull(instance, "instance");
      String jsonSchemaValue = instance.getJsonSchema();
      if (jsonSchemaValue != null) {
        jsonSchema(jsonSchemaValue);
      }
      Map<String, Object> propertiesValue = instance.getProperties();
      if (propertiesValue != null) {
        putAllProperties(propertiesValue);
      }
      String typeValue = instance.getType();
      if (typeValue != null) {
        type(typeValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link Parameters#getJsonSchema() jsonSchema} attribute.
     * @param jsonSchema The value for jsonSchema (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("$schema")
    public final Builder jsonSchema(@Nullable String jsonSchema) {
      this.jsonSchema = jsonSchema;
      return this;
    }

    /**
     * Put one entry to the {@link Parameters#getProperties() properties} map.
     * @param key The key in the properties map
     * @param value The associated value in the properties map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder property(String key, Object value) {
      if (this.properties == null) {
        this.properties = new LinkedHashMap<String, Object>();
      }
      this.properties.put(
          Objects.requireNonNull(key, "properties key"),
          Objects.requireNonNull(value, value == null ? "properties value for key: " + key : null));
      return this;
    }

    /**
     * Put one entry to the {@link Parameters#getProperties() properties} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder property(Map.Entry<String, ? extends Object> entry) {
      if (this.properties == null) {
        this.properties = new LinkedHashMap<String, Object>();
      }
      String k = entry.getKey();
      Object v = entry.getValue();
      this.properties.put(
          Objects.requireNonNull(k, "properties key"),
          Objects.requireNonNull(v, v == null ? "properties value for key: " + k : null));
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link Parameters#getProperties() properties} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param entries The entries that will be added to the properties map
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("properties")
    public final Builder properties(@Nullable Map<String, ? extends Object> entries) {
      if (entries == null) {
        this.properties = null;
        return this;
      }
      this.properties = new LinkedHashMap<String, Object>();
      return putAllProperties(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link Parameters#getProperties() properties} map. Nulls are not permitted
     * @param entries The entries that will be added to the properties map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllProperties(Map<String, ? extends Object> entries) {
      if (this.properties == null) {
        this.properties = new LinkedHashMap<String, Object>();
      }
      for (Map.Entry<String, ? extends Object> e : entries.entrySet()) {
        String k = e.getKey();
        Object v = e.getValue();
        this.properties.put(
            Objects.requireNonNull(k, "properties key"),
            Objects.requireNonNull(v, v == null ? "properties value for key: " + k : null));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link Parameters#getType() type} attribute.
     * @param type The value for type (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("type")
    public final Builder type(@Nullable String type) {
      this.type = type;
      return this;
    }

    /**
     * Builds a new {@link Parameters Parameters}.
     * @return An immutable instance of Parameters
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public Parameters build() {
      return new Parameters(this);
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<>(map.size() * 4 / 3 + 1);
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
