package org.cloudfoundry.client.v3.serviceplans;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.immutables.value.Generated;

/**
 * The response payload for the Update Service Plan operation
 */
@Generated(from = "_UpdateServicePlanVisibilityResponse", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class UpdateServicePlanVisibilityResponse
    extends org.cloudfoundry.client.v3.serviceplans._UpdateServicePlanVisibilityResponse {
  private final Visibility type;
  private final @Nullable List<Organization> organizations;

  private UpdateServicePlanVisibilityResponse(UpdateServicePlanVisibilityResponse.Builder builder) {
    this.type = builder.type;
    this.organizations = builder.organizations == null ? null : createUnmodifiableList(true, builder.organizations);
  }

  /**
   * Denotes the visibility of the plan
   */
  @JsonProperty("type")
  @Override
  public Visibility getType() {
    return type;
  }

  /**
   * The organizations where the service plan is visible
   */
  @JsonProperty("organizations")
  @Override
  public @Nullable List<Organization> getOrganizations() {
    return organizations;
  }

  /**
   * This instance is equal to all instances of {@code UpdateServicePlanVisibilityResponse} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof UpdateServicePlanVisibilityResponse
        && equalTo(0, (UpdateServicePlanVisibilityResponse) another);
  }

  private boolean equalTo(int synthetic, UpdateServicePlanVisibilityResponse another) {
    return type.equals(another.type)
        && Objects.equals(organizations, another.organizations);
  }

  /**
   * Computes a hash code from attributes: {@code type}, {@code organizations}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + type.hashCode();
    h += (h << 5) + Objects.hashCode(organizations);
    return h;
  }

  /**
   * Prints the immutable value {@code UpdateServicePlanVisibilityResponse} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "UpdateServicePlanVisibilityResponse{"
        + "type=" + type
        + ", organizations=" + organizations
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_UpdateServicePlanVisibilityResponse", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v3.serviceplans._UpdateServicePlanVisibilityResponse {
    Visibility type;
    List<Organization> organizations = null;
    @JsonProperty("type")
    public void setType(Visibility type) {
      this.type = type;
    }
    @JsonProperty("organizations")
    public void setOrganizations(@Nullable List<Organization> organizations) {
      this.organizations = organizations;
    }
    @Override
    public Visibility getType() { throw new UnsupportedOperationException(); }
    @Override
    public List<Organization> getOrganizations() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static UpdateServicePlanVisibilityResponse fromJson(Json json) {
    UpdateServicePlanVisibilityResponse.Builder builder = UpdateServicePlanVisibilityResponse.builder();
    if (json.type != null) {
      builder.type(json.type);
    }
    if (json.organizations != null) {
      builder.addAllOrganizations(json.organizations);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link UpdateServicePlanVisibilityResponse UpdateServicePlanVisibilityResponse}.
   * <pre>
   * UpdateServicePlanVisibilityResponse.builder()
   *    .type(org.cloudfoundry.client.v3.serviceplans.Visibility) // required {@link UpdateServicePlanVisibilityResponse#getType() type}
   *    .organizations(List&amp;lt;Organization&amp;gt; | null) // nullable {@link UpdateServicePlanVisibilityResponse#getOrganizations() organizations}
   *    .build();
   * </pre>
   * @return A new UpdateServicePlanVisibilityResponse builder
   */
  public static UpdateServicePlanVisibilityResponse.Builder builder() {
    return new UpdateServicePlanVisibilityResponse.Builder();
  }

  /**
   * Builds instances of type {@link UpdateServicePlanVisibilityResponse UpdateServicePlanVisibilityResponse}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_UpdateServicePlanVisibilityResponse", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_TYPE = 0x1L;
    private long initBits = 0x1L;

    private Visibility type;
    private List<Organization> organizations = null;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code UpdateServicePlanVisibilityResponse} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(UpdateServicePlanVisibilityResponse instance) {
      return from((_UpdateServicePlanVisibilityResponse) instance);
    }

    /**
     * Copy abstract value type {@code _UpdateServicePlanVisibilityResponse} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_UpdateServicePlanVisibilityResponse instance) {
      Objects.requireNonNull(instance, "instance");
      this.type(instance.getType());
      List<Organization> organizationsValue = instance.getOrganizations();
      if (organizationsValue != null) {
        addAllOrganizations(organizationsValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateServicePlanVisibilityResponse#getType() type} attribute.
     * @param type The value for type 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("type")
    public final Builder type(Visibility type) {
      this.type = Objects.requireNonNull(type, "type");
      initBits &= ~INIT_BIT_TYPE;
      return this;
    }

    /**
     * Adds one element to {@link UpdateServicePlanVisibilityResponse#getOrganizations() organizations} list.
     * @param element A organizations element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder organization(Organization element) {
      if (this.organizations == null) {
        this.organizations = new ArrayList<Organization>();
      }
      this.organizations.add(Objects.requireNonNull(element, "organizations element"));
      return this;
    }

    /**
     * Adds elements to {@link UpdateServicePlanVisibilityResponse#getOrganizations() organizations} list.
     * @param elements An array of organizations elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder organizations(Organization... elements) {
      if (this.organizations == null) {
        this.organizations = new ArrayList<Organization>();
      }
      for (Organization element : elements) {
        this.organizations.add(Objects.requireNonNull(element, "organizations element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link UpdateServicePlanVisibilityResponse#getOrganizations() organizations} list.
     * @param elements An iterable of organizations elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("organizations")
    public final Builder organizations(@Nullable Iterable<? extends Organization> elements) {
      if (elements == null) {
        this.organizations = null;
        return this;
      }
      this.organizations = new ArrayList<Organization>();
      return addAllOrganizations(elements);
    }

    /**
     * Adds elements to {@link UpdateServicePlanVisibilityResponse#getOrganizations() organizations} list.
     * @param elements An iterable of organizations elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllOrganizations(Iterable<? extends Organization> elements) {
      Objects.requireNonNull(elements, "organizations element");
      if (this.organizations == null) {
        this.organizations = new ArrayList<Organization>();
      }
      for (Organization element : elements) {
        this.organizations.add(Objects.requireNonNull(element, "organizations element"));
      }
      return this;
    }

    /**
     * Builds a new {@link UpdateServicePlanVisibilityResponse UpdateServicePlanVisibilityResponse}.
     * @return An immutable instance of UpdateServicePlanVisibilityResponse
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public UpdateServicePlanVisibilityResponse build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new UpdateServicePlanVisibilityResponse(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_TYPE) != 0) attributes.add("type");
      return "Cannot build UpdateServicePlanVisibilityResponse, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>(size);
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
