package org.cloudfoundry.client.v3.stacks;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.*;
import org.cloudfoundry.client.v3.Metadata;
import org.cloudfoundry.client.v3.Resource;
import org.immutables.value.Generated;

/**
 * The response payload for the Get Stack operation
 */
@Generated(from = "_GetStackResponse", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class GetStackResponse extends org.cloudfoundry.client.v3.stacks._GetStackResponse {
  private final String createdAt;
  private final String id;
  private final Map<String, Link> links;
  private final @Nullable String updatedAt;
  private final String name;
  private final @Nullable String description;
  private final @Nullable Metadata metadata;
  private final @Nullable String buildRootfsImage;
  private final @Nullable String runRootfsImage;
  private final @Nullable Boolean geDefault;

  private GetStackResponse(GetStackResponse.Builder builder) {
    this.createdAt = builder.createdAt;
    this.id = builder.id;
    this.links = createUnmodifiableMap(false, false, builder.links);
    this.updatedAt = builder.updatedAt;
    this.name = builder.name;
    this.description = builder.description;
    this.metadata = builder.metadata;
    this.buildRootfsImage = builder.buildRootfsImage;
    this.runRootfsImage = builder.runRootfsImage;
    this.geDefault = builder.geDefault;
  }

  /**
   * When the resource was created
   */
  @JsonProperty("created_at")
  @Override
  public String getCreatedAt() {
    return createdAt;
  }

  /**
   * The resource's id
   */
  @JsonProperty("guid")
  @Override
  public String getId() {
    return id;
  }

  /**
   * Links to related resources and actions for the resource
   */
  @JsonProperty("links")
  @Override
  public Map<String, Link> getLinks() {
    return links;
  }

  /**
   * When the resource was last updated
   */
  @JsonProperty("updated_at")
  @Override
  public @Nullable String getUpdatedAt() {
    return updatedAt;
  }

  /**
   * The name
   */
  @JsonProperty("name")
  @Override
  public String getName() {
    return name;
  }

  /**
   * The description
   */
  @JsonProperty("description")
  @Override
  public @Nullable String getDescription() {
    return description;
  }

  /**
   * The metadata
   */
  @JsonProperty("metadata")
  @Override
  public @Nullable Metadata getMetadata() {
    return metadata;
  }

  /**
   * Build RootFS Image
   */
  @JsonProperty("build_rootfs_image")
  @Override
  public @Nullable String getBuildRootfsImage() {
    return buildRootfsImage;
  }

  /**
   * Run RootFS Image
   */
  @JsonProperty("run_rootfs_image")
  @Override
  public @Nullable String getRunRootfsImage() {
    return runRootfsImage;
  }

  /**
   * Whether the stack is configured to be the default stack for new applications.
   */
  @JsonProperty("default")
  @Override
  public @Nullable Boolean geDefault() {
    return geDefault;
  }

  /**
   * This instance is equal to all instances of {@code GetStackResponse} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof GetStackResponse
        && equalTo(0, (GetStackResponse) another);
  }

  private boolean equalTo(int synthetic, GetStackResponse another) {
    return createdAt.equals(another.createdAt)
        && id.equals(another.id)
        && links.equals(another.links)
        && Objects.equals(updatedAt, another.updatedAt)
        && name.equals(another.name)
        && Objects.equals(description, another.description)
        && Objects.equals(metadata, another.metadata)
        && Objects.equals(buildRootfsImage, another.buildRootfsImage)
        && Objects.equals(runRootfsImage, another.runRootfsImage)
        && Objects.equals(geDefault, another.geDefault);
  }

  /**
   * Computes a hash code from attributes: {@code createdAt}, {@code id}, {@code links}, {@code updatedAt}, {@code name}, {@code description}, {@code metadata}, {@code buildRootfsImage}, {@code runRootfsImage}, {@code geDefault}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + createdAt.hashCode();
    h += (h << 5) + id.hashCode();
    h += (h << 5) + links.hashCode();
    h += (h << 5) + Objects.hashCode(updatedAt);
    h += (h << 5) + name.hashCode();
    h += (h << 5) + Objects.hashCode(description);
    h += (h << 5) + Objects.hashCode(metadata);
    h += (h << 5) + Objects.hashCode(buildRootfsImage);
    h += (h << 5) + Objects.hashCode(runRootfsImage);
    h += (h << 5) + Objects.hashCode(geDefault);
    return h;
  }

  /**
   * Prints the immutable value {@code GetStackResponse} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "GetStackResponse{"
        + "createdAt=" + createdAt
        + ", id=" + id
        + ", links=" + links
        + ", updatedAt=" + updatedAt
        + ", name=" + name
        + ", description=" + description
        + ", metadata=" + metadata
        + ", buildRootfsImage=" + buildRootfsImage
        + ", runRootfsImage=" + runRootfsImage
        + ", geDefault=" + geDefault
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_GetStackResponse", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v3.stacks._GetStackResponse {
    String createdAt;
    String id;
    Map<String, Link> links = Collections.emptyMap();
    String updatedAt;
    String name;
    String description;
    Metadata metadata;
    String buildRootfsImage;
    String runRootfsImage;
    Boolean geDefault;
    @JsonProperty("created_at")
    public void setCreatedAt(String createdAt) {
      this.createdAt = createdAt;
    }
    @JsonProperty("guid")
    public void setId(String id) {
      this.id = id;
    }
    @JsonProperty("links")
    public void setLinks(Map<String, Link> links) {
      this.links = links;
    }
    @JsonProperty("updated_at")
    public void setUpdatedAt(@Nullable String updatedAt) {
      this.updatedAt = updatedAt;
    }
    @JsonProperty("name")
    public void setName(String name) {
      this.name = name;
    }
    @JsonProperty("description")
    public void setDescription(@Nullable String description) {
      this.description = description;
    }
    @JsonProperty("metadata")
    public void setMetadata(@Nullable Metadata metadata) {
      this.metadata = metadata;
    }
    @JsonProperty("build_rootfs_image")
    public void setBuildRootfsImage(@Nullable String buildRootfsImage) {
      this.buildRootfsImage = buildRootfsImage;
    }
    @JsonProperty("run_rootfs_image")
    public void setRunRootfsImage(@Nullable String runRootfsImage) {
      this.runRootfsImage = runRootfsImage;
    }
    @JsonProperty("default")
    public void setGeDefault(@Nullable Boolean geDefault) {
      this.geDefault = geDefault;
    }
    @Override
    public String getCreatedAt() { throw new UnsupportedOperationException(); }
    @Override
    public String getId() { throw new UnsupportedOperationException(); }
    @Override
    public Map<String, Link> getLinks() { throw new UnsupportedOperationException(); }
    @Override
    public String getUpdatedAt() { throw new UnsupportedOperationException(); }
    @Override
    public String getName() { throw new UnsupportedOperationException(); }
    @Override
    public String getDescription() { throw new UnsupportedOperationException(); }
    @Override
    public Metadata getMetadata() { throw new UnsupportedOperationException(); }
    @Override
    public String getBuildRootfsImage() { throw new UnsupportedOperationException(); }
    @Override
    public String getRunRootfsImage() { throw new UnsupportedOperationException(); }
    @Override
    public Boolean geDefault() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static GetStackResponse fromJson(Json json) {
    GetStackResponse.Builder builder = GetStackResponse.builder();
    if (json.createdAt != null) {
      builder.createdAt(json.createdAt);
    }
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.links != null) {
      builder.putAllLinks(json.links);
    }
    if (json.updatedAt != null) {
      builder.updatedAt(json.updatedAt);
    }
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.description != null) {
      builder.description(json.description);
    }
    if (json.metadata != null) {
      builder.metadata(json.metadata);
    }
    if (json.buildRootfsImage != null) {
      builder.buildRootfsImage(json.buildRootfsImage);
    }
    if (json.runRootfsImage != null) {
      builder.runRootfsImage(json.runRootfsImage);
    }
    if (json.geDefault != null) {
      builder.geDefault(json.geDefault);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link GetStackResponse GetStackResponse}.
   * <pre>
   * GetStackResponse.builder()
   *    .createdAt(String) // required {@link GetStackResponse#getCreatedAt() createdAt}
   *    .id(String) // required {@link GetStackResponse#getId() id}
   *    .link|putAllLinks(String =&gt; Link) // {@link GetStackResponse#getLinks() links} mappings
   *    .updatedAt(String | null) // nullable {@link GetStackResponse#getUpdatedAt() updatedAt}
   *    .name(String) // required {@link GetStackResponse#getName() name}
   *    .description(String | null) // nullable {@link GetStackResponse#getDescription() description}
   *    .metadata(org.cloudfoundry.client.v3.Metadata | null) // nullable {@link GetStackResponse#getMetadata() metadata}
   *    .buildRootfsImage(String | null) // nullable {@link GetStackResponse#getBuildRootfsImage() buildRootfsImage}
   *    .runRootfsImage(String | null) // nullable {@link GetStackResponse#getRunRootfsImage() runRootfsImage}
   *    .geDefault(Boolean | null) // nullable {@link GetStackResponse#geDefault() geDefault}
   *    .build();
   * </pre>
   * @return A new GetStackResponse builder
   */
  public static GetStackResponse.Builder builder() {
    return new GetStackResponse.Builder();
  }

  /**
   * Builds instances of type {@link GetStackResponse GetStackResponse}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_GetStackResponse", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_CREATED_AT = 0x1L;
    private static final long INIT_BIT_ID = 0x2L;
    private static final long INIT_BIT_NAME = 0x4L;
    private long initBits = 0x7L;

    private String createdAt;
    private String id;
    private Map<String, Link> links = new LinkedHashMap<String, Link>();
    private String updatedAt;
    private String name;
    private String description;
    private Metadata metadata;
    private String buildRootfsImage;
    private String runRootfsImage;
    private Boolean geDefault;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.client.v3.Resource} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Resource instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.client.v3.stacks.Stack} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Stack instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code GetStackResponse} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(GetStackResponse instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _GetStackResponse} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(_GetStackResponse instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    private void from(short _unused, Object object) {
      long bits = 0;
      if (object instanceof Resource) {
        Resource instance = (Resource) object;
        if ((bits & 0x10L) == 0) {
          this.createdAt(instance.getCreatedAt());
          bits |= 0x10L;
        }
        if ((bits & 0x80L) == 0) {
          putAllLinks(instance.getLinks());
          bits |= 0x80L;
        }
        if ((bits & 0x100L) == 0) {
          this.id(instance.getId());
          bits |= 0x100L;
        }
        if ((bits & 0x200L) == 0) {
          String updatedAtValue = instance.getUpdatedAt();
          if (updatedAtValue != null) {
            updatedAt(updatedAtValue);
          }
          bits |= 0x200L;
        }
      }
      if (object instanceof Stack) {
        Stack instance = (Stack) object;
        if ((bits & 0x1L) == 0) {
          String buildRootfsImageValue = instance.getBuildRootfsImage();
          if (buildRootfsImageValue != null) {
            buildRootfsImage(buildRootfsImageValue);
          }
          bits |= 0x1L;
        }
        if ((bits & 0x10L) == 0) {
          this.createdAt(instance.getCreatedAt());
          bits |= 0x10L;
        }
        if ((bits & 0x2L) == 0) {
          Metadata metadataValue = instance.getMetadata();
          if (metadataValue != null) {
            metadata(metadataValue);
          }
          bits |= 0x2L;
        }
        if ((bits & 0x4L) == 0) {
          Boolean geDefaultValue = instance.geDefault();
          if (geDefaultValue != null) {
            geDefault(geDefaultValue);
          }
          bits |= 0x4L;
        }
        if ((bits & 0x20L) == 0) {
          this.name(instance.getName());
          bits |= 0x20L;
        }
        if ((bits & 0x40L) == 0) {
          String runRootfsImageValue = instance.getRunRootfsImage();
          if (runRootfsImageValue != null) {
            runRootfsImage(runRootfsImageValue);
          }
          bits |= 0x40L;
        }
        if ((bits & 0x8L) == 0) {
          String descriptionValue = instance.getDescription();
          if (descriptionValue != null) {
            description(descriptionValue);
          }
          bits |= 0x8L;
        }
        if ((bits & 0x80L) == 0) {
          putAllLinks(instance.getLinks());
          bits |= 0x80L;
        }
        if ((bits & 0x100L) == 0) {
          this.id(instance.getId());
          bits |= 0x100L;
        }
        if ((bits & 0x200L) == 0) {
          String updatedAtValue = instance.getUpdatedAt();
          if (updatedAtValue != null) {
            updatedAt(updatedAtValue);
          }
          bits |= 0x200L;
        }
      }
      if (object instanceof org.cloudfoundry.client.v3.stacks._GetStackResponse) {
        org.cloudfoundry.client.v3.stacks._GetStackResponse instance = (org.cloudfoundry.client.v3.stacks._GetStackResponse) object;
        if ((bits & 0x4L) == 0) {
          Boolean geDefaultValue = instance.geDefault();
          if (geDefaultValue != null) {
            geDefault(geDefaultValue);
          }
          bits |= 0x4L;
        }
        if ((bits & 0x20L) == 0) {
          this.name(instance.getName());
          bits |= 0x20L;
        }
        if ((bits & 0x40L) == 0) {
          String runRootfsImageValue = instance.getRunRootfsImage();
          if (runRootfsImageValue != null) {
            runRootfsImage(runRootfsImageValue);
          }
          bits |= 0x40L;
        }
        if ((bits & 0x1L) == 0) {
          String buildRootfsImageValue = instance.getBuildRootfsImage();
          if (buildRootfsImageValue != null) {
            buildRootfsImage(buildRootfsImageValue);
          }
          bits |= 0x1L;
        }
        if ((bits & 0x8L) == 0) {
          String descriptionValue = instance.getDescription();
          if (descriptionValue != null) {
            description(descriptionValue);
          }
          bits |= 0x8L;
        }
        if ((bits & 0x2L) == 0) {
          Metadata metadataValue = instance.getMetadata();
          if (metadataValue != null) {
            metadata(metadataValue);
          }
          bits |= 0x2L;
        }
      }
    }

    /**
     * Initializes the value for the {@link GetStackResponse#getCreatedAt() createdAt} attribute.
     * @param createdAt The value for createdAt 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("created_at")
    public final Builder createdAt(String createdAt) {
      this.createdAt = Objects.requireNonNull(createdAt, "createdAt");
      initBits &= ~INIT_BIT_CREATED_AT;
      return this;
    }

    /**
     * Initializes the value for the {@link GetStackResponse#getId() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("guid")
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Put one entry to the {@link GetStackResponse#getLinks() links} map.
     * @param key The key in the links map
     * @param value The associated value in the links map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder link(String key, Link value) {
      this.links.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link GetStackResponse#getLinks() links} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder link(Map.Entry<String, ? extends Link> entry) {
      String k = entry.getKey();
      Link v = entry.getValue();
      this.links.put(k, v);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link GetStackResponse#getLinks() links} map. Nulls are not permitted
     * @param entries The entries that will be added to the links map
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("links")
    public final Builder links(Map<String, ? extends Link> entries) {
      this.links.clear();
      return putAllLinks(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link GetStackResponse#getLinks() links} map. Nulls are not permitted
     * @param entries The entries that will be added to the links map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllLinks(Map<String, ? extends Link> entries) {
      for (Map.Entry<String, ? extends Link> e : entries.entrySet()) {
        String k = e.getKey();
        Link v = e.getValue();
        this.links.put(k, v);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link GetStackResponse#getUpdatedAt() updatedAt} attribute.
     * @param updatedAt The value for updatedAt (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("updated_at")
    public final Builder updatedAt(@Nullable String updatedAt) {
      this.updatedAt = updatedAt;
      return this;
    }

    /**
     * Initializes the value for the {@link GetStackResponse#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("name")
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link GetStackResponse#getDescription() description} attribute.
     * @param description The value for description (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("description")
    public final Builder description(@Nullable String description) {
      this.description = description;
      return this;
    }

    /**
     * Initializes the value for the {@link GetStackResponse#getMetadata() metadata} attribute.
     * @param metadata The value for metadata (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("metadata")
    public final Builder metadata(@Nullable Metadata metadata) {
      this.metadata = metadata;
      return this;
    }

    /**
     * Initializes the value for the {@link GetStackResponse#getBuildRootfsImage() buildRootfsImage} attribute.
     * @param buildRootfsImage The value for buildRootfsImage (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("build_rootfs_image")
    public final Builder buildRootfsImage(@Nullable String buildRootfsImage) {
      this.buildRootfsImage = buildRootfsImage;
      return this;
    }

    /**
     * Initializes the value for the {@link GetStackResponse#getRunRootfsImage() runRootfsImage} attribute.
     * @param runRootfsImage The value for runRootfsImage (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("run_rootfs_image")
    public final Builder runRootfsImage(@Nullable String runRootfsImage) {
      this.runRootfsImage = runRootfsImage;
      return this;
    }

    /**
     * Initializes the value for the {@link GetStackResponse#geDefault() geDefault} attribute.
     * @param geDefault The value for geDefault (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("default")
    public final Builder geDefault(@Nullable Boolean geDefault) {
      this.geDefault = geDefault;
      return this;
    }

    /**
     * Builds a new {@link GetStackResponse GetStackResponse}.
     * @return An immutable instance of GetStackResponse
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public GetStackResponse build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new GetStackResponse(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_CREATED_AT) != 0) attributes.add("createdAt");
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      return "Cannot build GetStackResponse, some of required attributes are not set " + attributes;
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<>(map.size() * 4 / 3 + 1);
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
