package org.cloudfoundry.doppler;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Indicates the value of a metric at an instant in time
 */
@Generated(from = "_ValueMetric", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ValueMetric extends org.cloudfoundry.doppler._ValueMetric {
  private final String name;
  private final String unit;
  private final Double value;

  private ValueMetric(ValueMetric.Builder builder) {
    this.name = builder.name;
    this.unit = builder.unit;
    this.value = builder.value;
  }

  /**
   * The name of the metric. Must be consistent for downstream consumers to associate events semantically.
   */
  @Override
  public String getName() {
    return name;
  }

  /**
   * The unit of the metric. Please see <a href="http://metrics20.org/spec/#units">http://metrics20.org/spec/#units</a> for ideas; SI units/prefixes are recommended where applicable. Should be
   * consistent for the life of the metric (consumers are expected to report, but not interpret, prefixes).
   */
  @Override
  public String getUnit() {
    return unit;
  }

  /**
   * The value at the time of event emission
   */
  @Override
  public Double value() {
    return value;
  }

  /**
   * This instance is equal to all instances of {@code ValueMetric} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ValueMetric
        && equalTo(0, (ValueMetric) another);
  }

  private boolean equalTo(int synthetic, ValueMetric another) {
    return name.equals(another.name)
        && unit.equals(another.unit)
        && value.equals(another.value);
  }

  /**
   * Computes a hash code from attributes: {@code name}, {@code unit}, {@code value}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + name.hashCode();
    h += (h << 5) + unit.hashCode();
    h += (h << 5) + value.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ValueMetric} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ValueMetric{"
        + "name=" + name
        + ", unit=" + unit
        + ", value=" + value
        + "}";
  }

  /**
   * Creates a builder for {@link ValueMetric ValueMetric}.
   * <pre>
   * ValueMetric.builder()
   *    .name(String) // required {@link ValueMetric#getName() name}
   *    .unit(String) // required {@link ValueMetric#getUnit() unit}
   *    .value(Double) // required {@link ValueMetric#value() value}
   *    .build();
   * </pre>
   * @return A new ValueMetric builder
   */
  public static ValueMetric.Builder builder() {
    return new ValueMetric.Builder();
  }

  /**
   * Builds instances of type {@link ValueMetric ValueMetric}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_ValueMetric", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_NAME = 0x1L;
    private static final long INIT_BIT_UNIT = 0x2L;
    private static final long INIT_BIT_VALUE = 0x4L;
    private long initBits = 0x7L;

    private String name;
    private String unit;
    private Double value;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ValueMetric} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ValueMetric instance) {
      return from((_ValueMetric) instance);
    }

    /**
     * Copy abstract value type {@code _ValueMetric} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_ValueMetric instance) {
      Objects.requireNonNull(instance, "instance");
      this.name(instance.getName());
      this.unit(instance.getUnit());
      this.value(instance.value());
      return this;
    }

    /**
     * Initializes the value for the {@link ValueMetric#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link ValueMetric#getUnit() unit} attribute.
     * @param unit The value for unit 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder unit(String unit) {
      this.unit = Objects.requireNonNull(unit, "unit");
      initBits &= ~INIT_BIT_UNIT;
      return this;
    }

    /**
     * Initializes the value for the {@link ValueMetric#value() value} attribute.
     * @param value The value for value 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder value(Double value) {
      this.value = Objects.requireNonNull(value, "value");
      initBits &= ~INIT_BIT_VALUE;
      return this;
    }

    /**
     * Builds a new {@link ValueMetric ValueMetric}.
     * @return An immutable instance of ValueMetric
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ValueMetric build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ValueMetric(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      if ((initBits & INIT_BIT_UNIT) != 0) attributes.add("unit");
      if ((initBits & INIT_BIT_VALUE) != 0) attributes.add("value");
      return "Cannot build ValueMetric, some of required attributes are not set " + attributes;
    }
  }
}
