// Code generated by Wire protocol buffer compiler, do not edit.
// Source file: metric.proto
package org.cloudfoundry.dropsonde.events;

import com.squareup.wire.FieldEncoding;
import com.squareup.wire.Message;
import com.squareup.wire.ProtoAdapter;
import com.squareup.wire.ProtoReader;
import com.squareup.wire.ProtoWriter;
import com.squareup.wire.WireField;
import com.squareup.wire.internal.Internal;
import java.io.IOException;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import okio.ByteString;

/**
 * / A CounterEvent represents the increment of a counter. It contains only the change in the value; it is the responsibility of downstream consumers to maintain the value of the counter.
 */
public final class CounterEvent extends Message<CounterEvent, CounterEvent.Builder> {
  public static final ProtoAdapter<CounterEvent> ADAPTER = new ProtoAdapter_CounterEvent();

  private static final long serialVersionUID = 0L;

  public static final String DEFAULT_NAME = "";

  public static final Long DEFAULT_DELTA = 0L;

  public static final Long DEFAULT_TOTAL = 0L;

  /**
   * / Name of the counter. Must be consistent for downstream consumers to associate events semantically.
   */
  @WireField(
      tag = 1,
      adapter = "com.squareup.wire.ProtoAdapter#STRING",
      label = WireField.Label.REQUIRED
  )
  public final String name;

  /**
   * / Amount by which to increment the counter.
   */
  @WireField(
      tag = 2,
      adapter = "com.squareup.wire.ProtoAdapter#UINT64",
      label = WireField.Label.REQUIRED
  )
  public final Long delta;

  /**
   * / Total value of the counter. This will be overridden by Metron, which internally tracks the total of each named Counter it receives.
   */
  @WireField(
      tag = 3,
      adapter = "com.squareup.wire.ProtoAdapter#UINT64"
  )
  public final Long total;

  public CounterEvent(String name, Long delta, Long total) {
    this(name, delta, total, ByteString.EMPTY);
  }

  public CounterEvent(String name, Long delta, Long total, ByteString unknownFields) {
    super(ADAPTER, unknownFields);
    this.name = name;
    this.delta = delta;
    this.total = total;
  }

  @Override
  public Builder newBuilder() {
    Builder builder = new Builder();
    builder.name = name;
    builder.delta = delta;
    builder.total = total;
    builder.addUnknownFields(unknownFields());
    return builder;
  }

  @Override
  public boolean equals(Object other) {
    if (other == this) return true;
    if (!(other instanceof CounterEvent)) return false;
    CounterEvent o = (CounterEvent) other;
    return unknownFields().equals(o.unknownFields())
        && name.equals(o.name)
        && delta.equals(o.delta)
        && Internal.equals(total, o.total);
  }

  @Override
  public int hashCode() {
    int result = super.hashCode;
    if (result == 0) {
      result = unknownFields().hashCode();
      result = result * 37 + name.hashCode();
      result = result * 37 + delta.hashCode();
      result = result * 37 + (total != null ? total.hashCode() : 0);
      super.hashCode = result;
    }
    return result;
  }

  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder();
    builder.append(", name=").append(name);
    builder.append(", delta=").append(delta);
    if (total != null) builder.append(", total=").append(total);
    return builder.replace(0, 2, "CounterEvent{").append('}').toString();
  }

  public static final class Builder extends Message.Builder<CounterEvent, Builder> {
    public String name;

    public Long delta;

    public Long total;

    public Builder() {
    }

    /**
     * / Name of the counter. Must be consistent for downstream consumers to associate events semantically.
     */
    public Builder name(String name) {
      this.name = name;
      return this;
    }

    /**
     * / Amount by which to increment the counter.
     */
    public Builder delta(Long delta) {
      this.delta = delta;
      return this;
    }

    /**
     * / Total value of the counter. This will be overridden by Metron, which internally tracks the total of each named Counter it receives.
     */
    public Builder total(Long total) {
      this.total = total;
      return this;
    }

    @Override
    public CounterEvent build() {
      if (name == null
          || delta == null) {
        throw Internal.missingRequiredFields(name, "name",
            delta, "delta");
      }
      return new CounterEvent(name, delta, total, super.buildUnknownFields());
    }
  }

  private static final class ProtoAdapter_CounterEvent extends ProtoAdapter<CounterEvent> {
    public ProtoAdapter_CounterEvent() {
      super(FieldEncoding.LENGTH_DELIMITED, CounterEvent.class);
    }

    @Override
    public int encodedSize(CounterEvent value) {
      return ProtoAdapter.STRING.encodedSizeWithTag(1, value.name)
          + ProtoAdapter.UINT64.encodedSizeWithTag(2, value.delta)
          + ProtoAdapter.UINT64.encodedSizeWithTag(3, value.total)
          + value.unknownFields().size();
    }

    @Override
    public void encode(ProtoWriter writer, CounterEvent value) throws IOException {
      ProtoAdapter.STRING.encodeWithTag(writer, 1, value.name);
      ProtoAdapter.UINT64.encodeWithTag(writer, 2, value.delta);
      ProtoAdapter.UINT64.encodeWithTag(writer, 3, value.total);
      writer.writeBytes(value.unknownFields());
    }

    @Override
    public CounterEvent decode(ProtoReader reader) throws IOException {
      Builder builder = new Builder();
      long token = reader.beginMessage();
      for (int tag; (tag = reader.nextTag()) != -1;) {
        switch (tag) {
          case 1: builder.name(ProtoAdapter.STRING.decode(reader)); break;
          case 2: builder.delta(ProtoAdapter.UINT64.decode(reader)); break;
          case 3: builder.total(ProtoAdapter.UINT64.decode(reader)); break;
          default: {
            reader.readUnknownField(tag);
          }
        }
      }
      builder.addUnknownFields(reader.endMessageAndGetUnknownFields(token));
      return builder.build();
    }

    @Override
    public CounterEvent redact(CounterEvent value) {
      Builder builder = value.newBuilder();
      builder.clearUnknownFields();
      return builder.build();
    }
  }
}
