// Code generated by Wire protocol buffer compiler, do not edit.
// Source file: envelope.proto
package org.cloudfoundry.dropsonde.events;

import com.squareup.wire.EnumAdapter;
import com.squareup.wire.FieldEncoding;
import com.squareup.wire.Message;
import com.squareup.wire.ProtoAdapter;
import com.squareup.wire.ProtoReader;
import com.squareup.wire.ProtoWriter;
import com.squareup.wire.WireEnum;
import com.squareup.wire.WireField;
import com.squareup.wire.internal.Internal;
import java.io.IOException;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Map;
import okio.ByteString;

/**
 * / Envelope wraps an Event and adds metadata.
 */
public final class Envelope extends Message<Envelope, Envelope.Builder> {
  public static final ProtoAdapter<Envelope> ADAPTER = new ProtoAdapter_Envelope();

  private static final long serialVersionUID = 0L;

  public static final String DEFAULT_ORIGIN = "";

  public static final EventType DEFAULT_EVENTTYPE = EventType.HttpStartStop;

  public static final Long DEFAULT_TIMESTAMP = 0L;

  public static final String DEFAULT_DEPLOYMENT = "";

  public static final String DEFAULT_JOB = "";

  public static final String DEFAULT_INDEX = "";

  public static final String DEFAULT_IP = "";

  /**
   * / Unique description of the origin of this event.
   */
  @WireField(
      tag = 1,
      adapter = "com.squareup.wire.ProtoAdapter#STRING",
      label = WireField.Label.REQUIRED
  )
  public final String origin;

  /**
   * / Type of wrapped event. Only the optional field corresponding to the value of eventType should be set.
   */
  @WireField(
      tag = 2,
      adapter = "org.cloudfoundry.dropsonde.events.Envelope$EventType#ADAPTER",
      label = WireField.Label.REQUIRED
  )
  public final EventType eventType;

  /**
   * / UNIX timestamp (in nanoseconds) event was wrapped in this Envelope.
   */
  @WireField(
      tag = 6,
      adapter = "com.squareup.wire.ProtoAdapter#INT64"
  )
  public final Long timestamp;

  /**
   * / Deployment name (used to uniquely identify source).
   */
  @WireField(
      tag = 13,
      adapter = "com.squareup.wire.ProtoAdapter#STRING"
  )
  public final String deployment;

  /**
   * / Job name (used to uniquely identify source).
   */
  @WireField(
      tag = 14,
      adapter = "com.squareup.wire.ProtoAdapter#STRING"
  )
  public final String job;

  /**
   * / Index of job (used to uniquely identify source).
   */
  @WireField(
      tag = 15,
      adapter = "com.squareup.wire.ProtoAdapter#STRING"
  )
  public final String index;

  /**
   * / IP address (used to uniquely identify source).
   */
  @WireField(
      tag = 16,
      adapter = "com.squareup.wire.ProtoAdapter#STRING"
  )
  public final String ip;

  /**
   * / key/value tags to include additional identifying information.
   */
  @WireField(
      tag = 17,
      keyAdapter = "com.squareup.wire.ProtoAdapter#STRING",
      adapter = "com.squareup.wire.ProtoAdapter#STRING"
  )
  public final Map<String, String> tags;

  /**
   * Removed Heartbeat at position 3
   * Removed HttpStart at position 4
   * Removed HttpStop at position 5
   */
  @WireField(
      tag = 7,
      adapter = "org.cloudfoundry.dropsonde.events.HttpStartStop#ADAPTER"
  )
  public final HttpStartStop httpStartStop;

  @WireField(
      tag = 8,
      adapter = "org.cloudfoundry.dropsonde.events.LogMessage#ADAPTER"
  )
  public final LogMessage logMessage;

  @WireField(
      tag = 9,
      adapter = "org.cloudfoundry.dropsonde.events.ValueMetric#ADAPTER"
  )
  public final ValueMetric valueMetric;

  @WireField(
      tag = 10,
      adapter = "org.cloudfoundry.dropsonde.events.CounterEvent#ADAPTER"
  )
  public final CounterEvent counterEvent;

  @WireField(
      tag = 11,
      adapter = "org.cloudfoundry.dropsonde.events.Error#ADAPTER"
  )
  public final Error error;

  @WireField(
      tag = 12,
      adapter = "org.cloudfoundry.dropsonde.events.ContainerMetric#ADAPTER"
  )
  public final ContainerMetric containerMetric;

  public Envelope(String origin, EventType eventType, Long timestamp, String deployment, String job,
      String index, String ip, Map<String, String> tags, HttpStartStop httpStartStop,
      LogMessage logMessage, ValueMetric valueMetric, CounterEvent counterEvent, Error error,
      ContainerMetric containerMetric) {
    this(origin, eventType, timestamp, deployment, job, index, ip, tags, httpStartStop, logMessage, valueMetric, counterEvent, error, containerMetric, ByteString.EMPTY);
  }

  public Envelope(String origin, EventType eventType, Long timestamp, String deployment, String job,
      String index, String ip, Map<String, String> tags, HttpStartStop httpStartStop,
      LogMessage logMessage, ValueMetric valueMetric, CounterEvent counterEvent, Error error,
      ContainerMetric containerMetric, ByteString unknownFields) {
    super(ADAPTER, unknownFields);
    this.origin = origin;
    this.eventType = eventType;
    this.timestamp = timestamp;
    this.deployment = deployment;
    this.job = job;
    this.index = index;
    this.ip = ip;
    this.tags = Internal.immutableCopyOf("tags", tags);
    this.httpStartStop = httpStartStop;
    this.logMessage = logMessage;
    this.valueMetric = valueMetric;
    this.counterEvent = counterEvent;
    this.error = error;
    this.containerMetric = containerMetric;
  }

  @Override
  public Builder newBuilder() {
    Builder builder = new Builder();
    builder.origin = origin;
    builder.eventType = eventType;
    builder.timestamp = timestamp;
    builder.deployment = deployment;
    builder.job = job;
    builder.index = index;
    builder.ip = ip;
    builder.tags = Internal.copyOf(tags);
    builder.httpStartStop = httpStartStop;
    builder.logMessage = logMessage;
    builder.valueMetric = valueMetric;
    builder.counterEvent = counterEvent;
    builder.error = error;
    builder.containerMetric = containerMetric;
    builder.addUnknownFields(unknownFields());
    return builder;
  }

  @Override
  public boolean equals(Object other) {
    if (other == this) return true;
    if (!(other instanceof Envelope)) return false;
    Envelope o = (Envelope) other;
    return unknownFields().equals(o.unknownFields())
        && origin.equals(o.origin)
        && eventType.equals(o.eventType)
        && Internal.equals(timestamp, o.timestamp)
        && Internal.equals(deployment, o.deployment)
        && Internal.equals(job, o.job)
        && Internal.equals(index, o.index)
        && Internal.equals(ip, o.ip)
        && tags.equals(o.tags)
        && Internal.equals(httpStartStop, o.httpStartStop)
        && Internal.equals(logMessage, o.logMessage)
        && Internal.equals(valueMetric, o.valueMetric)
        && Internal.equals(counterEvent, o.counterEvent)
        && Internal.equals(error, o.error)
        && Internal.equals(containerMetric, o.containerMetric);
  }

  @Override
  public int hashCode() {
    int result = super.hashCode;
    if (result == 0) {
      result = unknownFields().hashCode();
      result = result * 37 + origin.hashCode();
      result = result * 37 + eventType.hashCode();
      result = result * 37 + (timestamp != null ? timestamp.hashCode() : 0);
      result = result * 37 + (deployment != null ? deployment.hashCode() : 0);
      result = result * 37 + (job != null ? job.hashCode() : 0);
      result = result * 37 + (index != null ? index.hashCode() : 0);
      result = result * 37 + (ip != null ? ip.hashCode() : 0);
      result = result * 37 + tags.hashCode();
      result = result * 37 + (httpStartStop != null ? httpStartStop.hashCode() : 0);
      result = result * 37 + (logMessage != null ? logMessage.hashCode() : 0);
      result = result * 37 + (valueMetric != null ? valueMetric.hashCode() : 0);
      result = result * 37 + (counterEvent != null ? counterEvent.hashCode() : 0);
      result = result * 37 + (error != null ? error.hashCode() : 0);
      result = result * 37 + (containerMetric != null ? containerMetric.hashCode() : 0);
      super.hashCode = result;
    }
    return result;
  }

  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder();
    builder.append(", origin=").append(origin);
    builder.append(", eventType=").append(eventType);
    if (timestamp != null) builder.append(", timestamp=").append(timestamp);
    if (deployment != null) builder.append(", deployment=").append(deployment);
    if (job != null) builder.append(", job=").append(job);
    if (index != null) builder.append(", index=").append(index);
    if (ip != null) builder.append(", ip=").append(ip);
    if (!tags.isEmpty()) builder.append(", tags=").append(tags);
    if (httpStartStop != null) builder.append(", httpStartStop=").append(httpStartStop);
    if (logMessage != null) builder.append(", logMessage=").append(logMessage);
    if (valueMetric != null) builder.append(", valueMetric=").append(valueMetric);
    if (counterEvent != null) builder.append(", counterEvent=").append(counterEvent);
    if (error != null) builder.append(", error=").append(error);
    if (containerMetric != null) builder.append(", containerMetric=").append(containerMetric);
    return builder.replace(0, 2, "Envelope{").append('}').toString();
  }

  public static final class Builder extends Message.Builder<Envelope, Builder> {
    public String origin;

    public EventType eventType;

    public Long timestamp;

    public String deployment;

    public String job;

    public String index;

    public String ip;

    public Map<String, String> tags;

    public HttpStartStop httpStartStop;

    public LogMessage logMessage;

    public ValueMetric valueMetric;

    public CounterEvent counterEvent;

    public Error error;

    public ContainerMetric containerMetric;

    public Builder() {
      tags = Internal.newMutableMap();
    }

    /**
     * / Unique description of the origin of this event.
     */
    public Builder origin(String origin) {
      this.origin = origin;
      return this;
    }

    /**
     * / Type of wrapped event. Only the optional field corresponding to the value of eventType should be set.
     */
    public Builder eventType(EventType eventType) {
      this.eventType = eventType;
      return this;
    }

    /**
     * / UNIX timestamp (in nanoseconds) event was wrapped in this Envelope.
     */
    public Builder timestamp(Long timestamp) {
      this.timestamp = timestamp;
      return this;
    }

    /**
     * / Deployment name (used to uniquely identify source).
     */
    public Builder deployment(String deployment) {
      this.deployment = deployment;
      return this;
    }

    /**
     * / Job name (used to uniquely identify source).
     */
    public Builder job(String job) {
      this.job = job;
      return this;
    }

    /**
     * / Index of job (used to uniquely identify source).
     */
    public Builder index(String index) {
      this.index = index;
      return this;
    }

    /**
     * / IP address (used to uniquely identify source).
     */
    public Builder ip(String ip) {
      this.ip = ip;
      return this;
    }

    /**
     * / key/value tags to include additional identifying information.
     */
    public Builder tags(Map<String, String> tags) {
      Internal.checkElementsNotNull(tags);
      this.tags = tags;
      return this;
    }

    /**
     * Removed Heartbeat at position 3
     * Removed HttpStart at position 4
     * Removed HttpStop at position 5
     */
    public Builder httpStartStop(HttpStartStop httpStartStop) {
      this.httpStartStop = httpStartStop;
      return this;
    }

    public Builder logMessage(LogMessage logMessage) {
      this.logMessage = logMessage;
      return this;
    }

    public Builder valueMetric(ValueMetric valueMetric) {
      this.valueMetric = valueMetric;
      return this;
    }

    public Builder counterEvent(CounterEvent counterEvent) {
      this.counterEvent = counterEvent;
      return this;
    }

    public Builder error(Error error) {
      this.error = error;
      return this;
    }

    public Builder containerMetric(ContainerMetric containerMetric) {
      this.containerMetric = containerMetric;
      return this;
    }

    @Override
    public Envelope build() {
      if (origin == null
          || eventType == null) {
        throw Internal.missingRequiredFields(origin, "origin",
            eventType, "eventType");
      }
      return new Envelope(origin, eventType, timestamp, deployment, job, index, ip, tags, httpStartStop, logMessage, valueMetric, counterEvent, error, containerMetric, super.buildUnknownFields());
    }
  }

  /**
   * / Type of the wrapped event.
   */
  public enum EventType implements WireEnum {
    /**
     * Removed Heartbeat at position 1
     * Removed HttpStart at position 2
     * Removed HttpStop at position 3
     */
    HttpStartStop(4),

    LogMessage(5),

    ValueMetric(6),

    CounterEvent(7),

    Error(8),

    ContainerMetric(9);

    public static final ProtoAdapter<EventType> ADAPTER = new ProtoAdapter_EventType();

    private final int value;

    EventType(int value) {
      this.value = value;
    }

    /**
     * Return the constant for {@code value} or null.
     */
    public static EventType fromValue(int value) {
      switch (value) {
        case 4: return HttpStartStop;
        case 5: return LogMessage;
        case 6: return ValueMetric;
        case 7: return CounterEvent;
        case 8: return Error;
        case 9: return ContainerMetric;
        default: return null;
      }
    }

    @Override
    public int getValue() {
      return value;
    }

    private static final class ProtoAdapter_EventType extends EnumAdapter<EventType> {
      ProtoAdapter_EventType() {
        super(EventType.class);
      }

      @Override
      protected EventType fromValue(int value) {
        return EventType.fromValue(value);
      }
    }
  }

  private static final class ProtoAdapter_Envelope extends ProtoAdapter<Envelope> {
    private final ProtoAdapter<Map<String, String>> tags = ProtoAdapter.newMapAdapter(ProtoAdapter.STRING, ProtoAdapter.STRING);

    public ProtoAdapter_Envelope() {
      super(FieldEncoding.LENGTH_DELIMITED, Envelope.class);
    }

    @Override
    public int encodedSize(Envelope value) {
      return ProtoAdapter.STRING.encodedSizeWithTag(1, value.origin)
          + EventType.ADAPTER.encodedSizeWithTag(2, value.eventType)
          + ProtoAdapter.INT64.encodedSizeWithTag(6, value.timestamp)
          + ProtoAdapter.STRING.encodedSizeWithTag(13, value.deployment)
          + ProtoAdapter.STRING.encodedSizeWithTag(14, value.job)
          + ProtoAdapter.STRING.encodedSizeWithTag(15, value.index)
          + ProtoAdapter.STRING.encodedSizeWithTag(16, value.ip)
          + tags.encodedSizeWithTag(17, value.tags)
          + HttpStartStop.ADAPTER.encodedSizeWithTag(7, value.httpStartStop)
          + LogMessage.ADAPTER.encodedSizeWithTag(8, value.logMessage)
          + ValueMetric.ADAPTER.encodedSizeWithTag(9, value.valueMetric)
          + CounterEvent.ADAPTER.encodedSizeWithTag(10, value.counterEvent)
          + Error.ADAPTER.encodedSizeWithTag(11, value.error)
          + ContainerMetric.ADAPTER.encodedSizeWithTag(12, value.containerMetric)
          + value.unknownFields().size();
    }

    @Override
    public void encode(ProtoWriter writer, Envelope value) throws IOException {
      ProtoAdapter.STRING.encodeWithTag(writer, 1, value.origin);
      EventType.ADAPTER.encodeWithTag(writer, 2, value.eventType);
      ProtoAdapter.INT64.encodeWithTag(writer, 6, value.timestamp);
      ProtoAdapter.STRING.encodeWithTag(writer, 13, value.deployment);
      ProtoAdapter.STRING.encodeWithTag(writer, 14, value.job);
      ProtoAdapter.STRING.encodeWithTag(writer, 15, value.index);
      ProtoAdapter.STRING.encodeWithTag(writer, 16, value.ip);
      tags.encodeWithTag(writer, 17, value.tags);
      HttpStartStop.ADAPTER.encodeWithTag(writer, 7, value.httpStartStop);
      LogMessage.ADAPTER.encodeWithTag(writer, 8, value.logMessage);
      ValueMetric.ADAPTER.encodeWithTag(writer, 9, value.valueMetric);
      CounterEvent.ADAPTER.encodeWithTag(writer, 10, value.counterEvent);
      Error.ADAPTER.encodeWithTag(writer, 11, value.error);
      ContainerMetric.ADAPTER.encodeWithTag(writer, 12, value.containerMetric);
      writer.writeBytes(value.unknownFields());
    }

    @Override
    public Envelope decode(ProtoReader reader) throws IOException {
      Builder builder = new Builder();
      long token = reader.beginMessage();
      for (int tag; (tag = reader.nextTag()) != -1;) {
        switch (tag) {
          case 1: builder.origin(ProtoAdapter.STRING.decode(reader)); break;
          case 2: {
            try {
              builder.eventType(EventType.ADAPTER.decode(reader));
            } catch (ProtoAdapter.EnumConstantNotFoundException e) {
              builder.addUnknownField(tag, FieldEncoding.VARINT, (long) e.value);
            }
            break;
          }
          case 6: builder.timestamp(ProtoAdapter.INT64.decode(reader)); break;
          case 7: builder.httpStartStop(HttpStartStop.ADAPTER.decode(reader)); break;
          case 8: builder.logMessage(LogMessage.ADAPTER.decode(reader)); break;
          case 9: builder.valueMetric(ValueMetric.ADAPTER.decode(reader)); break;
          case 10: builder.counterEvent(CounterEvent.ADAPTER.decode(reader)); break;
          case 11: builder.error(Error.ADAPTER.decode(reader)); break;
          case 12: builder.containerMetric(ContainerMetric.ADAPTER.decode(reader)); break;
          case 13: builder.deployment(ProtoAdapter.STRING.decode(reader)); break;
          case 14: builder.job(ProtoAdapter.STRING.decode(reader)); break;
          case 15: builder.index(ProtoAdapter.STRING.decode(reader)); break;
          case 16: builder.ip(ProtoAdapter.STRING.decode(reader)); break;
          case 17: builder.tags.putAll(tags.decode(reader)); break;
          default: {
            reader.readUnknownField(tag);
          }
        }
      }
      builder.addUnknownFields(reader.endMessageAndGetUnknownFields(token));
      return builder.build();
    }

    @Override
    public Envelope redact(Envelope value) {
      Builder builder = value.newBuilder();
      if (builder.httpStartStop != null) builder.httpStartStop = HttpStartStop.ADAPTER.redact(builder.httpStartStop);
      if (builder.logMessage != null) builder.logMessage = LogMessage.ADAPTER.redact(builder.logMessage);
      if (builder.valueMetric != null) builder.valueMetric = ValueMetric.ADAPTER.redact(builder.valueMetric);
      if (builder.counterEvent != null) builder.counterEvent = CounterEvent.ADAPTER.redact(builder.counterEvent);
      if (builder.error != null) builder.error = Error.ADAPTER.redact(builder.error);
      if (builder.containerMetric != null) builder.containerMetric = ContainerMetric.ADAPTER.redact(builder.containerMetric);
      builder.clearUnknownFields();
      return builder.build();
    }
  }
}
