// Code generated by Wire protocol buffer compiler, do not edit.
// Source file: error.proto
package org.cloudfoundry.dropsonde.events;

import com.squareup.wire.FieldEncoding;
import com.squareup.wire.Message;
import com.squareup.wire.ProtoAdapter;
import com.squareup.wire.ProtoReader;
import com.squareup.wire.ProtoWriter;
import com.squareup.wire.WireField;
import com.squareup.wire.internal.Internal;
import java.io.IOException;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import okio.ByteString;

/**
 * / An Error event represents an error in the originating process.
 */
public final class Error extends Message<Error, Error.Builder> {
  public static final ProtoAdapter<Error> ADAPTER = new ProtoAdapter_Error();

  private static final long serialVersionUID = 0L;

  public static final String DEFAULT_SOURCE = "";

  public static final Integer DEFAULT_CODE = 0;

  public static final String DEFAULT_MESSAGE = "";

  /**
   * / Source of the error. This may or may not be the same as the Origin in the envelope.
   */
  @WireField(
      tag = 1,
      adapter = "com.squareup.wire.ProtoAdapter#STRING",
      label = WireField.Label.REQUIRED
  )
  public final String source;

  /**
   * / Numeric error code. This is provided for programmatic responses to the error.
   */
  @WireField(
      tag = 2,
      adapter = "com.squareup.wire.ProtoAdapter#INT32",
      label = WireField.Label.REQUIRED
  )
  public final Integer code;

  /**
   * / Error description (preferably human-readable).
   */
  @WireField(
      tag = 3,
      adapter = "com.squareup.wire.ProtoAdapter#STRING",
      label = WireField.Label.REQUIRED
  )
  public final String message;

  public Error(String source, Integer code, String message) {
    this(source, code, message, ByteString.EMPTY);
  }

  public Error(String source, Integer code, String message, ByteString unknownFields) {
    super(ADAPTER, unknownFields);
    this.source = source;
    this.code = code;
    this.message = message;
  }

  @Override
  public Builder newBuilder() {
    Builder builder = new Builder();
    builder.source = source;
    builder.code = code;
    builder.message = message;
    builder.addUnknownFields(unknownFields());
    return builder;
  }

  @Override
  public boolean equals(Object other) {
    if (other == this) return true;
    if (!(other instanceof Error)) return false;
    Error o = (Error) other;
    return unknownFields().equals(o.unknownFields())
        && source.equals(o.source)
        && code.equals(o.code)
        && message.equals(o.message);
  }

  @Override
  public int hashCode() {
    int result = super.hashCode;
    if (result == 0) {
      result = unknownFields().hashCode();
      result = result * 37 + source.hashCode();
      result = result * 37 + code.hashCode();
      result = result * 37 + message.hashCode();
      super.hashCode = result;
    }
    return result;
  }

  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder();
    builder.append(", source=").append(source);
    builder.append(", code=").append(code);
    builder.append(", message=").append(message);
    return builder.replace(0, 2, "Error{").append('}').toString();
  }

  public static final class Builder extends Message.Builder<Error, Builder> {
    public String source;

    public Integer code;

    public String message;

    public Builder() {
    }

    /**
     * / Source of the error. This may or may not be the same as the Origin in the envelope.
     */
    public Builder source(String source) {
      this.source = source;
      return this;
    }

    /**
     * / Numeric error code. This is provided for programmatic responses to the error.
     */
    public Builder code(Integer code) {
      this.code = code;
      return this;
    }

    /**
     * / Error description (preferably human-readable).
     */
    public Builder message(String message) {
      this.message = message;
      return this;
    }

    @Override
    public Error build() {
      if (source == null
          || code == null
          || message == null) {
        throw Internal.missingRequiredFields(source, "source",
            code, "code",
            message, "message");
      }
      return new Error(source, code, message, super.buildUnknownFields());
    }
  }

  private static final class ProtoAdapter_Error extends ProtoAdapter<Error> {
    public ProtoAdapter_Error() {
      super(FieldEncoding.LENGTH_DELIMITED, Error.class);
    }

    @Override
    public int encodedSize(Error value) {
      return ProtoAdapter.STRING.encodedSizeWithTag(1, value.source)
          + ProtoAdapter.INT32.encodedSizeWithTag(2, value.code)
          + ProtoAdapter.STRING.encodedSizeWithTag(3, value.message)
          + value.unknownFields().size();
    }

    @Override
    public void encode(ProtoWriter writer, Error value) throws IOException {
      ProtoAdapter.STRING.encodeWithTag(writer, 1, value.source);
      ProtoAdapter.INT32.encodeWithTag(writer, 2, value.code);
      ProtoAdapter.STRING.encodeWithTag(writer, 3, value.message);
      writer.writeBytes(value.unknownFields());
    }

    @Override
    public Error decode(ProtoReader reader) throws IOException {
      Builder builder = new Builder();
      long token = reader.beginMessage();
      for (int tag; (tag = reader.nextTag()) != -1;) {
        switch (tag) {
          case 1: builder.source(ProtoAdapter.STRING.decode(reader)); break;
          case 2: builder.code(ProtoAdapter.INT32.decode(reader)); break;
          case 3: builder.message(ProtoAdapter.STRING.decode(reader)); break;
          default: {
            reader.readUnknownField(tag);
          }
        }
      }
      builder.addUnknownFields(reader.endMessageAndGetUnknownFields(token));
      return builder.build();
    }

    @Override
    public Error redact(Error value) {
      Builder builder = value.newBuilder();
      builder.clearUnknownFields();
      return builder.build();
    }
  }
}
