package org.cloudfoundry.logcache.v1;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link _Counter}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code Counter.builder()}.
 */
@Generated(from = "_Counter", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class Counter extends org.cloudfoundry.logcache.v1._Counter {
  private final @Nullable Long delta;
  private final @Nullable String name;
  private final @Nullable Long total;

  private Counter(Counter.Builder builder) {
    this.delta = builder.delta;
    this.name = builder.name;
    this.total = builder.total;
  }

  /**
   * The amount by which to increment the counter
   */
  @JsonProperty("delta")
  @Override
  public @Nullable Long getDelta() {
    return delta;
  }

  /**
   * The name of the counter. Must be consistent for downstream consumers to associate events semantically.
   */
  @JsonProperty("name")
  @Override
  public @Nullable String getName() {
    return name;
  }

  /**
   * The total value of the counter. This will be overridden by Metron, which internally tracks the total of each named Counter it receives.
   */
  @JsonProperty("total")
  @Override
  public @Nullable Long getTotal() {
    return total;
  }

  /**
   * This instance is equal to all instances of {@code Counter} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof Counter
        && equalTo(0, (Counter) another);
  }

  private boolean equalTo(int synthetic, Counter another) {
    return Objects.equals(delta, another.delta)
        && Objects.equals(name, another.name)
        && Objects.equals(total, another.total);
  }

  /**
   * Computes a hash code from attributes: {@code delta}, {@code name}, {@code total}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(delta);
    h += (h << 5) + Objects.hashCode(name);
    h += (h << 5) + Objects.hashCode(total);
    return h;
  }

  /**
   * Prints the immutable value {@code Counter} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Counter{"
        + "delta=" + delta
        + ", name=" + name
        + ", total=" + total
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_Counter", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.logcache.v1._Counter {
    Long delta;
    String name;
    Long total;
    @JsonProperty("delta")
    public void setDelta(@Nullable Long delta) {
      this.delta = delta;
    }
    @JsonProperty("name")
    public void setName(@Nullable String name) {
      this.name = name;
    }
    @JsonProperty("total")
    public void setTotal(@Nullable Long total) {
      this.total = total;
    }
    @Override
    public Long getDelta() { throw new UnsupportedOperationException(); }
    @Override
    public String getName() { throw new UnsupportedOperationException(); }
    @Override
    public Long getTotal() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static Counter fromJson(Json json) {
    Counter.Builder builder = Counter.builder();
    if (json.delta != null) {
      builder.delta(json.delta);
    }
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.total != null) {
      builder.total(json.total);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link Counter Counter}.
   * <pre>
   * Counter.builder()
   *    .delta(Long | null) // nullable {@link Counter#getDelta() delta}
   *    .name(String | null) // nullable {@link Counter#getName() name}
   *    .total(Long | null) // nullable {@link Counter#getTotal() total}
   *    .build();
   * </pre>
   * @return A new Counter builder
   */
  public static Counter.Builder builder() {
    return new Counter.Builder();
  }

  /**
   * Builds instances of type {@link Counter Counter}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_Counter", generator = "Immutables")
  public static final class Builder {
    private Long delta;
    private String name;
    private Long total;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Counter} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Counter instance) {
      return from((_Counter) instance);
    }

    /**
     * Copy abstract value type {@code _Counter} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_Counter instance) {
      Objects.requireNonNull(instance, "instance");
      Long deltaValue = instance.getDelta();
      if (deltaValue != null) {
        delta(deltaValue);
      }
      String nameValue = instance.getName();
      if (nameValue != null) {
        name(nameValue);
      }
      Long totalValue = instance.getTotal();
      if (totalValue != null) {
        total(totalValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link Counter#getDelta() delta} attribute.
     * @param delta The value for delta (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("delta")
    public final Builder delta(@Nullable Long delta) {
      this.delta = delta;
      return this;
    }

    /**
     * Initializes the value for the {@link Counter#getName() name} attribute.
     * @param name The value for name (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("name")
    public final Builder name(@Nullable String name) {
      this.name = name;
      return this;
    }

    /**
     * Initializes the value for the {@link Counter#getTotal() total} attribute.
     * @param total The value for total (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("total")
    public final Builder total(@Nullable Long total) {
      this.total = total;
      return this;
    }

    /**
     * Builds a new {@link Counter Counter}.
     * @return An immutable instance of Counter
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public Counter build() {
      return new Counter(this);
    }
  }
}
