package org.cloudfoundry.logcache.v1;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link _EnvelopeBatch}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code EnvelopeBatch.builder()}.
 */
@Generated(from = "_EnvelopeBatch", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class EnvelopeBatch extends org.cloudfoundry.logcache.v1._EnvelopeBatch {
  private final List<Envelope> batch;

  private EnvelopeBatch(EnvelopeBatch.Builder builder) {
    this.batch = createUnmodifiableList(true, builder.batch);
  }

  /**
   * The batch
   */
  @JsonProperty("batch")
  @Override
  public List<Envelope> getBatch() {
    return batch;
  }

  /**
   * This instance is equal to all instances of {@code EnvelopeBatch} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof EnvelopeBatch
        && equalTo(0, (EnvelopeBatch) another);
  }

  private boolean equalTo(int synthetic, EnvelopeBatch another) {
    return batch.equals(another.batch);
  }

  /**
   * Computes a hash code from attributes: {@code batch}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + batch.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code EnvelopeBatch} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "EnvelopeBatch{"
        + "batch=" + batch
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_EnvelopeBatch", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.logcache.v1._EnvelopeBatch {
    List<Envelope> batch = Collections.emptyList();
    @JsonProperty("batch")
    public void setBatch(List<Envelope> batch) {
      this.batch = batch;
    }
    @Override
    public List<Envelope> getBatch() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static EnvelopeBatch fromJson(Json json) {
    EnvelopeBatch.Builder builder = EnvelopeBatch.builder();
    if (json.batch != null) {
      builder.addAllBatch(json.batch);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link EnvelopeBatch EnvelopeBatch}.
   * <pre>
   * EnvelopeBatch.builder()
   *    .batch|addAllBatch(Envelope) // {@link EnvelopeBatch#getBatch() batch} elements
   *    .build();
   * </pre>
   * @return A new EnvelopeBatch builder
   */
  public static EnvelopeBatch.Builder builder() {
    return new EnvelopeBatch.Builder();
  }

  /**
   * Builds instances of type {@link EnvelopeBatch EnvelopeBatch}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_EnvelopeBatch", generator = "Immutables")
  public static final class Builder {
    private List<Envelope> batch = new ArrayList<Envelope>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code EnvelopeBatch} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(EnvelopeBatch instance) {
      return from((_EnvelopeBatch) instance);
    }

    /**
     * Copy abstract value type {@code _EnvelopeBatch} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_EnvelopeBatch instance) {
      Objects.requireNonNull(instance, "instance");
      addAllBatch(instance.getBatch());
      return this;
    }

    /**
     * Adds one element to {@link EnvelopeBatch#getBatch() batch} list.
     * @param element A batch element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder batch(Envelope element) {
      this.batch.add(Objects.requireNonNull(element, "batch element"));
      return this;
    }

    /**
     * Adds elements to {@link EnvelopeBatch#getBatch() batch} list.
     * @param elements An array of batch elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder batch(Envelope... elements) {
      for (Envelope element : elements) {
        this.batch.add(Objects.requireNonNull(element, "batch element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link EnvelopeBatch#getBatch() batch} list.
     * @param elements An iterable of batch elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("batch")
    public final Builder batch(Iterable<? extends Envelope> elements) {
      this.batch.clear();
      return addAllBatch(elements);
    }

    /**
     * Adds elements to {@link EnvelopeBatch#getBatch() batch} list.
     * @param elements An iterable of batch elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllBatch(Iterable<? extends Envelope> elements) {
      for (Envelope element : elements) {
        this.batch.add(Objects.requireNonNull(element, "batch element"));
      }
      return this;
    }

    /**
     * Builds a new {@link EnvelopeBatch EnvelopeBatch}.
     * @return An immutable instance of EnvelopeBatch
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public EnvelopeBatch build() {
      return new EnvelopeBatch(this);
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>(size);
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
