package org.cloudfoundry.logcache.v1;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.immutables.value.Generated;

/**
 * The response payload for the Info operation
 */
@Generated(from = "_InfoResponse", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class InfoResponse extends org.cloudfoundry.logcache.v1._InfoResponse {
  private final @Nullable String version;
  private final @Nullable Long vmUptime;

  private InfoResponse(InfoResponse.Builder builder) {
    this.version = builder.version;
    this.vmUptime = builder.vmUptime;
  }

  /**
   * The info version
   */
  @JsonProperty("version")
  @Override
  public @Nullable String getVersion() {
    return version;
  }

  /**
   * The vm uptime
   */
  @JsonProperty("vm_uptime")
  @Override
  public @Nullable Long vmUptime() {
    return vmUptime;
  }

  /**
   * This instance is equal to all instances of {@code InfoResponse} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof InfoResponse
        && equalTo(0, (InfoResponse) another);
  }

  private boolean equalTo(int synthetic, InfoResponse another) {
    return Objects.equals(version, another.version)
        && Objects.equals(vmUptime, another.vmUptime);
  }

  /**
   * Computes a hash code from attributes: {@code version}, {@code vmUptime}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(version);
    h += (h << 5) + Objects.hashCode(vmUptime);
    return h;
  }

  /**
   * Prints the immutable value {@code InfoResponse} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "InfoResponse{"
        + "version=" + version
        + ", vmUptime=" + vmUptime
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_InfoResponse", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.logcache.v1._InfoResponse {
    String version;
    Long vmUptime;
    @JsonProperty("version")
    public void setVersion(@Nullable String version) {
      this.version = version;
    }
    @JsonProperty("vm_uptime")
    public void setVmUptime(@Nullable Long vmUptime) {
      this.vmUptime = vmUptime;
    }
    @Override
    public String getVersion() { throw new UnsupportedOperationException(); }
    @Override
    public Long vmUptime() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static InfoResponse fromJson(Json json) {
    InfoResponse.Builder builder = InfoResponse.builder();
    if (json.version != null) {
      builder.version(json.version);
    }
    if (json.vmUptime != null) {
      builder.vmUptime(json.vmUptime);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link InfoResponse InfoResponse}.
   * <pre>
   * InfoResponse.builder()
   *    .version(String | null) // nullable {@link InfoResponse#getVersion() version}
   *    .vmUptime(Long | null) // nullable {@link InfoResponse#vmUptime() vmUptime}
   *    .build();
   * </pre>
   * @return A new InfoResponse builder
   */
  public static InfoResponse.Builder builder() {
    return new InfoResponse.Builder();
  }

  /**
   * Builds instances of type {@link InfoResponse InfoResponse}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_InfoResponse", generator = "Immutables")
  public static final class Builder {
    private String version;
    private Long vmUptime;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code InfoResponse} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(InfoResponse instance) {
      return from((_InfoResponse) instance);
    }

    /**
     * Copy abstract value type {@code _InfoResponse} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_InfoResponse instance) {
      Objects.requireNonNull(instance, "instance");
      String versionValue = instance.getVersion();
      if (versionValue != null) {
        version(versionValue);
      }
      Long vmUptimeValue = instance.vmUptime();
      if (vmUptimeValue != null) {
        vmUptime(vmUptimeValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link InfoResponse#getVersion() version} attribute.
     * @param version The value for version (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("version")
    public final Builder version(@Nullable String version) {
      this.version = version;
      return this;
    }

    /**
     * Initializes the value for the {@link InfoResponse#vmUptime() vmUptime} attribute.
     * @param vmUptime The value for vmUptime (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("vm_uptime")
    public final Builder vmUptime(@Nullable Long vmUptime) {
      this.vmUptime = vmUptime;
      return this;
    }

    /**
     * Builds a new {@link InfoResponse InfoResponse}.
     * @return An immutable instance of InfoResponse
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public InfoResponse build() {
      return new InfoResponse(this);
    }
  }
}
