package org.cloudfoundry.logcache.v1;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link _Metric}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code Metric.builder()}.
 */
@Generated(from = "_Metric", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class Metric extends org.cloudfoundry.logcache.v1._Metric {
  private final @Nullable String unit;
  private final @Nullable Double value;

  private Metric(Metric.Builder builder) {
    this.unit = builder.unit;
    this.value = builder.value;
  }

  /**
   * The metric unit
   */
  @JsonProperty("unit")
  @Override
  public @Nullable String getUnit() {
    return unit;
  }

  /**
   * The metric value
   */
  @JsonProperty("value")
  @Override
  public @Nullable Double getValue() {
    return value;
  }

  /**
   * This instance is equal to all instances of {@code Metric} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof Metric
        && equalTo(0, (Metric) another);
  }

  private boolean equalTo(int synthetic, Metric another) {
    return Objects.equals(unit, another.unit)
        && Objects.equals(value, another.value);
  }

  /**
   * Computes a hash code from attributes: {@code unit}, {@code value}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(unit);
    h += (h << 5) + Objects.hashCode(value);
    return h;
  }

  /**
   * Prints the immutable value {@code Metric} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Metric{"
        + "unit=" + unit
        + ", value=" + value
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_Metric", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.logcache.v1._Metric {
    String unit;
    Double value;
    @JsonProperty("unit")
    public void setUnit(@Nullable String unit) {
      this.unit = unit;
    }
    @JsonProperty("value")
    public void setValue(@Nullable Double value) {
      this.value = value;
    }
    @Override
    public String getUnit() { throw new UnsupportedOperationException(); }
    @Override
    public Double getValue() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static Metric fromJson(Json json) {
    Metric.Builder builder = Metric.builder();
    if (json.unit != null) {
      builder.unit(json.unit);
    }
    if (json.value != null) {
      builder.value(json.value);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link Metric Metric}.
   * <pre>
   * Metric.builder()
   *    .unit(String | null) // nullable {@link Metric#getUnit() unit}
   *    .value(Double | null) // nullable {@link Metric#getValue() value}
   *    .build();
   * </pre>
   * @return A new Metric builder
   */
  public static Metric.Builder builder() {
    return new Metric.Builder();
  }

  /**
   * Builds instances of type {@link Metric Metric}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_Metric", generator = "Immutables")
  public static final class Builder {
    private String unit;
    private Double value;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Metric} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Metric instance) {
      return from((_Metric) instance);
    }

    /**
     * Copy abstract value type {@code _Metric} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_Metric instance) {
      Objects.requireNonNull(instance, "instance");
      String unitValue = instance.getUnit();
      if (unitValue != null) {
        unit(unitValue);
      }
      Double valueValue = instance.getValue();
      if (valueValue != null) {
        value(valueValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link Metric#getUnit() unit} attribute.
     * @param unit The value for unit (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("unit")
    public final Builder unit(@Nullable String unit) {
      this.unit = unit;
      return this;
    }

    /**
     * Initializes the value for the {@link Metric#getValue() value} attribute.
     * @param value The value for value (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("value")
    public final Builder value(@Nullable Double value) {
      this.value = value;
      return this;
    }

    /**
     * Builds a new {@link Metric Metric}.
     * @return An immutable instance of Metric
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public Metric build() {
      return new Metric(this);
    }
  }
}
