package org.cloudfoundry.logcache.v1;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link _ReadResponse}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ReadResponse.builder()}.
 */
@Generated(from = "_ReadResponse", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ReadResponse extends org.cloudfoundry.logcache.v1._ReadResponse {
  private final EnvelopeBatch envelopes;

  private ReadResponse(ReadResponse.Builder builder) {
    this.envelopes = builder.envelopes != null
        ? builder.envelopes
        : Objects.requireNonNull(super.getEnvelopes(), "envelopes");
  }

  /**
   * The envelopes
   */
  @JsonProperty("envelopes")
  @Override
  public EnvelopeBatch getEnvelopes() {
    return envelopes;
  }

  /**
   * This instance is equal to all instances of {@code ReadResponse} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ReadResponse
        && equalTo(0, (ReadResponse) another);
  }

  private boolean equalTo(int synthetic, ReadResponse another) {
    return envelopes.equals(another.envelopes);
  }

  /**
   * Computes a hash code from attributes: {@code envelopes}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + envelopes.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ReadResponse} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ReadResponse{"
        + "envelopes=" + envelopes
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_ReadResponse", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.logcache.v1._ReadResponse {
    EnvelopeBatch envelopes;
    @JsonProperty("envelopes")
    public void setEnvelopes(EnvelopeBatch envelopes) {
      this.envelopes = envelopes;
    }
    @Override
    public EnvelopeBatch getEnvelopes() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ReadResponse fromJson(Json json) {
    ReadResponse.Builder builder = ReadResponse.builder();
    if (json.envelopes != null) {
      builder.envelopes(json.envelopes);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link ReadResponse ReadResponse}.
   * <pre>
   * ReadResponse.builder()
   *    .envelopes(org.cloudfoundry.logcache.v1.EnvelopeBatch) // optional {@link ReadResponse#getEnvelopes() envelopes}
   *    .build();
   * </pre>
   * @return A new ReadResponse builder
   */
  public static ReadResponse.Builder builder() {
    return new ReadResponse.Builder();
  }

  /**
   * Builds instances of type {@link ReadResponse ReadResponse}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_ReadResponse", generator = "Immutables")
  public static final class Builder {
    private EnvelopeBatch envelopes;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ReadResponse} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ReadResponse instance) {
      return from((_ReadResponse) instance);
    }

    /**
     * Copy abstract value type {@code _ReadResponse} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_ReadResponse instance) {
      Objects.requireNonNull(instance, "instance");
      this.envelopes(instance.getEnvelopes());
      return this;
    }

    /**
     * Initializes the value for the {@link ReadResponse#getEnvelopes() envelopes} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ReadResponse#getEnvelopes() envelopes}.</em>
     * @param envelopes The value for envelopes 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("envelopes")
    public final Builder envelopes(EnvelopeBatch envelopes) {
      this.envelopes = Objects.requireNonNull(envelopes, "envelopes");
      return this;
    }

    /**
     * Builds a new {@link ReadResponse ReadResponse}.
     * @return An immutable instance of ReadResponse
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ReadResponse build() {
      return new ReadResponse(this);
    }
  }
}
