package org.cloudfoundry.logcache.v1;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link _Timer}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code Timer.builder()}.
 */
@Generated(from = "_Timer", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class Timer extends org.cloudfoundry.logcache.v1._Timer {
  private final @Nullable String name;
  private final @Nullable Long start;
  private final @Nullable Long stop;

  private Timer(Timer.Builder builder) {
    this.name = builder.name;
    this.start = builder.start;
    this.stop = builder.stop;
  }

  /**
   * The timer name
   */
  @JsonProperty("name")
  @Override
  public @Nullable String getName() {
    return name;
  }

  /**
   * The timer start
   */
  @JsonProperty("start")
  @Override
  public @Nullable Long getStart() {
    return start;
  }

  /**
   * The timer stop
   */
  @JsonProperty("stop")
  @Override
  public @Nullable Long getStop() {
    return stop;
  }

  /**
   * This instance is equal to all instances of {@code Timer} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof Timer
        && equalTo(0, (Timer) another);
  }

  private boolean equalTo(int synthetic, Timer another) {
    return Objects.equals(name, another.name)
        && Objects.equals(start, another.start)
        && Objects.equals(stop, another.stop);
  }

  /**
   * Computes a hash code from attributes: {@code name}, {@code start}, {@code stop}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(name);
    h += (h << 5) + Objects.hashCode(start);
    h += (h << 5) + Objects.hashCode(stop);
    return h;
  }

  /**
   * Prints the immutable value {@code Timer} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Timer{"
        + "name=" + name
        + ", start=" + start
        + ", stop=" + stop
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_Timer", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.logcache.v1._Timer {
    String name;
    Long start;
    Long stop;
    @JsonProperty("name")
    public void setName(@Nullable String name) {
      this.name = name;
    }
    @JsonProperty("start")
    public void setStart(@Nullable Long start) {
      this.start = start;
    }
    @JsonProperty("stop")
    public void setStop(@Nullable Long stop) {
      this.stop = stop;
    }
    @Override
    public String getName() { throw new UnsupportedOperationException(); }
    @Override
    public Long getStart() { throw new UnsupportedOperationException(); }
    @Override
    public Long getStop() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static Timer fromJson(Json json) {
    Timer.Builder builder = Timer.builder();
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.start != null) {
      builder.start(json.start);
    }
    if (json.stop != null) {
      builder.stop(json.stop);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link Timer Timer}.
   * <pre>
   * Timer.builder()
   *    .name(String | null) // nullable {@link Timer#getName() name}
   *    .start(Long | null) // nullable {@link Timer#getStart() start}
   *    .stop(Long | null) // nullable {@link Timer#getStop() stop}
   *    .build();
   * </pre>
   * @return A new Timer builder
   */
  public static Timer.Builder builder() {
    return new Timer.Builder();
  }

  /**
   * Builds instances of type {@link Timer Timer}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_Timer", generator = "Immutables")
  public static final class Builder {
    private String name;
    private Long start;
    private Long stop;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Timer} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Timer instance) {
      return from((_Timer) instance);
    }

    /**
     * Copy abstract value type {@code _Timer} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_Timer instance) {
      Objects.requireNonNull(instance, "instance");
      String nameValue = instance.getName();
      if (nameValue != null) {
        name(nameValue);
      }
      Long startValue = instance.getStart();
      if (startValue != null) {
        start(startValue);
      }
      Long stopValue = instance.getStop();
      if (stopValue != null) {
        stop(stopValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link Timer#getName() name} attribute.
     * @param name The value for name (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("name")
    public final Builder name(@Nullable String name) {
      this.name = name;
      return this;
    }

    /**
     * Initializes the value for the {@link Timer#getStart() start} attribute.
     * @param start The value for start (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("start")
    public final Builder start(@Nullable Long start) {
      this.start = start;
      return this;
    }

    /**
     * Initializes the value for the {@link Timer#getStop() stop} attribute.
     * @param stop The value for stop (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("stop")
    public final Builder stop(@Nullable Long stop) {
      this.stop = stop;
      return this;
    }

    /**
     * Builds a new {@link Timer Timer}.
     * @return An immutable instance of Timer
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public Timer build() {
      return new Timer(this);
    }
  }
}
