package org.cloudfoundry.networking.v1.policies;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * The response payload for the List Policies operation
 */
@Generated(from = "_ListPoliciesResponse", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ListPoliciesResponse extends org.cloudfoundry.networking.v1.policies._ListPoliciesResponse {
  private final List<Policy> policies;
  private final Integer totalPolicies;

  private ListPoliciesResponse(ListPoliciesResponse.Builder builder) {
    this.policies = createUnmodifiableList(true, builder.policies);
    this.totalPolicies = builder.totalPolicies;
  }

  /**
   * The policies
   */
  @JsonProperty("policies")
  @Override
  public List<Policy> getPolicies() {
    return policies;
  }

  /**
   * The number of policies listed
   */
  @JsonProperty("total_policies")
  @Override
  public Integer getTotalPolicies() {
    return totalPolicies;
  }

  /**
   * This instance is equal to all instances of {@code ListPoliciesResponse} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ListPoliciesResponse
        && equalTo(0, (ListPoliciesResponse) another);
  }

  private boolean equalTo(int synthetic, ListPoliciesResponse another) {
    return policies.equals(another.policies)
        && totalPolicies.equals(another.totalPolicies);
  }

  /**
   * Computes a hash code from attributes: {@code policies}, {@code totalPolicies}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + policies.hashCode();
    h += (h << 5) + totalPolicies.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ListPoliciesResponse} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ListPoliciesResponse{"
        + "policies=" + policies
        + ", totalPolicies=" + totalPolicies
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_ListPoliciesResponse", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.networking.v1.policies._ListPoliciesResponse {
    List<Policy> policies = Collections.emptyList();
    Integer totalPolicies;
    @JsonProperty("policies")
    public void setPolicies(List<Policy> policies) {
      this.policies = policies;
    }
    @JsonProperty("total_policies")
    public void setTotalPolicies(Integer totalPolicies) {
      this.totalPolicies = totalPolicies;
    }
    @Override
    public List<Policy> getPolicies() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getTotalPolicies() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ListPoliciesResponse fromJson(Json json) {
    ListPoliciesResponse.Builder builder = ListPoliciesResponse.builder();
    if (json.policies != null) {
      builder.addAllPolicies(json.policies);
    }
    if (json.totalPolicies != null) {
      builder.totalPolicies(json.totalPolicies);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link ListPoliciesResponse ListPoliciesResponse}.
   * <pre>
   * ListPoliciesResponse.builder()
   *    .policy|addAllPolicies(Policy) // {@link ListPoliciesResponse#getPolicies() policies} elements
   *    .totalPolicies(Integer) // required {@link ListPoliciesResponse#getTotalPolicies() totalPolicies}
   *    .build();
   * </pre>
   * @return A new ListPoliciesResponse builder
   */
  public static ListPoliciesResponse.Builder builder() {
    return new ListPoliciesResponse.Builder();
  }

  /**
   * Builds instances of type {@link ListPoliciesResponse ListPoliciesResponse}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_ListPoliciesResponse", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_TOTAL_POLICIES = 0x1L;
    private long initBits = 0x1L;

    private List<Policy> policies = new ArrayList<Policy>();
    private Integer totalPolicies;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ListPoliciesResponse} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ListPoliciesResponse instance) {
      return from((_ListPoliciesResponse) instance);
    }

    /**
     * Copy abstract value type {@code _ListPoliciesResponse} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_ListPoliciesResponse instance) {
      Objects.requireNonNull(instance, "instance");
      addAllPolicies(instance.getPolicies());
      this.totalPolicies(instance.getTotalPolicies());
      return this;
    }

    /**
     * Adds one element to {@link ListPoliciesResponse#getPolicies() policies} list.
     * @param element A policies element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder policy(Policy element) {
      this.policies.add(Objects.requireNonNull(element, "policies element"));
      return this;
    }

    /**
     * Adds elements to {@link ListPoliciesResponse#getPolicies() policies} list.
     * @param elements An array of policies elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder policies(Policy... elements) {
      for (Policy element : elements) {
        this.policies.add(Objects.requireNonNull(element, "policies element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListPoliciesResponse#getPolicies() policies} list.
     * @param elements An iterable of policies elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("policies")
    public final Builder policies(Iterable<? extends Policy> elements) {
      this.policies.clear();
      return addAllPolicies(elements);
    }

    /**
     * Adds elements to {@link ListPoliciesResponse#getPolicies() policies} list.
     * @param elements An iterable of policies elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllPolicies(Iterable<? extends Policy> elements) {
      for (Policy element : elements) {
        this.policies.add(Objects.requireNonNull(element, "policies element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link ListPoliciesResponse#getTotalPolicies() totalPolicies} attribute.
     * @param totalPolicies The value for totalPolicies 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("total_policies")
    public final Builder totalPolicies(Integer totalPolicies) {
      this.totalPolicies = Objects.requireNonNull(totalPolicies, "totalPolicies");
      initBits &= ~INIT_BIT_TOTAL_POLICIES;
      return this;
    }

    /**
     * Builds a new {@link ListPoliciesResponse ListPoliciesResponse}.
     * @return An immutable instance of ListPoliciesResponse
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ListPoliciesResponse build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ListPoliciesResponse(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_TOTAL_POLICIES) != 0) attributes.add("totalPolicies");
      return "Cannot build ListPoliciesResponse, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>(size);
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
