package org.cloudfoundry.routing.v1;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link _ModificationTag}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ModificationTag.builder()}.
 */
@Generated(from = "_ModificationTag", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ModificationTag extends org.cloudfoundry.routing.v1._ModificationTag {
  private final String modificationTagId;
  private final Integer index;

  private ModificationTag(ModificationTag.Builder builder) {
    this.modificationTagId = builder.modificationTagId;
    this.index = builder.index;
  }

  /**
   * The ID of the route.
   */
  @JsonProperty("guid")
  @Override
  public String getModificationTagId() {
    return modificationTagId;
  }

  /**
   * The index of the tag.
   */
  @JsonProperty("index")
  @Override
  public Integer getIndex() {
    return index;
  }

  /**
   * This instance is equal to all instances of {@code ModificationTag} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ModificationTag
        && equalTo(0, (ModificationTag) another);
  }

  private boolean equalTo(int synthetic, ModificationTag another) {
    return modificationTagId.equals(another.modificationTagId)
        && index.equals(another.index);
  }

  /**
   * Computes a hash code from attributes: {@code modificationTagId}, {@code index}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + modificationTagId.hashCode();
    h += (h << 5) + index.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ModificationTag} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ModificationTag{"
        + "modificationTagId=" + modificationTagId
        + ", index=" + index
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_ModificationTag", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.routing.v1._ModificationTag {
    String modificationTagId;
    Integer index;
    @JsonProperty("guid")
    public void setModificationTagId(String modificationTagId) {
      this.modificationTagId = modificationTagId;
    }
    @JsonProperty("index")
    public void setIndex(Integer index) {
      this.index = index;
    }
    @Override
    public String getModificationTagId() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getIndex() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ModificationTag fromJson(Json json) {
    ModificationTag.Builder builder = ModificationTag.builder();
    if (json.modificationTagId != null) {
      builder.modificationTagId(json.modificationTagId);
    }
    if (json.index != null) {
      builder.index(json.index);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link ModificationTag ModificationTag}.
   * <pre>
   * ModificationTag.builder()
   *    .modificationTagId(String) // required {@link ModificationTag#getModificationTagId() modificationTagId}
   *    .index(Integer) // required {@link ModificationTag#getIndex() index}
   *    .build();
   * </pre>
   * @return A new ModificationTag builder
   */
  public static ModificationTag.Builder builder() {
    return new ModificationTag.Builder();
  }

  /**
   * Builds instances of type {@link ModificationTag ModificationTag}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_ModificationTag", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_MODIFICATION_TAG_ID = 0x1L;
    private static final long INIT_BIT_INDEX = 0x2L;
    private long initBits = 0x3L;

    private String modificationTagId;
    private Integer index;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ModificationTag} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ModificationTag instance) {
      return from((_ModificationTag) instance);
    }

    /**
     * Copy abstract value type {@code _ModificationTag} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_ModificationTag instance) {
      Objects.requireNonNull(instance, "instance");
      this.modificationTagId(instance.getModificationTagId());
      this.index(instance.getIndex());
      return this;
    }

    /**
     * Initializes the value for the {@link ModificationTag#getModificationTagId() modificationTagId} attribute.
     * @param modificationTagId The value for modificationTagId 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("guid")
    public final Builder modificationTagId(String modificationTagId) {
      this.modificationTagId = Objects.requireNonNull(modificationTagId, "modificationTagId");
      initBits &= ~INIT_BIT_MODIFICATION_TAG_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link ModificationTag#getIndex() index} attribute.
     * @param index The value for index 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("index")
    public final Builder index(Integer index) {
      this.index = Objects.requireNonNull(index, "index");
      initBits &= ~INIT_BIT_INDEX;
      return this;
    }

    /**
     * Builds a new {@link ModificationTag ModificationTag}.
     * @return An immutable instance of ModificationTag
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ModificationTag build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ModificationTag(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_MODIFICATION_TAG_ID) != 0) attributes.add("modificationTagId");
      if ((initBits & INIT_BIT_INDEX) != 0) attributes.add("index");
      return "Cannot build ModificationTag, some of required attributes are not set " + attributes;
    }
  }
}
