package org.cloudfoundry.routing.v1.routergroups;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * The response payload for the Update Router Group operation
 */
@Generated(from = "_UpdateRouterGroupResponse", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class UpdateRouterGroupResponse
    extends org.cloudfoundry.routing.v1.routergroups._UpdateRouterGroupResponse {
  private final String name;
  private final String reservablePorts;
  private final String routerGroupId;
  private final String type;

  private UpdateRouterGroupResponse(UpdateRouterGroupResponse.Builder builder) {
    this.name = builder.name;
    this.reservablePorts = builder.reservablePorts;
    this.routerGroupId = builder.routerGroupId;
    this.type = builder.type;
  }

  /**
   * Name of the Router Group
   */
  @JsonProperty("name")
  @Override
  public String getName() {
    return name;
  }

  /**
   * Comma delimited list of reservable port or port ranges
   */
  @JsonProperty("reservable_ports")
  @Override
  public String getReservablePorts() {
    return reservablePorts;
  }

  /**
   * ID of the Router Group
   */
  @JsonProperty("guid")
  @Override
  public String getRouterGroupId() {
    return routerGroupId;
  }

  /**
   * Type of the router group, e.g. tcp
   */
  @JsonProperty("type")
  @Override
  public String getType() {
    return type;
  }

  /**
   * This instance is equal to all instances of {@code UpdateRouterGroupResponse} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof UpdateRouterGroupResponse
        && equalTo(0, (UpdateRouterGroupResponse) another);
  }

  private boolean equalTo(int synthetic, UpdateRouterGroupResponse another) {
    return name.equals(another.name)
        && reservablePorts.equals(another.reservablePorts)
        && routerGroupId.equals(another.routerGroupId)
        && type.equals(another.type);
  }

  /**
   * Computes a hash code from attributes: {@code name}, {@code reservablePorts}, {@code routerGroupId}, {@code type}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + name.hashCode();
    h += (h << 5) + reservablePorts.hashCode();
    h += (h << 5) + routerGroupId.hashCode();
    h += (h << 5) + type.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code UpdateRouterGroupResponse} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "UpdateRouterGroupResponse{"
        + "name=" + name
        + ", reservablePorts=" + reservablePorts
        + ", routerGroupId=" + routerGroupId
        + ", type=" + type
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_UpdateRouterGroupResponse", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.routing.v1.routergroups._UpdateRouterGroupResponse {
    String name;
    String reservablePorts;
    String routerGroupId;
    String type;
    @JsonProperty("name")
    public void setName(String name) {
      this.name = name;
    }
    @JsonProperty("reservable_ports")
    public void setReservablePorts(String reservablePorts) {
      this.reservablePorts = reservablePorts;
    }
    @JsonProperty("guid")
    public void setRouterGroupId(String routerGroupId) {
      this.routerGroupId = routerGroupId;
    }
    @JsonProperty("type")
    public void setType(String type) {
      this.type = type;
    }
    @Override
    public String getName() { throw new UnsupportedOperationException(); }
    @Override
    public String getReservablePorts() { throw new UnsupportedOperationException(); }
    @Override
    public String getRouterGroupId() { throw new UnsupportedOperationException(); }
    @Override
    public String getType() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static UpdateRouterGroupResponse fromJson(Json json) {
    UpdateRouterGroupResponse.Builder builder = UpdateRouterGroupResponse.builder();
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.reservablePorts != null) {
      builder.reservablePorts(json.reservablePorts);
    }
    if (json.routerGroupId != null) {
      builder.routerGroupId(json.routerGroupId);
    }
    if (json.type != null) {
      builder.type(json.type);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link UpdateRouterGroupResponse UpdateRouterGroupResponse}.
   * <pre>
   * UpdateRouterGroupResponse.builder()
   *    .name(String) // required {@link UpdateRouterGroupResponse#getName() name}
   *    .reservablePorts(String) // required {@link UpdateRouterGroupResponse#getReservablePorts() reservablePorts}
   *    .routerGroupId(String) // required {@link UpdateRouterGroupResponse#getRouterGroupId() routerGroupId}
   *    .type(String) // required {@link UpdateRouterGroupResponse#getType() type}
   *    .build();
   * </pre>
   * @return A new UpdateRouterGroupResponse builder
   */
  public static UpdateRouterGroupResponse.Builder builder() {
    return new UpdateRouterGroupResponse.Builder();
  }

  /**
   * Builds instances of type {@link UpdateRouterGroupResponse UpdateRouterGroupResponse}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_UpdateRouterGroupResponse", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_NAME = 0x1L;
    private static final long INIT_BIT_RESERVABLE_PORTS = 0x2L;
    private static final long INIT_BIT_ROUTER_GROUP_ID = 0x4L;
    private static final long INIT_BIT_TYPE = 0x8L;
    private long initBits = 0xfL;

    private String name;
    private String reservablePorts;
    private String routerGroupId;
    private String type;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.routing.v1.routergroups.AbstractRouterGroup} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(AbstractRouterGroup instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code UpdateRouterGroupResponse} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(UpdateRouterGroupResponse instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _UpdateRouterGroupResponse} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(_UpdateRouterGroupResponse instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    private void from(short _unused, Object object) {
      if (object instanceof AbstractRouterGroup) {
        AbstractRouterGroup instance = (AbstractRouterGroup) object;
        this.name(instance.getName());
        this.routerGroupId(instance.getRouterGroupId());
        this.type(instance.getType());
        this.reservablePorts(instance.getReservablePorts());
      }
    }

    /**
     * Initializes the value for the {@link UpdateRouterGroupResponse#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("name")
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateRouterGroupResponse#getReservablePorts() reservablePorts} attribute.
     * @param reservablePorts The value for reservablePorts 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("reservable_ports")
    public final Builder reservablePorts(String reservablePorts) {
      this.reservablePorts = Objects.requireNonNull(reservablePorts, "reservablePorts");
      initBits &= ~INIT_BIT_RESERVABLE_PORTS;
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateRouterGroupResponse#getRouterGroupId() routerGroupId} attribute.
     * @param routerGroupId The value for routerGroupId 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("guid")
    public final Builder routerGroupId(String routerGroupId) {
      this.routerGroupId = Objects.requireNonNull(routerGroupId, "routerGroupId");
      initBits &= ~INIT_BIT_ROUTER_GROUP_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateRouterGroupResponse#getType() type} attribute.
     * @param type The value for type 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("type")
    public final Builder type(String type) {
      this.type = Objects.requireNonNull(type, "type");
      initBits &= ~INIT_BIT_TYPE;
      return this;
    }

    /**
     * Builds a new {@link UpdateRouterGroupResponse UpdateRouterGroupResponse}.
     * @return An immutable instance of UpdateRouterGroupResponse
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public UpdateRouterGroupResponse build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new UpdateRouterGroupResponse(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      if ((initBits & INIT_BIT_RESERVABLE_PORTS) != 0) attributes.add("reservablePorts");
      if ((initBits & INIT_BIT_ROUTER_GROUP_ID) != 0) attributes.add("routerGroupId");
      if ((initBits & INIT_BIT_TYPE) != 0) attributes.add("type");
      return "Cannot build UpdateRouterGroupResponse, some of required attributes are not set " + attributes;
    }
  }
}
