package org.cloudfoundry.routing.v1.tcproutes;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * The payload for TCP Route responses
 */
@Generated(from = "_TcpRouteConfiguration", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class TcpRouteConfiguration extends org.cloudfoundry.routing.v1.tcproutes._TcpRouteConfiguration {
  private final String backendIp;
  private final Integer backendPort;
  private final Integer port;
  private final String routerGroupId;
  private final Integer ttl;

  private TcpRouteConfiguration(TcpRouteConfiguration.Builder builder) {
    this.backendIp = builder.backendIp;
    this.backendPort = builder.backendPort;
    this.port = builder.port;
    this.routerGroupId = builder.routerGroupId;
    this.ttl = builder.ttl;
  }

  /**
   * IP address of backend.
   */
  @JsonProperty("backend_ip")
  @Override
  public String getBackendIp() {
    return backendIp;
  }

  /**
   * Backend port.
   */
  @JsonProperty("backend_port")
  @Override
  public Integer getBackendPort() {
    return backendPort;
  }

  /**
   * External facing port for the TCP route.
   */
  @JsonProperty("port")
  @Override
  public Integer getPort() {
    return port;
  }

  /**
   * ID of the router group associated with this route.
   */
  @JsonProperty("router_group_guid")
  @Override
  public String getRouterGroupId() {
    return routerGroupId;
  }

  /**
   * Time to live, in seconds.
   */
  @JsonProperty("ttl")
  @Override
  public Integer getTtl() {
    return ttl;
  }

  /**
   * This instance is equal to all instances of {@code TcpRouteConfiguration} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof TcpRouteConfiguration
        && equalTo(0, (TcpRouteConfiguration) another);
  }

  private boolean equalTo(int synthetic, TcpRouteConfiguration another) {
    return backendIp.equals(another.backendIp)
        && backendPort.equals(another.backendPort)
        && port.equals(another.port)
        && routerGroupId.equals(another.routerGroupId)
        && ttl.equals(another.ttl);
  }

  /**
   * Computes a hash code from attributes: {@code backendIp}, {@code backendPort}, {@code port}, {@code routerGroupId}, {@code ttl}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + backendIp.hashCode();
    h += (h << 5) + backendPort.hashCode();
    h += (h << 5) + port.hashCode();
    h += (h << 5) + routerGroupId.hashCode();
    h += (h << 5) + ttl.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code TcpRouteConfiguration} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "TcpRouteConfiguration{"
        + "backendIp=" + backendIp
        + ", backendPort=" + backendPort
        + ", port=" + port
        + ", routerGroupId=" + routerGroupId
        + ", ttl=" + ttl
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_TcpRouteConfiguration", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.routing.v1.tcproutes._TcpRouteConfiguration {
    String backendIp;
    Integer backendPort;
    Integer port;
    String routerGroupId;
    Integer ttl;
    @JsonProperty("backend_ip")
    public void setBackendIp(String backendIp) {
      this.backendIp = backendIp;
    }
    @JsonProperty("backend_port")
    public void setBackendPort(Integer backendPort) {
      this.backendPort = backendPort;
    }
    @JsonProperty("port")
    public void setPort(Integer port) {
      this.port = port;
    }
    @JsonProperty("router_group_guid")
    public void setRouterGroupId(String routerGroupId) {
      this.routerGroupId = routerGroupId;
    }
    @JsonProperty("ttl")
    public void setTtl(Integer ttl) {
      this.ttl = ttl;
    }
    @Override
    public String getBackendIp() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getBackendPort() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getPort() { throw new UnsupportedOperationException(); }
    @Override
    public String getRouterGroupId() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getTtl() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static TcpRouteConfiguration fromJson(Json json) {
    TcpRouteConfiguration.Builder builder = TcpRouteConfiguration.builder();
    if (json.backendIp != null) {
      builder.backendIp(json.backendIp);
    }
    if (json.backendPort != null) {
      builder.backendPort(json.backendPort);
    }
    if (json.port != null) {
      builder.port(json.port);
    }
    if (json.routerGroupId != null) {
      builder.routerGroupId(json.routerGroupId);
    }
    if (json.ttl != null) {
      builder.ttl(json.ttl);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link TcpRouteConfiguration TcpRouteConfiguration}.
   * <pre>
   * TcpRouteConfiguration.builder()
   *    .backendIp(String) // required {@link TcpRouteConfiguration#getBackendIp() backendIp}
   *    .backendPort(Integer) // required {@link TcpRouteConfiguration#getBackendPort() backendPort}
   *    .port(Integer) // required {@link TcpRouteConfiguration#getPort() port}
   *    .routerGroupId(String) // required {@link TcpRouteConfiguration#getRouterGroupId() routerGroupId}
   *    .ttl(Integer) // required {@link TcpRouteConfiguration#getTtl() ttl}
   *    .build();
   * </pre>
   * @return A new TcpRouteConfiguration builder
   */
  public static TcpRouteConfiguration.Builder builder() {
    return new TcpRouteConfiguration.Builder();
  }

  /**
   * Builds instances of type {@link TcpRouteConfiguration TcpRouteConfiguration}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_TcpRouteConfiguration", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_BACKEND_IP = 0x1L;
    private static final long INIT_BIT_BACKEND_PORT = 0x2L;
    private static final long INIT_BIT_PORT = 0x4L;
    private static final long INIT_BIT_ROUTER_GROUP_ID = 0x8L;
    private static final long INIT_BIT_TTL = 0x10L;
    private long initBits = 0x1fL;

    private String backendIp;
    private Integer backendPort;
    private Integer port;
    private String routerGroupId;
    private Integer ttl;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code TcpRouteConfiguration} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(TcpRouteConfiguration instance) {
      return from((_TcpRouteConfiguration) instance);
    }

    /**
     * Copy abstract value type {@code _TcpRouteConfiguration} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_TcpRouteConfiguration instance) {
      Objects.requireNonNull(instance, "instance");
      this.backendIp(instance.getBackendIp());
      this.backendPort(instance.getBackendPort());
      this.port(instance.getPort());
      this.routerGroupId(instance.getRouterGroupId());
      this.ttl(instance.getTtl());
      return this;
    }

    /**
     * Initializes the value for the {@link TcpRouteConfiguration#getBackendIp() backendIp} attribute.
     * @param backendIp The value for backendIp 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("backend_ip")
    public final Builder backendIp(String backendIp) {
      this.backendIp = Objects.requireNonNull(backendIp, "backendIp");
      initBits &= ~INIT_BIT_BACKEND_IP;
      return this;
    }

    /**
     * Initializes the value for the {@link TcpRouteConfiguration#getBackendPort() backendPort} attribute.
     * @param backendPort The value for backendPort 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("backend_port")
    public final Builder backendPort(Integer backendPort) {
      this.backendPort = Objects.requireNonNull(backendPort, "backendPort");
      initBits &= ~INIT_BIT_BACKEND_PORT;
      return this;
    }

    /**
     * Initializes the value for the {@link TcpRouteConfiguration#getPort() port} attribute.
     * @param port The value for port 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("port")
    public final Builder port(Integer port) {
      this.port = Objects.requireNonNull(port, "port");
      initBits &= ~INIT_BIT_PORT;
      return this;
    }

    /**
     * Initializes the value for the {@link TcpRouteConfiguration#getRouterGroupId() routerGroupId} attribute.
     * @param routerGroupId The value for routerGroupId 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("router_group_guid")
    public final Builder routerGroupId(String routerGroupId) {
      this.routerGroupId = Objects.requireNonNull(routerGroupId, "routerGroupId");
      initBits &= ~INIT_BIT_ROUTER_GROUP_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link TcpRouteConfiguration#getTtl() ttl} attribute.
     * @param ttl The value for ttl 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("ttl")
    public final Builder ttl(Integer ttl) {
      this.ttl = Objects.requireNonNull(ttl, "ttl");
      initBits &= ~INIT_BIT_TTL;
      return this;
    }

    /**
     * Builds a new {@link TcpRouteConfiguration TcpRouteConfiguration}.
     * @return An immutable instance of TcpRouteConfiguration
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public TcpRouteConfiguration build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new TcpRouteConfiguration(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_BACKEND_IP) != 0) attributes.add("backendIp");
      if ((initBits & INIT_BIT_BACKEND_PORT) != 0) attributes.add("backendPort");
      if ((initBits & INIT_BIT_PORT) != 0) attributes.add("port");
      if ((initBits & INIT_BIT_ROUTER_GROUP_ID) != 0) attributes.add("routerGroupId");
      if ((initBits & INIT_BIT_TTL) != 0) attributes.add("ttl");
      return "Cannot build TcpRouteConfiguration, some of required attributes are not set " + attributes;
    }
  }
}
