package org.cloudfoundry.uaa.authorizations;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.immutables.value.Generated;

/**
 * The request payload for authorization with an authorization code grant operation
 */
@Generated(from = "_AuthorizeByAuthorizationCodeGrantApiRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class AuthorizeByAuthorizationCodeGrantApiRequest
    extends org.cloudfoundry.uaa.authorizations._AuthorizeByAuthorizationCodeGrantApiRequest {
  private final String clientId;
  private final @Nullable String redirectUri;
  private final @Nullable String state;

  private AuthorizeByAuthorizationCodeGrantApiRequest(AuthorizeByAuthorizationCodeGrantApiRequest.Builder builder) {
    this.clientId = builder.clientId;
    this.redirectUri = builder.redirectUri;
    this.state = builder.state;
  }

  /**
   * A unique string representing the registration information provided by the client
   */
  @Override
  public String getClientId() {
    return clientId;
  }

  /**
   * Redirection URI to which the authorization server will send the user-agent back once access is granted (or denied), optional if pre-registered by the client
   */
  @Override
  public @Nullable String getRedirectUri() {
    return redirectUri;
  }

  /**
   * Any random string to be returned in the Location header as a query parameter, used to achieve per-request customization
   */
  @Override
  public @Nullable String getState() {
    return state;
  }

  /**
   * This instance is equal to all instances of {@code AuthorizeByAuthorizationCodeGrantApiRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof AuthorizeByAuthorizationCodeGrantApiRequest
        && equalTo(0, (AuthorizeByAuthorizationCodeGrantApiRequest) another);
  }

  private boolean equalTo(int synthetic, AuthorizeByAuthorizationCodeGrantApiRequest another) {
    return clientId.equals(another.clientId)
        && Objects.equals(redirectUri, another.redirectUri)
        && Objects.equals(state, another.state);
  }

  /**
   * Computes a hash code from attributes: {@code clientId}, {@code redirectUri}, {@code state}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + clientId.hashCode();
    h += (h << 5) + Objects.hashCode(redirectUri);
    h += (h << 5) + Objects.hashCode(state);
    return h;
  }

  /**
   * Prints the immutable value {@code AuthorizeByAuthorizationCodeGrantApiRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "AuthorizeByAuthorizationCodeGrantApiRequest{"
        + "clientId=" + clientId
        + ", redirectUri=" + redirectUri
        + ", state=" + state
        + "}";
  }

  /**
   * Creates a builder for {@link AuthorizeByAuthorizationCodeGrantApiRequest AuthorizeByAuthorizationCodeGrantApiRequest}.
   * <pre>
   * AuthorizeByAuthorizationCodeGrantApiRequest.builder()
   *    .clientId(String) // required {@link AuthorizeByAuthorizationCodeGrantApiRequest#getClientId() clientId}
   *    .redirectUri(String | null) // nullable {@link AuthorizeByAuthorizationCodeGrantApiRequest#getRedirectUri() redirectUri}
   *    .state(String | null) // nullable {@link AuthorizeByAuthorizationCodeGrantApiRequest#getState() state}
   *    .build();
   * </pre>
   * @return A new AuthorizeByAuthorizationCodeGrantApiRequest builder
   */
  public static AuthorizeByAuthorizationCodeGrantApiRequest.Builder builder() {
    return new AuthorizeByAuthorizationCodeGrantApiRequest.Builder();
  }

  /**
   * Builds instances of type {@link AuthorizeByAuthorizationCodeGrantApiRequest AuthorizeByAuthorizationCodeGrantApiRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_AuthorizeByAuthorizationCodeGrantApiRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_CLIENT_ID = 0x1L;
    private long initBits = 0x1L;

    private String clientId;
    private String redirectUri;
    private String state;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code AuthorizeByAuthorizationCodeGrantApiRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(AuthorizeByAuthorizationCodeGrantApiRequest instance) {
      return from((_AuthorizeByAuthorizationCodeGrantApiRequest) instance);
    }

    /**
     * Copy abstract value type {@code _AuthorizeByAuthorizationCodeGrantApiRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_AuthorizeByAuthorizationCodeGrantApiRequest instance) {
      Objects.requireNonNull(instance, "instance");
      this.clientId(instance.getClientId());
      String redirectUriValue = instance.getRedirectUri();
      if (redirectUriValue != null) {
        redirectUri(redirectUriValue);
      }
      String stateValue = instance.getState();
      if (stateValue != null) {
        state(stateValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link AuthorizeByAuthorizationCodeGrantApiRequest#getClientId() clientId} attribute.
     * @param clientId The value for clientId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder clientId(String clientId) {
      this.clientId = Objects.requireNonNull(clientId, "clientId");
      initBits &= ~INIT_BIT_CLIENT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link AuthorizeByAuthorizationCodeGrantApiRequest#getRedirectUri() redirectUri} attribute.
     * @param redirectUri The value for redirectUri (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder redirectUri(@Nullable String redirectUri) {
      this.redirectUri = redirectUri;
      return this;
    }

    /**
     * Initializes the value for the {@link AuthorizeByAuthorizationCodeGrantApiRequest#getState() state} attribute.
     * @param state The value for state (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder state(@Nullable String state) {
      this.state = state;
      return this;
    }

    /**
     * Builds a new {@link AuthorizeByAuthorizationCodeGrantApiRequest AuthorizeByAuthorizationCodeGrantApiRequest}.
     * @return An immutable instance of AuthorizeByAuthorizationCodeGrantApiRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public AuthorizeByAuthorizationCodeGrantApiRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new AuthorizeByAuthorizationCodeGrantApiRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_CLIENT_ID) != 0) attributes.add("clientId");
      return "Cannot build AuthorizeByAuthorizationCodeGrantApiRequest, some of required attributes are not set " + attributes;
    }
  }
}
