package org.cloudfoundry.uaa.clients;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.uaa.IdentityZoned;
import org.immutables.value.Generated;

/**
 * The request payload for Change Secret
 */
@Generated(from = "_ChangeSecretRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ChangeSecretRequest extends org.cloudfoundry.uaa.clients._ChangeSecretRequest {
  private final @Nullable String identityZoneId;
  private final @Nullable String identityZoneSubdomain;
  private final String clientId;
  private final @Nullable String oldSecret;
  private final String secret;

  private ChangeSecretRequest(ChangeSecretRequest.Builder builder) {
    this.identityZoneId = builder.identityZoneId;
    this.identityZoneSubdomain = builder.identityZoneSubdomain;
    this.clientId = builder.clientId;
    this.oldSecret = builder.oldSecret;
    this.secret = builder.secret;
  }

  /**
   * Returns the identity zone id
   * @return the identity zone id
   */
  @JsonProperty("identityZoneId")
  @JsonIgnore
  @Override
  public @Nullable String getIdentityZoneId() {
    return identityZoneId;
  }

  /**
   * Returns the identity zone subdomain
   * @return the identity zone subdomain
   */
  @JsonProperty("identityZoneSubdomain")
  @JsonIgnore
  @Override
  public @Nullable String getIdentityZoneSubdomain() {
    return identityZoneSubdomain;
  }

  /**
   * The client id
   */
  @JsonProperty("clientId")
  @Override
  public String getClientId() {
    return clientId;
  }

  /**
   * The old secret
   */
  @JsonProperty("oldSecret")
  @Override
  public @Nullable String getOldSecret() {
    return oldSecret;
  }

  /**
   * The new secret
   */
  @JsonProperty("secret")
  @Override
  public String getSecret() {
    return secret;
  }

  /**
   * This instance is equal to all instances of {@code ChangeSecretRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ChangeSecretRequest
        && equalTo(0, (ChangeSecretRequest) another);
  }

  private boolean equalTo(int synthetic, ChangeSecretRequest another) {
    return Objects.equals(identityZoneId, another.identityZoneId)
        && Objects.equals(identityZoneSubdomain, another.identityZoneSubdomain)
        && clientId.equals(another.clientId)
        && Objects.equals(oldSecret, another.oldSecret)
        && secret.equals(another.secret);
  }

  /**
   * Computes a hash code from attributes: {@code identityZoneId}, {@code identityZoneSubdomain}, {@code clientId}, {@code oldSecret}, {@code secret}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(identityZoneId);
    h += (h << 5) + Objects.hashCode(identityZoneSubdomain);
    h += (h << 5) + clientId.hashCode();
    h += (h << 5) + Objects.hashCode(oldSecret);
    h += (h << 5) + secret.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ChangeSecretRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ChangeSecretRequest{"
        + "identityZoneId=" + identityZoneId
        + ", identityZoneSubdomain=" + identityZoneSubdomain
        + ", clientId=" + clientId
        + ", oldSecret=" + oldSecret
        + ", secret=" + secret
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_ChangeSecretRequest", generator = "Immutables")
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.uaa.clients._ChangeSecretRequest {
    String identityZoneId;
    String identityZoneSubdomain;
    String clientId;
    String oldSecret;
    String secret;
    @JsonProperty("identityZoneId")
    @JsonIgnore
    public void setIdentityZoneId(@Nullable String identityZoneId) {
      this.identityZoneId = identityZoneId;
    }
    @JsonProperty("identityZoneSubdomain")
    @JsonIgnore
    public void setIdentityZoneSubdomain(@Nullable String identityZoneSubdomain) {
      this.identityZoneSubdomain = identityZoneSubdomain;
    }
    @JsonProperty("clientId")
    public void setClientId(String clientId) {
      this.clientId = clientId;
    }
    @JsonProperty("oldSecret")
    public void setOldSecret(@Nullable String oldSecret) {
      this.oldSecret = oldSecret;
    }
    @JsonProperty("secret")
    public void setSecret(String secret) {
      this.secret = secret;
    }
    @Override
    public String getIdentityZoneId() { throw new UnsupportedOperationException(); }
    @Override
    public String getIdentityZoneSubdomain() { throw new UnsupportedOperationException(); }
    @Override
    public String getClientId() { throw new UnsupportedOperationException(); }
    @Override
    public String getOldSecret() { throw new UnsupportedOperationException(); }
    @Override
    public String getSecret() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ChangeSecretRequest fromJson(Json json) {
    ChangeSecretRequest.Builder builder = ChangeSecretRequest.builder();
    if (json.identityZoneId != null) {
      builder.identityZoneId(json.identityZoneId);
    }
    if (json.identityZoneSubdomain != null) {
      builder.identityZoneSubdomain(json.identityZoneSubdomain);
    }
    if (json.clientId != null) {
      builder.clientId(json.clientId);
    }
    if (json.oldSecret != null) {
      builder.oldSecret(json.oldSecret);
    }
    if (json.secret != null) {
      builder.secret(json.secret);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link ChangeSecretRequest ChangeSecretRequest}.
   * <pre>
   * ChangeSecretRequest.builder()
   *    .identityZoneId(String | null) // nullable {@link ChangeSecretRequest#getIdentityZoneId() identityZoneId}
   *    .identityZoneSubdomain(String | null) // nullable {@link ChangeSecretRequest#getIdentityZoneSubdomain() identityZoneSubdomain}
   *    .clientId(String) // required {@link ChangeSecretRequest#getClientId() clientId}
   *    .oldSecret(String | null) // nullable {@link ChangeSecretRequest#getOldSecret() oldSecret}
   *    .secret(String) // required {@link ChangeSecretRequest#getSecret() secret}
   *    .build();
   * </pre>
   * @return A new ChangeSecretRequest builder
   */
  public static ChangeSecretRequest.Builder builder() {
    return new ChangeSecretRequest.Builder();
  }

  /**
   * Builds instances of type {@link ChangeSecretRequest ChangeSecretRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_ChangeSecretRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_CLIENT_ID = 0x1L;
    private static final long INIT_BIT_SECRET = 0x2L;
    private long initBits = 0x3L;

    private String identityZoneId;
    private String identityZoneSubdomain;
    private String clientId;
    private String oldSecret;
    private String secret;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ChangeSecretRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ChangeSecretRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _ChangeSecretRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(_ChangeSecretRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.uaa.IdentityZoned} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(IdentityZoned instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.uaa.clients.AbstractChangeSecret} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(AbstractChangeSecret instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    private void from(short _unused, Object object) {
      long bits = 0;
      if (object instanceof org.cloudfoundry.uaa.clients._ChangeSecretRequest) {
        org.cloudfoundry.uaa.clients._ChangeSecretRequest instance = (org.cloudfoundry.uaa.clients._ChangeSecretRequest) object;
        if ((bits & 0x1L) == 0) {
          this.clientId(instance.getClientId());
          bits |= 0x1L;
        }
        if ((bits & 0x2L) == 0) {
          this.secret(instance.getSecret());
          bits |= 0x2L;
        }
        if ((bits & 0x8L) == 0) {
          String identityZoneSubdomainValue = instance.getIdentityZoneSubdomain();
          if (identityZoneSubdomainValue != null) {
            identityZoneSubdomain(identityZoneSubdomainValue);
          }
          bits |= 0x8L;
        }
        if ((bits & 0x4L) == 0) {
          String oldSecretValue = instance.getOldSecret();
          if (oldSecretValue != null) {
            oldSecret(oldSecretValue);
          }
          bits |= 0x4L;
        }
        if ((bits & 0x10L) == 0) {
          String identityZoneIdValue = instance.getIdentityZoneId();
          if (identityZoneIdValue != null) {
            identityZoneId(identityZoneIdValue);
          }
          bits |= 0x10L;
        }
      }
      if (object instanceof IdentityZoned) {
        IdentityZoned instance = (IdentityZoned) object;
        if ((bits & 0x8L) == 0) {
          String identityZoneSubdomainValue = instance.getIdentityZoneSubdomain();
          if (identityZoneSubdomainValue != null) {
            identityZoneSubdomain(identityZoneSubdomainValue);
          }
          bits |= 0x8L;
        }
        if ((bits & 0x10L) == 0) {
          String identityZoneIdValue = instance.getIdentityZoneId();
          if (identityZoneIdValue != null) {
            identityZoneId(identityZoneIdValue);
          }
          bits |= 0x10L;
        }
      }
      if (object instanceof AbstractChangeSecret) {
        AbstractChangeSecret instance = (AbstractChangeSecret) object;
        if ((bits & 0x4L) == 0) {
          String oldSecretValue = instance.getOldSecret();
          if (oldSecretValue != null) {
            oldSecret(oldSecretValue);
          }
          bits |= 0x4L;
        }
        if ((bits & 0x1L) == 0) {
          this.clientId(instance.getClientId());
          bits |= 0x1L;
        }
        if ((bits & 0x2L) == 0) {
          this.secret(instance.getSecret());
          bits |= 0x2L;
        }
      }
    }

    /**
     * Initializes the value for the {@link ChangeSecretRequest#getIdentityZoneId() identityZoneId} attribute.
     * @param identityZoneId The value for identityZoneId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder identityZoneId(@Nullable String identityZoneId) {
      this.identityZoneId = identityZoneId;
      return this;
    }

    /**
     * Initializes the value for the {@link ChangeSecretRequest#getIdentityZoneSubdomain() identityZoneSubdomain} attribute.
     * @param identityZoneSubdomain The value for identityZoneSubdomain (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder identityZoneSubdomain(@Nullable String identityZoneSubdomain) {
      this.identityZoneSubdomain = identityZoneSubdomain;
      return this;
    }

    /**
     * Initializes the value for the {@link ChangeSecretRequest#getClientId() clientId} attribute.
     * @param clientId The value for clientId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder clientId(String clientId) {
      this.clientId = Objects.requireNonNull(clientId, "clientId");
      initBits &= ~INIT_BIT_CLIENT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link ChangeSecretRequest#getOldSecret() oldSecret} attribute.
     * @param oldSecret The value for oldSecret (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder oldSecret(@Nullable String oldSecret) {
      this.oldSecret = oldSecret;
      return this;
    }

    /**
     * Initializes the value for the {@link ChangeSecretRequest#getSecret() secret} attribute.
     * @param secret The value for secret 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder secret(String secret) {
      this.secret = Objects.requireNonNull(secret, "secret");
      initBits &= ~INIT_BIT_SECRET;
      return this;
    }

    /**
     * Builds a new {@link ChangeSecretRequest ChangeSecretRequest}.
     * @return An immutable instance of ChangeSecretRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ChangeSecretRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ChangeSecretRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_CLIENT_ID) != 0) attributes.add("clientId");
      if ((initBits & INIT_BIT_SECRET) != 0) attributes.add("secret");
      return "Cannot build ChangeSecretRequest, some of required attributes are not set " + attributes;
    }
  }
}
