package org.cloudfoundry.uaa.clients;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.immutables.value.Generated;

/**
 * The response from the Get Metadata request
 */
@Generated(from = "_GetMetadataResponse", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class GetMetadataResponse extends org.cloudfoundry.uaa.clients._GetMetadataResponse {
  private final String appIcon;
  private final @Nullable String appLaunchUrl;
  private final String clientId;
  private final @Nullable String clientName;
  private final Boolean showOnHomePage;

  private GetMetadataResponse(GetMetadataResponse.Builder builder) {
    this.appIcon = builder.appIcon;
    this.appLaunchUrl = builder.appLaunchUrl;
    this.clientId = builder.clientId;
    this.clientName = builder.clientName;
    this.showOnHomePage = builder.showOnHomePage;
  }

  /**
   * Base64 encoded image file
   */
  @JsonProperty("appIcon")
  @Override
  public String getAppIcon() {
    return appIcon;
  }

  /**
   * URL to which the app is linked
   */
  @JsonProperty("appLaunchUrl")
  @Override
  public @Nullable String getAppLaunchUrl() {
    return appLaunchUrl;
  }

  /**
   * Client identifier, unique within identity zone
   */
  @JsonProperty("clientId")
  @Override
  public String getClientId() {
    return clientId;
  }

  /**
   * Client name
   */
  @JsonProperty("clientName")
  @Override
  public @Nullable String getClientName() {
    return clientName;
  }

  /**
   * Flag to control visibility on home page
   */
  @JsonProperty("showOnHomePage")
  @Override
  public Boolean getShowOnHomePage() {
    return showOnHomePage;
  }

  /**
   * This instance is equal to all instances of {@code GetMetadataResponse} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof GetMetadataResponse
        && equalTo(0, (GetMetadataResponse) another);
  }

  private boolean equalTo(int synthetic, GetMetadataResponse another) {
    return appIcon.equals(another.appIcon)
        && Objects.equals(appLaunchUrl, another.appLaunchUrl)
        && clientId.equals(another.clientId)
        && Objects.equals(clientName, another.clientName)
        && showOnHomePage.equals(another.showOnHomePage);
  }

  /**
   * Computes a hash code from attributes: {@code appIcon}, {@code appLaunchUrl}, {@code clientId}, {@code clientName}, {@code showOnHomePage}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + appIcon.hashCode();
    h += (h << 5) + Objects.hashCode(appLaunchUrl);
    h += (h << 5) + clientId.hashCode();
    h += (h << 5) + Objects.hashCode(clientName);
    h += (h << 5) + showOnHomePage.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code GetMetadataResponse} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "GetMetadataResponse{"
        + "appIcon=" + appIcon
        + ", appLaunchUrl=" + appLaunchUrl
        + ", clientId=" + clientId
        + ", clientName=" + clientName
        + ", showOnHomePage=" + showOnHomePage
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_GetMetadataResponse", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.uaa.clients._GetMetadataResponse {
    String appIcon;
    String appLaunchUrl;
    String clientId;
    String clientName;
    Boolean showOnHomePage;
    @JsonProperty("appIcon")
    public void setAppIcon(String appIcon) {
      this.appIcon = appIcon;
    }
    @JsonProperty("appLaunchUrl")
    public void setAppLaunchUrl(@Nullable String appLaunchUrl) {
      this.appLaunchUrl = appLaunchUrl;
    }
    @JsonProperty("clientId")
    public void setClientId(String clientId) {
      this.clientId = clientId;
    }
    @JsonProperty("clientName")
    public void setClientName(@Nullable String clientName) {
      this.clientName = clientName;
    }
    @JsonProperty("showOnHomePage")
    public void setShowOnHomePage(Boolean showOnHomePage) {
      this.showOnHomePage = showOnHomePage;
    }
    @Override
    public String getAppIcon() { throw new UnsupportedOperationException(); }
    @Override
    public String getAppLaunchUrl() { throw new UnsupportedOperationException(); }
    @Override
    public String getClientId() { throw new UnsupportedOperationException(); }
    @Override
    public String getClientName() { throw new UnsupportedOperationException(); }
    @Override
    public Boolean getShowOnHomePage() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static GetMetadataResponse fromJson(Json json) {
    GetMetadataResponse.Builder builder = GetMetadataResponse.builder();
    if (json.appIcon != null) {
      builder.appIcon(json.appIcon);
    }
    if (json.appLaunchUrl != null) {
      builder.appLaunchUrl(json.appLaunchUrl);
    }
    if (json.clientId != null) {
      builder.clientId(json.clientId);
    }
    if (json.clientName != null) {
      builder.clientName(json.clientName);
    }
    if (json.showOnHomePage != null) {
      builder.showOnHomePage(json.showOnHomePage);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link GetMetadataResponse GetMetadataResponse}.
   * <pre>
   * GetMetadataResponse.builder()
   *    .appIcon(String) // required {@link GetMetadataResponse#getAppIcon() appIcon}
   *    .appLaunchUrl(String | null) // nullable {@link GetMetadataResponse#getAppLaunchUrl() appLaunchUrl}
   *    .clientId(String) // required {@link GetMetadataResponse#getClientId() clientId}
   *    .clientName(String | null) // nullable {@link GetMetadataResponse#getClientName() clientName}
   *    .showOnHomePage(Boolean) // required {@link GetMetadataResponse#getShowOnHomePage() showOnHomePage}
   *    .build();
   * </pre>
   * @return A new GetMetadataResponse builder
   */
  public static GetMetadataResponse.Builder builder() {
    return new GetMetadataResponse.Builder();
  }

  /**
   * Builds instances of type {@link GetMetadataResponse GetMetadataResponse}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_GetMetadataResponse", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_APP_ICON = 0x1L;
    private static final long INIT_BIT_CLIENT_ID = 0x2L;
    private static final long INIT_BIT_SHOW_ON_HOME_PAGE = 0x4L;
    private long initBits = 0x7L;

    private String appIcon;
    private String appLaunchUrl;
    private String clientId;
    private String clientName;
    private Boolean showOnHomePage;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.uaa.clients.AbstractMetadata} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(AbstractMetadata instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code GetMetadataResponse} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(GetMetadataResponse instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _GetMetadataResponse} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(_GetMetadataResponse instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    private void from(short _unused, Object object) {
      if (object instanceof AbstractMetadata) {
        AbstractMetadata instance = (AbstractMetadata) object;
        this.appIcon(instance.getAppIcon());
        this.clientId(instance.getClientId());
        this.showOnHomePage(instance.getShowOnHomePage());
        String clientNameValue = instance.getClientName();
        if (clientNameValue != null) {
          clientName(clientNameValue);
        }
        String appLaunchUrlValue = instance.getAppLaunchUrl();
        if (appLaunchUrlValue != null) {
          appLaunchUrl(appLaunchUrlValue);
        }
      }
    }

    /**
     * Initializes the value for the {@link GetMetadataResponse#getAppIcon() appIcon} attribute.
     * @param appIcon The value for appIcon 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("appIcon")
    public final Builder appIcon(String appIcon) {
      this.appIcon = Objects.requireNonNull(appIcon, "appIcon");
      initBits &= ~INIT_BIT_APP_ICON;
      return this;
    }

    /**
     * Initializes the value for the {@link GetMetadataResponse#getAppLaunchUrl() appLaunchUrl} attribute.
     * @param appLaunchUrl The value for appLaunchUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("appLaunchUrl")
    public final Builder appLaunchUrl(@Nullable String appLaunchUrl) {
      this.appLaunchUrl = appLaunchUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link GetMetadataResponse#getClientId() clientId} attribute.
     * @param clientId The value for clientId 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("clientId")
    public final Builder clientId(String clientId) {
      this.clientId = Objects.requireNonNull(clientId, "clientId");
      initBits &= ~INIT_BIT_CLIENT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link GetMetadataResponse#getClientName() clientName} attribute.
     * @param clientName The value for clientName (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("clientName")
    public final Builder clientName(@Nullable String clientName) {
      this.clientName = clientName;
      return this;
    }

    /**
     * Initializes the value for the {@link GetMetadataResponse#getShowOnHomePage() showOnHomePage} attribute.
     * @param showOnHomePage The value for showOnHomePage 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("showOnHomePage")
    public final Builder showOnHomePage(Boolean showOnHomePage) {
      this.showOnHomePage = Objects.requireNonNull(showOnHomePage, "showOnHomePage");
      initBits &= ~INIT_BIT_SHOW_ON_HOME_PAGE;
      return this;
    }

    /**
     * Builds a new {@link GetMetadataResponse GetMetadataResponse}.
     * @return An immutable instance of GetMetadataResponse
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public GetMetadataResponse build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new GetMetadataResponse(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_APP_ICON) != 0) attributes.add("appIcon");
      if ((initBits & INIT_BIT_CLIENT_ID) != 0) attributes.add("clientId");
      if ((initBits & INIT_BIT_SHOW_ON_HOME_PAGE) != 0) attributes.add("showOnHomePage");
      return "Cannot build GetMetadataResponse, some of required attributes are not set " + attributes;
    }
  }
}
