package org.cloudfoundry.uaa.clients;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.uaa.IdentityZoned;
import org.immutables.value.Generated;

/**
 * The request payload for Update Metadata
 */
@Generated(from = "_UpdateMetadataRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class UpdateMetadataRequest extends org.cloudfoundry.uaa.clients._UpdateMetadataRequest {
  private final @Nullable String identityZoneId;
  private final @Nullable String identityZoneSubdomain;
  private final @Nullable String appIcon;
  private final @Nullable String appLaunchUrl;
  private final String clientId;
  private final @Nullable String clientName;
  private final @Nullable Boolean showOnHomePage;

  private UpdateMetadataRequest(UpdateMetadataRequest.Builder builder) {
    this.identityZoneId = builder.identityZoneId;
    this.identityZoneSubdomain = builder.identityZoneSubdomain;
    this.appIcon = builder.appIcon;
    this.appLaunchUrl = builder.appLaunchUrl;
    this.clientId = builder.clientId;
    this.clientName = builder.clientName;
    this.showOnHomePage = builder.showOnHomePage;
  }

  /**
   * Returns the identity zone id
   * @return the identity zone id
   */
  @JsonProperty("identityZoneId")
  @JsonIgnore
  @Override
  public @Nullable String getIdentityZoneId() {
    return identityZoneId;
  }

  /**
   * Returns the identity zone subdomain
   * @return the identity zone subdomain
   */
  @JsonProperty("identityZoneSubdomain")
  @JsonIgnore
  @Override
  public @Nullable String getIdentityZoneSubdomain() {
    return identityZoneSubdomain;
  }

  /**
   * Base64 encoded image file
   */
  @JsonProperty("appIcon")
  @Override
  public @Nullable String getAppIcon() {
    return appIcon;
  }

  /**
   * URL to which the app is linked
   */
  @JsonProperty("appLaunchUrl")
  @Override
  public @Nullable String getAppLaunchUrl() {
    return appLaunchUrl;
  }

  /**
   * Client identifier, unique within identity zone
   */
  @JsonProperty("clientId")
  @Override
  public String getClientId() {
    return clientId;
  }

  /**
   * Client name
   */
  @JsonProperty("clientName")
  @Override
  public @Nullable String getClientName() {
    return clientName;
  }

  /**
   * Flag to control visibility on home page
   */
  @JsonProperty("showOnHomePage")
  @Override
  public @Nullable Boolean getShowOnHomePage() {
    return showOnHomePage;
  }

  /**
   * This instance is equal to all instances of {@code UpdateMetadataRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof UpdateMetadataRequest
        && equalTo(0, (UpdateMetadataRequest) another);
  }

  private boolean equalTo(int synthetic, UpdateMetadataRequest another) {
    return Objects.equals(identityZoneId, another.identityZoneId)
        && Objects.equals(identityZoneSubdomain, another.identityZoneSubdomain)
        && Objects.equals(appIcon, another.appIcon)
        && Objects.equals(appLaunchUrl, another.appLaunchUrl)
        && clientId.equals(another.clientId)
        && Objects.equals(clientName, another.clientName)
        && Objects.equals(showOnHomePage, another.showOnHomePage);
  }

  /**
   * Computes a hash code from attributes: {@code identityZoneId}, {@code identityZoneSubdomain}, {@code appIcon}, {@code appLaunchUrl}, {@code clientId}, {@code clientName}, {@code showOnHomePage}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(identityZoneId);
    h += (h << 5) + Objects.hashCode(identityZoneSubdomain);
    h += (h << 5) + Objects.hashCode(appIcon);
    h += (h << 5) + Objects.hashCode(appLaunchUrl);
    h += (h << 5) + clientId.hashCode();
    h += (h << 5) + Objects.hashCode(clientName);
    h += (h << 5) + Objects.hashCode(showOnHomePage);
    return h;
  }

  /**
   * Prints the immutable value {@code UpdateMetadataRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "UpdateMetadataRequest{"
        + "identityZoneId=" + identityZoneId
        + ", identityZoneSubdomain=" + identityZoneSubdomain
        + ", appIcon=" + appIcon
        + ", appLaunchUrl=" + appLaunchUrl
        + ", clientId=" + clientId
        + ", clientName=" + clientName
        + ", showOnHomePage=" + showOnHomePage
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_UpdateMetadataRequest", generator = "Immutables")
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.uaa.clients._UpdateMetadataRequest {
    String identityZoneId;
    String identityZoneSubdomain;
    String appIcon;
    String appLaunchUrl;
    String clientId;
    String clientName;
    Boolean showOnHomePage;
    @JsonProperty("identityZoneId")
    @JsonIgnore
    public void setIdentityZoneId(@Nullable String identityZoneId) {
      this.identityZoneId = identityZoneId;
    }
    @JsonProperty("identityZoneSubdomain")
    @JsonIgnore
    public void setIdentityZoneSubdomain(@Nullable String identityZoneSubdomain) {
      this.identityZoneSubdomain = identityZoneSubdomain;
    }
    @JsonProperty("appIcon")
    public void setAppIcon(@Nullable String appIcon) {
      this.appIcon = appIcon;
    }
    @JsonProperty("appLaunchUrl")
    public void setAppLaunchUrl(@Nullable String appLaunchUrl) {
      this.appLaunchUrl = appLaunchUrl;
    }
    @JsonProperty("clientId")
    public void setClientId(String clientId) {
      this.clientId = clientId;
    }
    @JsonProperty("clientName")
    public void setClientName(@Nullable String clientName) {
      this.clientName = clientName;
    }
    @JsonProperty("showOnHomePage")
    public void setShowOnHomePage(@Nullable Boolean showOnHomePage) {
      this.showOnHomePage = showOnHomePage;
    }
    @Override
    public String getIdentityZoneId() { throw new UnsupportedOperationException(); }
    @Override
    public String getIdentityZoneSubdomain() { throw new UnsupportedOperationException(); }
    @Override
    public String getAppIcon() { throw new UnsupportedOperationException(); }
    @Override
    public String getAppLaunchUrl() { throw new UnsupportedOperationException(); }
    @Override
    public String getClientId() { throw new UnsupportedOperationException(); }
    @Override
    public String getClientName() { throw new UnsupportedOperationException(); }
    @Override
    public Boolean getShowOnHomePage() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static UpdateMetadataRequest fromJson(Json json) {
    UpdateMetadataRequest.Builder builder = UpdateMetadataRequest.builder();
    if (json.identityZoneId != null) {
      builder.identityZoneId(json.identityZoneId);
    }
    if (json.identityZoneSubdomain != null) {
      builder.identityZoneSubdomain(json.identityZoneSubdomain);
    }
    if (json.appIcon != null) {
      builder.appIcon(json.appIcon);
    }
    if (json.appLaunchUrl != null) {
      builder.appLaunchUrl(json.appLaunchUrl);
    }
    if (json.clientId != null) {
      builder.clientId(json.clientId);
    }
    if (json.clientName != null) {
      builder.clientName(json.clientName);
    }
    if (json.showOnHomePage != null) {
      builder.showOnHomePage(json.showOnHomePage);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link UpdateMetadataRequest UpdateMetadataRequest}.
   * <pre>
   * UpdateMetadataRequest.builder()
   *    .identityZoneId(String | null) // nullable {@link UpdateMetadataRequest#getIdentityZoneId() identityZoneId}
   *    .identityZoneSubdomain(String | null) // nullable {@link UpdateMetadataRequest#getIdentityZoneSubdomain() identityZoneSubdomain}
   *    .appIcon(String | null) // nullable {@link UpdateMetadataRequest#getAppIcon() appIcon}
   *    .appLaunchUrl(String | null) // nullable {@link UpdateMetadataRequest#getAppLaunchUrl() appLaunchUrl}
   *    .clientId(String) // required {@link UpdateMetadataRequest#getClientId() clientId}
   *    .clientName(String | null) // nullable {@link UpdateMetadataRequest#getClientName() clientName}
   *    .showOnHomePage(Boolean | null) // nullable {@link UpdateMetadataRequest#getShowOnHomePage() showOnHomePage}
   *    .build();
   * </pre>
   * @return A new UpdateMetadataRequest builder
   */
  public static UpdateMetadataRequest.Builder builder() {
    return new UpdateMetadataRequest.Builder();
  }

  /**
   * Builds instances of type {@link UpdateMetadataRequest UpdateMetadataRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_UpdateMetadataRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_CLIENT_ID = 0x1L;
    private long initBits = 0x1L;

    private String identityZoneId;
    private String identityZoneSubdomain;
    private String appIcon;
    private String appLaunchUrl;
    private String clientId;
    private String clientName;
    private Boolean showOnHomePage;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code UpdateMetadataRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(UpdateMetadataRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _UpdateMetadataRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(_UpdateMetadataRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.uaa.IdentityZoned} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(IdentityZoned instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    private void from(short _unused, Object object) {
      if (object instanceof org.cloudfoundry.uaa.clients._UpdateMetadataRequest) {
        org.cloudfoundry.uaa.clients._UpdateMetadataRequest instance = (org.cloudfoundry.uaa.clients._UpdateMetadataRequest) object;
        String appIconValue = instance.getAppIcon();
        if (appIconValue != null) {
          appIcon(appIconValue);
        }
        this.clientId(instance.getClientId());
        Boolean showOnHomePageValue = instance.getShowOnHomePage();
        if (showOnHomePageValue != null) {
          showOnHomePage(showOnHomePageValue);
        }
        String clientNameValue = instance.getClientName();
        if (clientNameValue != null) {
          clientName(clientNameValue);
        }
        String appLaunchUrlValue = instance.getAppLaunchUrl();
        if (appLaunchUrlValue != null) {
          appLaunchUrl(appLaunchUrlValue);
        }
      }
      if (object instanceof IdentityZoned) {
        IdentityZoned instance = (IdentityZoned) object;
        String identityZoneSubdomainValue = instance.getIdentityZoneSubdomain();
        if (identityZoneSubdomainValue != null) {
          identityZoneSubdomain(identityZoneSubdomainValue);
        }
        String identityZoneIdValue = instance.getIdentityZoneId();
        if (identityZoneIdValue != null) {
          identityZoneId(identityZoneIdValue);
        }
      }
    }

    /**
     * Initializes the value for the {@link UpdateMetadataRequest#getIdentityZoneId() identityZoneId} attribute.
     * @param identityZoneId The value for identityZoneId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder identityZoneId(@Nullable String identityZoneId) {
      this.identityZoneId = identityZoneId;
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateMetadataRequest#getIdentityZoneSubdomain() identityZoneSubdomain} attribute.
     * @param identityZoneSubdomain The value for identityZoneSubdomain (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder identityZoneSubdomain(@Nullable String identityZoneSubdomain) {
      this.identityZoneSubdomain = identityZoneSubdomain;
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateMetadataRequest#getAppIcon() appIcon} attribute.
     * @param appIcon The value for appIcon (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder appIcon(@Nullable String appIcon) {
      this.appIcon = appIcon;
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateMetadataRequest#getAppLaunchUrl() appLaunchUrl} attribute.
     * @param appLaunchUrl The value for appLaunchUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder appLaunchUrl(@Nullable String appLaunchUrl) {
      this.appLaunchUrl = appLaunchUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateMetadataRequest#getClientId() clientId} attribute.
     * @param clientId The value for clientId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder clientId(String clientId) {
      this.clientId = Objects.requireNonNull(clientId, "clientId");
      initBits &= ~INIT_BIT_CLIENT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateMetadataRequest#getClientName() clientName} attribute.
     * @param clientName The value for clientName (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder clientName(@Nullable String clientName) {
      this.clientName = clientName;
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateMetadataRequest#getShowOnHomePage() showOnHomePage} attribute.
     * @param showOnHomePage The value for showOnHomePage (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder showOnHomePage(@Nullable Boolean showOnHomePage) {
      this.showOnHomePage = showOnHomePage;
      return this;
    }

    /**
     * Builds a new {@link UpdateMetadataRequest UpdateMetadataRequest}.
     * @return An immutable instance of UpdateMetadataRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public UpdateMetadataRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new UpdateMetadataRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_CLIENT_ID) != 0) attributes.add("clientId");
      return "Cannot build UpdateMetadataRequest, some of required attributes are not set " + attributes;
    }
  }
}
